/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IOdaDataSourceModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.extension.oda.ODAProviderFactory;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;

public class OdaDataSource
extends DataSource
implements IExtendableElement,
IOdaDataSourceModel,
IOdaExtendableElementModel {
    protected String extensionID = null;
    private ODAProvider provider = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OdaDataSource() {
    }

    public OdaDataSource(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitOdaDataSource(this);
    }

    public String getElementName() {
        return "OdaDataSource";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public OdaDataSourceHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new OdaDataSourceHandle(module, this);
        }
        return (OdaDataSourceHandle)this.handle;
    }

    public ExtensionElementDefn getExtDefn() {
        if (this.provider != null) {
            return this.provider.getExtDefn();
        }
        return null;
    }

    public List getPropertyDefns() {
        if (this.provider != null) {
            return this.provider.getPropertyDefns();
        }
        return super.getPropertyDefns();
    }

    public ElementPropertyDefn getPropertyDefn(String propName) {
        if (!$assertionsDisabled && propName == null) {
            throw new AssertionError();
        }
        ElementPropertyDefn propDefn = super.getPropertyDefn(propName);
        if (propDefn != null) {
            return propDefn;
        }
        if (this.provider != null) {
            return (ElementPropertyDefn)this.provider.getPropertyDefn(propName);
        }
        return propDefn;
    }

    protected Object getIntrinsicProperty(String propName) {
        if ("extensionID".equals(propName)) {
            return this.extensionID;
        }
        return super.getIntrinsicProperty(propName);
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if ("extensionID".equals(propName)) {
            this.extensionID = (String)value;
            this.provider = this.extensionID != null ? ODAProviderFactory.getInstance().createODAProvider(this, this.extensionID) : null;
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    public void checkExtends(DesignElement parent) throws ExtendsException {
        super.checkExtends(parent);
        if (this.provider != null) {
            this.provider.checkExtends(parent);
        } else {
            OdaDataSource odaParent = (OdaDataSource)parent;
            if (odaParent.extensionID != null && !odaParent.extensionID.equals(this.extensionID)) {
                throw new WrongTypeException((DesignElement)this, parent, "Error.WrongTypeException.WRONG_EXTENSION_TYPE");
            }
            if (this.extensionID != null && !this.extensionID.equals(odaParent.extensionID)) {
                throw new WrongTypeException((DesignElement)this, parent, "Error.WrongTypeException.WRONG_EXTENSION_TYPE");
            }
        }
    }

    public List validate(Module module) {
        List list = super.validate(module);
        return list;
    }

    static {
        $assertionsDisabled = !OdaDataSource.class.desiredAssertionStatus();
    }
}

