/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class CellPropSearchStrategy
extends PropertySearchStrategy {
    private static final CellPropSearchStrategy instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CellPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    public Object getPropertyRelatedToContainer(Module module, DesignElement cell, ElementPropertyDefn prop) {
        for (DesignElement e = cell.getContainer(); e != null; e = e.getContainer()) {
            Object value = e.getStrategy().getPropertyFromElement(module, e, prop);
            if (value != null) {
                return value;
            }
            if (!(e.getContainer() instanceof TableItem) && !(e.getContainer() instanceof GridItem)) continue;
            return this.getColumnProperty(module, e.getContainer(), (Cell)cell, prop);
        }
        return super.getPropertyRelatedToContainer(module, cell, prop);
    }

    public Object getColumnProperty(Module module, DesignElement container, Cell cell, ElementPropertyDefn prop) {
        Object value = null;
        if (container instanceof TableItem) {
            TableItem table = (TableItem)container;
            value = this.getPropertyFromColumn(module, table, cell, prop);
        }
        if (container instanceof GridItem) {
            GridItem grid = (GridItem)container;
            value = this.getPropertyFromColumn(module, grid, cell, prop);
        }
        return value;
    }

    protected Object getPropertyFromColumn(Module module, TableItem table, Cell target, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && !prop.isStyleProperty()) {
            throw new AssertionError();
        }
        ContainerSlot columnSlot = table.getSlot(4);
        if (columnSlot.getCount() == 0) {
            return null;
        }
        int columnNum = target.getColumn(module);
        if (columnNum == 0) {
            columnNum = table.getColumnPosition4Cell(module, target);
        }
        if (columnNum == 0) {
            return null;
        }
        TableColumn column = ColumnHelper.findColumn(module, columnSlot, columnNum);
        if (column != null) {
            return this.getPropertyFromElement(module, column, prop);
        }
        return null;
    }

    protected Object getPropertyFromColumn(Module module, GridItem grid, Cell target, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && !prop.isStyleProperty()) {
            throw new AssertionError();
        }
        ContainerSlot columnSlot = grid.getSlot(0);
        if (columnSlot.getCount() == 0) {
            return null;
        }
        int columnNum = grid.getCellPositionInColumn(module, target);
        if (!$assertionsDisabled && columnNum <= 0) {
            throw new AssertionError();
        }
        TableColumn column = ColumnHelper.findColumn(module, columnSlot, columnNum);
        if (column != null) {
            return this.getPropertyFromElement(module, column, prop);
        }
        return null;
    }

    protected boolean isInheritableProperty(DesignElement element, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if ("verticalAlign".equalsIgnoreCase(prop.getName()) && element.getContainer() instanceof TableRow) {
            return true;
        }
        return super.isInheritableProperty(element, prop);
    }

    static {
        $assertionsDisabled = !CellPropSearchStrategy.class.desiredAssertionStatus();
        instance = new CellPropSearchStrategy();
    }
}

