/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.UserChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;

public class ChoiceSet
implements Cloneable,
IChoiceSet {
    protected String name = null;
    protected ArrayList choices = null;

    public ChoiceSet(String theName) {
        this.name = theName;
    }

    public Object clone() throws CloneNotSupportedException {
        ChoiceSet set = (ChoiceSet)super.clone();
        if (this.choices != null) {
            for (int i = 0; i < this.choices.size(); ++i) {
                set.choices.add(((IChoice)this.choices.get(i)).copy());
            }
        }
        return set;
    }

    public ChoiceSet() {
    }

    public boolean contains(String choiceName) {
        return this.findChoice(choiceName) != null;
    }

    public boolean isUserDefined() {
        if (this.choices == null || this.choices.size() == 0) {
            return false;
        }
        return this.choices.get(0) instanceof UserChoice;
    }

    public void setChoices(IChoice[] choiceArray) {
        if (this.choices == null) {
            this.choices = new ArrayList();
        }
        for (int i = 0; i < choiceArray.length; ++i) {
            this.choices.add(choiceArray[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public IChoice[] getChoices() {
        if (this.choices == null) {
            return null;
        }
        IChoice[] retChoices = new IChoice[this.choices.size()];
        this.choices.toArray(retChoices);
        return retChoices;
    }

    public IChoice[] getChoices(Comparator c) {
        if (this.choices == null) {
            return null;
        }
        IChoice[] retChoices = new IChoice[this.choices.size()];
        this.choices.toArray(retChoices);
        Arrays.sort(retChoices, c);
        return retChoices;
    }

    public IChoice findChoice(String name) {
        IChoice choice = null;
        for (int i = 0; i < this.choices.size(); ++i) {
            choice = (IChoice)this.choices.get(i);
            if (!choice.getName().equalsIgnoreCase(name)) continue;
            return choice;
        }
        return null;
    }

    public IChoice findChoiceByDisplayName(String name) {
        IChoice choice = null;
        for (int i = 0; i < this.choices.size(); ++i) {
            choice = (IChoice)this.choices.get(i);
            String displayName = choice.getDisplayName();
            if (displayName == null || !displayName.equalsIgnoreCase(name)) continue;
            return choice;
        }
        return null;
    }

    public UserChoice findUserChoiceByDisplayName(Module module, String name) {
        UserChoice choice = null;
        for (int i = 0; i < this.choices.size(); ++i) {
            choice = (UserChoice)this.choices.get(i);
            String displayName = module.getMessage(choice.getDisplayNameKey());
            if (displayName != null && displayName.equalsIgnoreCase(name)) {
                return choice;
            }
            displayName = choice.getDisplayName();
            if (displayName == null || !displayName.equalsIgnoreCase(name)) continue;
            return choice;
        }
        return null;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }
}

