/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ContentIterator;

public class ElementStructureUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean updateStructureFromParent(DesignElement child, DesignElement parent) {
        if (child == null || parent == null) {
            return false;
        }
        if (child.getExtendsElement() != parent) {
            return false;
        }
        Map overriddenValues = ElementStructureUtil.collectPropertyValues(child);
        boolean retValue = ElementStructureUtil.duplicateStructure(parent, child);
        ElementStructureUtil.distributeValues(child, overriddenValues);
        return retValue;
    }

    public static void distributeValues(DesignElement element, Map overriddenValues) {
        if (element == null) {
            return;
        }
        ContentIterator contentIterator = new ContentIterator(element);
        while (contentIterator.hasNext()) {
            List values;
            DesignElement content = (DesignElement)contentIterator.next();
            Long baseId = new Long(content.getID());
            if (overriddenValues == null || overriddenValues.isEmpty() || (values = (List)overriddenValues.get(baseId)) == null || values.isEmpty()) continue;
            for (int i = 0; i < values.size(); ++i) {
                Property prop = (Property)values.get(i);
                if ("style".equals(prop.getName())) {
                    ((StyledElement)content).setStyleName((String)prop.getValue());
                    continue;
                }
                content.setProperty(prop.getName(), prop.getValue());
            }
        }
    }

    public static Map collectPropertyValues(DesignElement element) {
        HashMap map = new HashMap();
        Module root = element.getRoot();
        ContentIterator contentIterator = new ContentIterator(element);
        while (contentIterator.hasNext()) {
            DesignElement content = (DesignElement)contentIterator.next();
            Long baseId = new Long(content.getBaseId());
            ArrayList<Property> values = (ArrayList<Property>)map.get(baseId);
            if (values == null) {
                values = new ArrayList<Property>();
                map.put(baseId, values);
            }
            List propDefns = null;
            propDefns = content instanceof ExtendedItem ? ((ExtendedItem)content).getExtDefn().getProperties() : content.getPropertyDefns();
            for (int i = 0; i < propDefns.size(); ++i) {
                String propName;
                Object propValue;
                PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
                if ("name".equalsIgnoreCase(propDefn.getName()) || "extends".equalsIgnoreCase(propDefn.getName()) || content instanceof ExtendedItem && "extensionName".equalsIgnoreCase(propDefn.getName()) || (propValue = content.getLocalProperty(root, propName = propDefn.getName())) == null) continue;
                if ("style".equals(propName)) {
                    ReferenceValue refValue = (ReferenceValue)propValue;
                    propValue = refValue.getName();
                }
                values.add(new Property(propName, propValue));
            }
        }
        return map;
    }

    private static boolean duplicateStructure(DesignElement source, DesignElement target) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && source.getDefn() != target.getDefn()) {
            throw new AssertionError();
        }
        if (source.getDefn().getSlotCount() == 0) {
            return true;
        }
        DesignElement cloned = null;
        try {
            cloned = (DesignElement)source.clone();
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }
        ContentIterator sourceIter = new ContentIterator(source);
        ContentIterator clonedIter = new ContentIterator(cloned);
        while (clonedIter.hasNext()) {
            DesignElement virtualParent = (DesignElement)sourceIter.next();
            DesignElement virtualChild = (DesignElement)clonedIter.next();
            String name = virtualChild.getName();
            virtualChild.clearAllProperties();
            if (name != null) {
                virtualChild.setName(name);
            }
            virtualChild.setBaseId(virtualParent.getID());
        }
        for (int i = 0; i < source.getDefn().getSlotCount(); ++i) {
            ContainerSlot sourceSlot = cloned.getSlot(i);
            ContainerSlot targetSlot = target.getSlot(i);
            int count = targetSlot.getCount();
            while (--count >= 0) {
                targetSlot.remove(count);
            }
            for (int j = 0; j < sourceSlot.getCount(); ++j) {
                DesignElement content = sourceSlot.getContent(j);
                targetSlot.add(content);
                content.setContainer(target, i);
            }
        }
        return true;
    }

    public static void clearStructure(DesignElement element) {
        if (element == null) {
            return;
        }
        if (element.getDefn().getSlotCount() == 0) {
            return;
        }
        for (int i = 0; i < element.getDefn().getSlotCount(); ++i) {
            ContainerSlot sourceSlot = element.getSlot(i);
            sourceSlot.clear();
        }
    }

    public static void updateContentStructures(DesignElement element, Module module) {
        ContentIterator contentIter = new ContentIterator(element);
        while (contentIter.hasNext()) {
            DesignElement content = (DesignElement)contentIter.next();
            ElementDefn metaData = (ElementDefn)content.getDefn();
            if (!metaData.canExtend()) continue;
            content.getLocalProperty(module, "extends");
            if (content.getExtendsElement() != null) {
                content.refreshStructureFromParent(module);
                continue;
            }
            ElementStructureUtil.clearStructure(content);
        }
    }

    public static void addTheVirualElementsToNamesapce(DesignElement element, Module module) {
        ContentIterator contentIter = new ContentIterator(element);
        while (contentIter.hasNext()) {
            DesignElement virtualElement = (DesignElement)contentIter.next();
            if (virtualElement.getName() == null) continue;
            module.makeUniqueName(virtualElement);
            ElementDefn contentDefn = (ElementDefn)virtualElement.getDefn();
            int id = contentDefn.getNameSpaceID();
            NameSpace ns = module.getNameSpace(id);
            ns.insert(virtualElement);
        }
    }

    static {
        $assertionsDisabled = !ElementStructureUtil.class.desiredAssertionStatus();
    }

    private static class Property {
        private String name;
        private Object value;

        Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        Object getValue() {
            return this.value;
        }
    }
}

