/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.LegendLayoutHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Direction;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.render.BaseRenderer;

public final class LegendBuilder
implements IConstants {
    private Size sz;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Size compute(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc) throws ChartException {
        SeriesDefinition sdBase;
        Map renders;
        Legend lg = cm.getLegend();
        if (!lg.isSetOrientation()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.orientation.horzvert", Messages.getResourceBundle(xs.getULocale()));
        }
        if (!lg.isSetDirection()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.direction.tblr", Messages.getResourceBundle(xs.getULocale()));
        }
        Orientation orientation = lg.getOrientation();
        Direction direction = lg.getDirection();
        double maxWrappingSize = lg.getWrappingSize();
        Label la = LabelImpl.create();
        la.setCaption(TextImpl.copyInstance(lg.getText()));
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        double dSeparatorThickness = lia.getThickness();
        double dWidth = 0.0;
        double dHeight = 0.0;
        la.getCaption().setValue("X");
        ITextMetrics itm = xs.getTextMetrics(la);
        double dItemHeight = itm.getFullHeight();
        double dScale = (double)xs.getDpiResolution() / 72.0;
        Insets insCA = ca.getInsets().scaledInstance(dScale);
        boolean bPaletteByCategory = cm.getLegend().getItemType().getValue() == 1;
        ArrayList<LegendItemHints> legendItems = new ArrayList<LegendItemHints>();
        double dHorizontalSpacing = 3.0 * dScale;
        double dVerticalSpacing = 3.0 * dScale;
        Block bl = cm.getBlock();
        Bounds boFull = bl.getBounds().scaledInstance(dScale);
        Insets ins = bl.getInsets().scaledInstance(dScale);
        Insets lgIns = lg.getInsets().scaledInstance(dScale);
        double dAvailableWidth = boFull.getWidth() - ins.getLeft() - ins.getRight() - lgIns.getLeft() - lgIns.getRight();
        double dAvailableHeight = boFull.getHeight() - ins.getTop() - ins.getBottom() - lgIns.getTop() - lgIns.getBottom() - cm.getTitle().getBounds().scaledInstance(dScale).getHeight();
        boolean bMinSliceDefined = false;
        String sMinSliceLabel = null;
        boolean bMinSliceApplied = false;
        int[] filteredMinSliceEntry = null;
        if (cm instanceof ChartWithoutAxes) {
            bMinSliceDefined = ((ChartWithoutAxes)cm).isSetMinSlice();
            sMinSliceLabel = ((ChartWithoutAxes)cm).getMinSliceLabel();
            sMinSliceLabel = sMinSliceLabel == null || sMinSliceLabel.length() == 0 ? "" : rtc.externalizedMessage(sMinSliceLabel);
        }
        if (bMinSliceDefined && bPaletteByCategory && cm instanceof ChartWithoutAxes && (renders = rtc.getSeriesRenderers()) != null && !((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
            SeriesDefinition sdBase2 = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
            SeriesDefinition[] sdOrtho = (SeriesDefinition[])sdBase2.getSeriesDefinitions().toArray((Object[])new SeriesDefinition[0]);
            DataSetIterator dsiOrtho = null;
            boolean started = false;
            block56: for (int i = 0; i < sdOrtho.length; ++i) {
                Series[] alRuntimeSeries = sdOrtho[i].getRunTimeSeries().toArray(new Series[0]);
                for (int j = 0; j < alRuntimeSeries.length; ++j) {
                    try {
                        dsiOrtho = new DataSetIterator(alRuntimeSeries[j].getDataSet());
                        LegendItemRenderingHints lirh = (LegendItemRenderingHints)renders.get(alRuntimeSeries[j]);
                        if (lirh == null) {
                            filteredMinSliceEntry = null;
                            break block56;
                        }
                        BaseRenderer br = lirh.getRenderer();
                        int[] fsa = br.getFilteredMinSliceEntry(dsiOrtho);
                        if (fsa != null && fsa.length > 0) {
                            bMinSliceApplied = true;
                        }
                        if (!started) {
                            started = true;
                            filteredMinSliceEntry = fsa;
                            continue;
                        }
                        if ((filteredMinSliceEntry = LegendBuilder.getDuplicateIndices(fsa, filteredMinSliceEntry)) != null && filteredMinSliceEntry.length != 0) continue;
                        filteredMinSliceEntry = null;
                        break block56;
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, ex);
                    }
                }
            }
            if (filteredMinSliceEntry == null) {
                filteredMinSliceEntry = new int[]{};
            }
        }
        if (orientation.getValue() == 1) {
            double dMaxW = 0.0;
            double dRealHeight = 0.0;
            double dExtraWidth = 0.0;
            if (bPaletteByCategory) {
                sdBase = null;
                if (cm instanceof ChartWithAxes) {
                    Axis axPrimaryBase = ((ChartWithAxes)cm).getBaseAxes()[0];
                    if (axPrimaryBase.getSeriesDefinitions().isEmpty()) {
                        return SizeImpl.create(0.0, 0.0);
                    }
                    sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
                } else if (cm instanceof ChartWithoutAxes) {
                    if (((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
                        return SizeImpl.create(0.0, 0.0);
                    }
                    sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
                }
                Series seBase = (Series)sdBase.getRunTimeSeries().get(0);
                DataSetIterator dsiBase = null;
                try {
                    dsiBase = new DataSetIterator(seBase.getDataSet());
                }
                catch (Exception ex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                }
                FormatSpecifier fs = null;
                if (sdBase != null) {
                    fs = sdBase.getFormatSpecifier();
                }
                int pos = -1;
                while (dsiBase.hasNext()) {
                    Object obj = dsiBase.next();
                    if (bMinSliceApplied && Arrays.binarySearch(filteredMinSliceEntry, ++pos) >= 0) continue;
                    String lgtext = String.valueOf(obj);
                    if (fs != null) {
                        try {
                            lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                        }
                        catch (ChartException e) {
                            // empty catch block
                        }
                    }
                    la.getCaption().setValue(lgtext);
                    itm.reuse(la, maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dFWidth = bb.getWidth();
                    double dFHeight = bb.getHeight();
                    double dDeltaHeight = insCA.getTop() + dFHeight + insCA.getBottom();
                    if (dHeight + dDeltaHeight > dAvailableHeight) {
                        dExtraWidth += dWidth + insCA.getLeft() + insCA.getRight() + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing;
                        dWidth = dFWidth;
                        dRealHeight = Math.max(dRealHeight, dHeight);
                        dHeight = dDeltaHeight;
                    } else {
                        dWidth = Math.max(dFWidth, dWidth);
                        dHeight += dDeltaHeight;
                    }
                    legendItems.add(new LegendItemHints(1, new Point(dExtraWidth, dHeight - dDeltaHeight), dFWidth, dFHeight, la.getCaption().getValue(), pos));
                }
                if (bMinSliceApplied) {
                    la.getCaption().setValue(sMinSliceLabel);
                    itm.reuse(la, maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dFWidth = bb.getWidth();
                    double dFHeight = bb.getHeight();
                    double dDeltaHeight = insCA.getTop() + dFHeight + insCA.getBottom();
                    if (dHeight + dDeltaHeight > dAvailableHeight) {
                        dExtraWidth += dWidth + insCA.getLeft() + insCA.getRight() + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing;
                        dWidth = dFWidth;
                        dRealHeight = Math.max(dRealHeight, dHeight);
                        dHeight = dDeltaHeight;
                    } else {
                        dWidth = Math.max(dFWidth, dWidth);
                        dHeight += dDeltaHeight;
                    }
                    legendItems.add(new LegendItemHints(5, new Point(dExtraWidth, dHeight - dDeltaHeight), dFWidth, dFHeight, la.getCaption().getValue(), dsiBase.size()));
                }
                dWidth += insCA.getLeft() + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing + insCA.getRight() + dExtraWidth;
                dHeight = Math.max(dRealHeight, dHeight);
            } else if (direction.getValue() == 1) {
                dSeparatorThickness += dVerticalSpacing;
                for (int j = 0; j < seda.length; ++j) {
                    ArrayList al = seda[j].getRunTimeSeries();
                    FormatSpecifier fs = seda[j].getFormatSpecifier();
                    for (int i = 0; i < al.size(); ++i) {
                        Series se = (Series)al.get(i);
                        Object obj = se.getSeriesIdentifier();
                        String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                        if (fs != null) {
                            try {
                                lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                            }
                            catch (ChartException e) {
                                // empty catch block
                            }
                        }
                        la.getCaption().setValue(lgtext);
                        itm.reuse(la, maxWrappingSize);
                        BoundingBox bb = null;
                        try {
                            bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                        double dW = bb.getWidth();
                        double dFHeight = bb.getHeight();
                        double dExtraHeight = 0.0;
                        String extraText = null;
                        double dDeltaHeight = insCA.getTop() + dFHeight + insCA.getBottom();
                        if (lg.isShowValue()) {
                            DataSetIterator dsiBase = null;
                            try {
                                dsiBase = new DataSetIterator(se.getDataSet());
                            }
                            catch (Exception ex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                            }
                            if (dsiBase.hasNext()) {
                                obj = dsiBase.next();
                                String valueText = String.valueOf(obj);
                                if (fs != null) {
                                    try {
                                        lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                    }
                                    catch (ChartException e) {
                                        // empty catch block
                                    }
                                }
                                Label seLabel = LabelImpl.copyInstance(se.getLabel());
                                seLabel.getCaption().setValue(valueText);
                                itm.reuse(seLabel);
                                dW = Math.max(dW, itm.getFullWidth());
                                dExtraHeight = itm.getFullHeight();
                                extraText = seLabel.getCaption().getValue();
                                dDeltaHeight += dExtraHeight + 2.0 * dScale;
                            }
                        }
                        if (dHeight + dDeltaHeight > dAvailableHeight) {
                            dExtraWidth += dMaxW + insCA.getLeft() + insCA.getRight() + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing;
                            dMaxW = dW;
                            dRealHeight = Math.max(dRealHeight, dHeight);
                            dHeight = dDeltaHeight;
                        } else {
                            dMaxW = Math.max(dW, dMaxW);
                            dHeight += dDeltaHeight;
                        }
                        legendItems.add(new LegendItemHints(1, new Point(dExtraWidth, dHeight - dDeltaHeight), dW, dFHeight, la.getCaption().getValue(), dExtraHeight, extraText));
                    }
                    if (j >= seda.length - 1 || lg.getSeparator() != null && !lg.getSeparator().isVisible()) continue;
                    legendItems.add(new LegendItemHints(2, new Point(dExtraWidth, (dHeight += dSeparatorThickness) - dSeparatorThickness / 2.0), dMaxW + insCA.getLeft() + insCA.getRight() + 3.0 * dItemHeight / 2.0, 0.0, null, 0.0, null));
                }
                dWidth = insCA.getLeft() + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing + dMaxW + insCA.getRight() + dExtraWidth;
                dHeight = Math.max(dRealHeight, dHeight);
            } else {
                if (direction.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.direction", new Object[]{direction.getName()}, Messages.getResourceBundle(xs.getULocale()));
                dSeparatorThickness += dHorizontalSpacing;
                for (int j = 0; j < seda.length; ++j) {
                    ArrayList al = seda[j].getRunTimeSeries();
                    FormatSpecifier fs = seda[j].getFormatSpecifier();
                    for (int i = 0; i < al.size(); ++i) {
                        Series se = (Series)al.get(i);
                        Object obj = se.getSeriesIdentifier();
                        String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                        if (fs != null) {
                            try {
                                lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                            }
                            catch (ChartException e) {
                                // empty catch block
                            }
                        }
                        la.getCaption().setValue(lgtext);
                        itm.reuse(la, maxWrappingSize);
                        BoundingBox bb = null;
                        try {
                            bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                        double dW = bb.getWidth();
                        double dFHeight = bb.getHeight();
                        double dExtraHeight = 0.0;
                        String extraText = null;
                        double dDeltaHeight = insCA.getTop() + dFHeight + insCA.getBottom();
                        if (lg.isShowValue()) {
                            DataSetIterator dsiBase = null;
                            try {
                                dsiBase = new DataSetIterator(se.getDataSet());
                            }
                            catch (Exception ex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                            }
                            if (dsiBase.hasNext()) {
                                obj = dsiBase.next();
                                String valueText = String.valueOf(obj);
                                if (fs != null) {
                                    try {
                                        lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                    }
                                    catch (ChartException e) {
                                        // empty catch block
                                    }
                                }
                                Label seLabel = LabelImpl.copyInstance(se.getLabel());
                                seLabel.getCaption().setValue(valueText);
                                itm.reuse(seLabel);
                                dW = Math.max(dW, itm.getFullWidth());
                                dExtraHeight = itm.getFullHeight();
                                extraText = seLabel.getCaption().getValue();
                                dDeltaHeight += itm.getFullHeight() + 2.0 * dScale;
                            }
                        }
                        if (dHeight + dDeltaHeight > dAvailableHeight) {
                            dExtraWidth += dMaxW + insCA.getLeft() + insCA.getRight() + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing;
                            dMaxW = dW;
                            dRealHeight = Math.max(dRealHeight, dHeight);
                            dHeight = dDeltaHeight;
                        } else {
                            dMaxW = Math.max(dW, dMaxW);
                            dHeight += dDeltaHeight;
                        }
                        legendItems.add(new LegendItemHints(1, new Point(dExtraWidth, dHeight - dDeltaHeight), dW, dFHeight, la.getCaption().getValue(), dExtraHeight, extraText));
                    }
                    dExtraWidth += dMaxW + insCA.getLeft() + insCA.getRight() + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing;
                    dMaxW = 0.0;
                    dRealHeight = Math.max(dRealHeight, dHeight);
                    dHeight = 0.0;
                    if (j >= seda.length - 1 || lg.getSeparator() != null && !lg.getSeparator().isVisible()) continue;
                    legendItems.add(new LegendItemHints(2, new Point((dExtraWidth += dSeparatorThickness) - dSeparatorThickness / 2.0, 0.0), 0.0, dRealHeight, null, 0.0, null));
                }
                dWidth += dExtraWidth;
                dHeight = Math.max(dRealHeight, dHeight);
            }
        } else {
            if (orientation.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.orientation", new Object[]{orientation}, Messages.getResourceBundle(xs.getULocale()));
            double dMaxH = 0.0;
            double dRealWidth = 0.0;
            double dExtraHeight = 0.0;
            if (bPaletteByCategory) {
                sdBase = null;
                if (cm instanceof ChartWithAxes) {
                    Axis axPrimaryBase = ((ChartWithAxes)cm).getBaseAxes()[0];
                    if (axPrimaryBase.getSeriesDefinitions().isEmpty()) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.base.axis.no.series.definitions", Messages.getResourceBundle(xs.getULocale()));
                    }
                    sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
                } else if (cm instanceof ChartWithoutAxes) {
                    if (((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.base.axis.no.series.definitions", Messages.getResourceBundle(xs.getULocale()));
                    }
                    sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
                }
                Series seBase = (Series)sdBase.getRunTimeSeries().get(0);
                DataSetIterator dsiBase = null;
                try {
                    dsiBase = new DataSetIterator(seBase.getDataSet());
                }
                catch (Exception ex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                }
                FormatSpecifier fs = null;
                if (sdBase != null) {
                    fs = sdBase.getFormatSpecifier();
                }
                int pos = -1;
                while (dsiBase.hasNext()) {
                    Object obj = dsiBase.next();
                    if (bMinSliceApplied && Arrays.binarySearch(filteredMinSliceEntry, ++pos) >= 0) continue;
                    String lgtext = String.valueOf(obj);
                    if (fs != null) {
                        try {
                            lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                        }
                        catch (ChartException e) {
                            // empty catch block
                        }
                    }
                    la.getCaption().setValue(lgtext);
                    itm.reuse(la, maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dFWidth = bb.getWidth();
                    double dFHeight = bb.getHeight();
                    double dDeltaWidth = insCA.getLeft() + dFWidth + 3.0 * dItemHeight / 2.0 + insCA.getRight();
                    if (dWidth + dDeltaWidth > dAvailableWidth) {
                        dExtraHeight += dHeight + insCA.getTop() + insCA.getBottom() + dVerticalSpacing;
                        dHeight = dFHeight;
                        dRealWidth = Math.max(dRealWidth, dWidth);
                        dWidth = dDeltaWidth;
                    } else {
                        dHeight = Math.max(dFHeight, dHeight);
                        dWidth += dDeltaWidth;
                    }
                    legendItems.add(new LegendItemHints(1, new Point(dWidth - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), pos));
                }
                if (bMinSliceApplied) {
                    la.getCaption().setValue(sMinSliceLabel);
                    itm.reuse(la, maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dFWidth = bb.getWidth();
                    double dFHeight = bb.getHeight();
                    double dDeltaWidth = insCA.getLeft() + dFWidth + 3.0 * dItemHeight / 2.0 + insCA.getRight();
                    if (dWidth + dDeltaWidth > dAvailableWidth) {
                        dExtraHeight += dHeight + insCA.getTop() + insCA.getBottom() + dVerticalSpacing;
                        dHeight = dFHeight;
                        dRealWidth = Math.max(dRealWidth, dWidth);
                        dWidth = dDeltaWidth;
                    } else {
                        dHeight = Math.max(dFHeight, dHeight);
                        dWidth += dDeltaWidth;
                    }
                    legendItems.add(new LegendItemHints(5, new Point(dWidth - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), dsiBase.size()));
                }
                dHeight += dExtraHeight + insCA.getTop() + insCA.getBottom() + dVerticalSpacing;
                dWidth = Math.max(dWidth, dRealWidth);
            } else if (direction.getValue() == 1) {
                dSeparatorThickness += dVerticalSpacing;
                for (int j = 0; j < seda.length; ++j) {
                    dWidth = 0.0;
                    ArrayList al = seda[j].getRunTimeSeries();
                    FormatSpecifier fs = seda[j].getFormatSpecifier();
                    for (int i = 0; i < al.size(); ++i) {
                        double dH;
                        Series se = (Series)al.get(i);
                        Object obj = se.getSeriesIdentifier();
                        String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                        if (fs != null) {
                            try {
                                lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                            }
                            catch (ChartException e) {
                                // empty catch block
                            }
                        }
                        la.getCaption().setValue(lgtext);
                        itm.reuse(la, maxWrappingSize);
                        BoundingBox bb = null;
                        try {
                            bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                        double dFHeight = dH = bb.getHeight();
                        double dFWidth = bb.getWidth();
                        double dEHeight = 0.0;
                        String extraText = null;
                        double dDeltaWidth = insCA.getLeft() + 3.0 * dItemHeight / 2.0 + dFWidth + insCA.getRight() + dHorizontalSpacing;
                        if (lg.isShowValue()) {
                            DataSetIterator dsiBase = null;
                            try {
                                dsiBase = new DataSetIterator(se.getDataSet());
                            }
                            catch (Exception ex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                            }
                            if (dsiBase.hasNext()) {
                                obj = dsiBase.next();
                                String valueText = String.valueOf(obj);
                                if (fs != null) {
                                    try {
                                        lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                    }
                                    catch (ChartException e) {
                                        // empty catch block
                                    }
                                }
                                Label seLabel = LabelImpl.copyInstance(se.getLabel());
                                seLabel.getCaption().setValue(valueText);
                                itm.reuse(seLabel);
                                dEHeight = itm.getFullHeight();
                                extraText = seLabel.getCaption().getValue();
                                dH += dEHeight + 2.0 * dScale;
                                dDeltaWidth = Math.max(dDeltaWidth, itm.getFullWidth());
                            }
                        }
                        if (dWidth + dDeltaWidth > dAvailableWidth) {
                            dExtraHeight += dMaxH + insCA.getTop() + insCA.getBottom() + dVerticalSpacing;
                            dMaxH = dH;
                            dRealWidth = Math.max(dRealWidth, dWidth);
                            dWidth = dDeltaWidth;
                        } else {
                            dMaxH = Math.max(dH, dMaxH);
                            dWidth += dDeltaWidth;
                        }
                        legendItems.add(new LegendItemHints(1, new Point(dWidth - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), dEHeight, extraText));
                    }
                    dExtraHeight += dMaxH + insCA.getTop() + insCA.getBottom() + dVerticalSpacing;
                    dMaxH = 0.0;
                    dRealWidth = Math.max(dRealWidth, dWidth);
                    dWidth = 0.0;
                    if (j >= seda.length - 1 || lg.getSeparator() != null && !lg.getSeparator().isVisible()) continue;
                    dHeight += dSeparatorThickness;
                    legendItems.add(new LegendItemHints(2, new Point(0.0, dExtraHeight - dSeparatorThickness / 2.0), dRealWidth, 0.0, null, 0.0, null));
                }
                dHeight += dExtraHeight;
                dWidth = Math.max(dRealWidth, dWidth);
            } else {
                if (direction.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.direction", new Object[]{direction}, Messages.getResourceBundle(xs.getULocale()));
                dSeparatorThickness += dHorizontalSpacing;
                for (int j = 0; j < seda.length; ++j) {
                    ArrayList al = seda[j].getRunTimeSeries();
                    FormatSpecifier fs = seda[j].getFormatSpecifier();
                    for (int i = 0; i < al.size(); ++i) {
                        double dH;
                        Series se = (Series)al.get(i);
                        Object obj = se.getSeriesIdentifier();
                        String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                        if (fs != null) {
                            try {
                                lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                            }
                            catch (ChartException e) {
                                // empty catch block
                            }
                        }
                        la.getCaption().setValue(lgtext);
                        itm.reuse(la, maxWrappingSize);
                        BoundingBox bb = null;
                        try {
                            bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                        double dFHeight = dH = bb.getHeight();
                        double dFWidth = bb.getWidth();
                        double dEHeight = 0.0;
                        String extraText = null;
                        double dDeltaWidth = insCA.getLeft() + 3.0 * dItemHeight / 2.0 + dFWidth + insCA.getRight() + dHorizontalSpacing;
                        if (lg.isShowValue()) {
                            DataSetIterator dsiBase = null;
                            try {
                                dsiBase = new DataSetIterator(se.getDataSet());
                            }
                            catch (Exception ex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                            }
                            if (dsiBase.hasNext()) {
                                obj = dsiBase.next();
                                String valueText = String.valueOf(obj);
                                if (fs != null) {
                                    try {
                                        lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                    }
                                    catch (ChartException e) {
                                        // empty catch block
                                    }
                                }
                                Label seLabel = LabelImpl.copyInstance(se.getLabel());
                                seLabel.getCaption().setValue(valueText);
                                itm.reuse(seLabel);
                                dEHeight = itm.getFullHeight();
                                extraText = seLabel.getCaption().getValue();
                                dH += dEHeight + 2.0 * dScale;
                                dDeltaWidth = Math.max(dDeltaWidth, itm.getFullWidth());
                            }
                        }
                        if (dWidth + dDeltaWidth > dAvailableWidth) {
                            dExtraHeight += dMaxH + insCA.getTop() + insCA.getBottom() + dVerticalSpacing;
                            dMaxH = dH;
                            dRealWidth = Math.max(dRealWidth, dWidth);
                            dWidth = dDeltaWidth;
                        } else {
                            dMaxH = Math.max(dH, dMaxH);
                            dWidth += dDeltaWidth;
                        }
                        legendItems.add(new LegendItemHints(1, new Point(dWidth - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), dEHeight, extraText));
                    }
                    if (j >= seda.length - 1 || lg.getSeparator() != null && !lg.getSeparator().isVisible()) continue;
                    legendItems.add(new LegendItemHints(2, new Point((dWidth += dSeparatorThickness) - dSeparatorThickness / 2.0, dExtraHeight), 0.0, dMaxH + insCA.getTop() + insCA.getBottom() + dVerticalSpacing, null, 0.0, null));
                }
                dHeight += insCA.getTop() + dVerticalSpacing + insCA.getBottom() + dMaxH + dExtraHeight;
                dWidth = Math.max(dRealWidth, dWidth);
            }
        }
        Label lgTitle = lg.getTitle();
        Size titleSize = null;
        if (lgTitle != null && lgTitle.isSetVisible() && lgTitle.isVisible()) {
            lgTitle = LabelImpl.copyInstance(lgTitle);
            String sPreviousValue = lgTitle.getCaption().getValue();
            lgTitle.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
            BoundingBox bb = null;
            try {
                bb = Methods.computeBox(xs, 3, lgTitle, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
            }
            int iTitlePos = lg.getTitlePosition().getValue();
            if (rtc.isRightToLeft()) {
                if (iTitlePos == 2) {
                    iTitlePos = 3;
                } else if (iTitlePos == 3) {
                    iTitlePos = 2;
                }
            }
            double shadowness = 3.0 * dScale;
            switch (iTitlePos) {
                case 0: 
                case 1: {
                    dHeight += bb.getHeight() + 2.0 * shadowness;
                    dWidth = Math.max(dWidth, bb.getWidth() + 2.0 * shadowness);
                    break;
                }
                case 2: 
                case 3: {
                    dWidth += bb.getWidth() + 2.0 * shadowness;
                    dHeight = Math.max(dHeight, bb.getHeight() + 2.0 * shadowness);
                }
            }
            titleSize = SizeImpl.create(bb.getWidth() + 2.0 * shadowness, bb.getHeight() + 2.0 * shadowness);
        }
        itm.dispose();
        if (rtc != null) {
            LegendItemHints[] liha = legendItems.toArray(new LegendItemHints[0]);
            LegendLayoutHints lilh = new LegendLayoutHints(SizeImpl.create(dWidth, dHeight), titleSize, bMinSliceApplied, sMinSliceLabel, liha);
            rtc.setLegendLayoutHints(lilh);
        }
        this.sz = SizeImpl.create(dWidth, dHeight);
        return this.sz;
    }

    private static int[] getDuplicateIndices(int[] a1, int[] a2) {
        if (a1 == null || a2 == null || a1.length == 0 || a2.length == 0) {
            return null;
        }
        Arrays.sort(a1);
        Arrays.sort(a2);
        if (a1[a1.length - 1] < a2[0] || a1[0] > a2[a2.length - 1]) {
            return null;
        }
        if (a1.length > a2.length) {
            int[] tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        ArrayList<Integer> dup = new ArrayList<Integer>();
        for (int i = 0; i < a1.length; ++i) {
            if (Arrays.binarySearch(a2, a1[i]) < 0) continue;
            dup.add(new Integer(a1[i]));
        }
        if (dup.size() == 0) {
            return null;
        }
        Integer[] ia = dup.toArray(new Integer[0]);
        int[] pia = new int[ia.length];
        for (int i = 0; i < ia.length; ++i) {
            pia[i] = ia[i];
        }
        return pia;
    }

    public final Size getSize() {
        return this.sz;
    }
}

