/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.datafeed;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.datafeed.ResultSetDataSet;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public final class ResultSetWrapper {
    final List liResultSet;
    final String[] saExpressionKeys;
    final int[] iaDataTypes;
    private int[] iaGroupBreaks = null;
    private final Hashtable htLookup;
    private boolean bGroupingApplied = false;
    private static final int[] NO_GROUP_BREAKS = new int[0];
    private final boolean bGrouped;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/datafeed");

    public ResultSetWrapper(Set stExpressionKeys, List liResultSet, boolean bGrouped) {
        this.liResultSet = liResultSet;
        this.saExpressionKeys = stExpressionKeys.toArray(new String[0]);
        this.iaDataTypes = new int[this.saExpressionKeys.length];
        this.setup();
        this.htLookup = new Hashtable();
        for (int i = 0; i < this.saExpressionKeys.length; ++i) {
            this.htLookup.put(this.saExpressionKeys[i], new Integer(i));
        }
        this.iaGroupBreaks = this.findGroupBreaks(bGrouped);
        this.bGrouped = bGrouped;
    }

    private final void setup() {
        Iterator it = this.liResultSet.iterator();
        int iColumnCount = this.iaDataTypes.length;
        boolean[] boaFound = new boolean[iColumnCount];
        while (it.hasNext()) {
            Object[] oaTuple = (Object[])it.next();
            for (int i = 0; i < iColumnCount; ++i) {
                boolean bAllDone = true;
                if (oaTuple[i] == null) continue;
                boaFound[i] = true;
                if (oaTuple[i] instanceof Number) {
                    this.iaDataTypes[i] = 1;
                } else if (oaTuple[i] instanceof String) {
                    this.iaDataTypes[i] = 16;
                } else if (oaTuple[i] instanceof Date || oaTuple[i] instanceof Calendar) {
                    this.iaDataTypes[i] = 8;
                }
                for (int j = 0; j < iColumnCount; ++j) {
                    if (boaFound[j]) continue;
                    bAllDone = false;
                    break;
                }
                if (!bAllDone) continue;
                return;
            }
        }
        logger.log(4, Messages.getString("exception.resultset.data.type.retrieval.failed"));
    }

    public final void applySeriesGrouping(SeriesDefinition sd, String[] saExpressionKeys) throws ChartException {
        if (this.bGroupingApplied) {
            return;
        }
        this.bGroupingApplied = true;
        SeriesGrouping sg = sd.getGrouping();
        if (sg == null) {
            return;
        }
        if (!sg.isEnabled()) {
            return;
        }
        String sFunctionName = sg.getAggregateExpression();
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        IAggregateFunction[] iafa = new IAggregateFunction[iOrthogonalSeriesCount];
        try {
            for (int i = 0; i < iOrthogonalSeriesCount; ++i) {
                iafa[i] = PluginSettings.instance().getAggregateFunction(sFunctionName);
                iafa[i].initialize();
            }
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)((Object)pex));
        }
        DataType dtGrouping = sg.getGroupType();
        if (dtGrouping == DataType.NUMERIC_LITERAL) {
            Series seBaseDesignTime = sd.getDesignTimeSeries();
            Query q = (Query)seBaseDesignTime.getDataDefinition().get(0);
            int iSortColumnIndex = (Integer)this.htLookup.get(q.getDefinition());
            SortOption so = null;
            if (!sd.isSetSorting()) {
                logger.log(2, Messages.getString("warn.unspecified.sorting", new Object[]{sd}, ULocale.getDefault()));
                so = SortOption.ASCENDING_LITERAL;
            } else {
                so = sd.getSorting();
            }
            this.groupNumerically(this.liResultSet, iSortColumnIndex, so, saExpressionKeys, null, sg.getGroupingInterval(), iafa);
        } else if (dtGrouping == DataType.DATE_TIME_LITERAL) {
            Series seBaseDesignTime = sd.getDesignTimeSeries();
            Query q = (Query)seBaseDesignTime.getDataDefinition().get(0);
            int iSortColumnIndex = (Integer)this.htLookup.get(q.getDefinition());
            SortOption so = null;
            if (!sd.isSetSorting()) {
                logger.log(2, Messages.getString("warn.unspecified.sorting", new Object[]{sd}, ULocale.getDefault()));
                so = SortOption.ASCENDING_LITERAL;
            } else {
                so = sd.getSorting();
            }
            this.groupDateTime(this.liResultSet, iSortColumnIndex, so, saExpressionKeys, null, sg.getGroupingInterval(), sg.getGroupingUnit(), iafa);
        } else if (dtGrouping == DataType.TEXT_LITERAL) {
            Series seBaseDesignTime = sd.getDesignTimeSeries();
            Query q = (Query)seBaseDesignTime.getDataDefinition().get(0);
            int iSortColumnIndex = (Integer)this.htLookup.get(q.getDefinition());
            SortOption so = null;
            if (!sd.isSetSorting()) {
                logger.log(2, Messages.getString("warn.unspecified.sorting", new Object[]{sd}, ULocale.getDefault()));
                so = SortOption.ASCENDING_LITERAL;
            } else {
                so = sd.getSorting();
            }
            this.groupTextually(this.liResultSet, iSortColumnIndex, so, saExpressionKeys, null, sg.getGroupingInterval(), iafa);
        }
        this.iaGroupBreaks = this.findGroupBreaks(this.bGrouped);
    }

    private final void groupNumerically(List resultSet, int iSortColumnIndex, SortOption so, String[] saExpressionKeys, NumberDataElement ndeBaseReference, long iGroupingInterval, IAggregateFunction[] iafa) throws ChartException {
        int i;
        Collections.sort(resultSet, new GroupingComparator(iSortColumnIndex, so));
        if (ndeBaseReference == null) {
            Number obj = (Number)((Object[])resultSet.get(0))[iSortColumnIndex];
            ndeBaseReference = NumberDataElementImpl.create(obj == null ? 0.0 : obj.doubleValue());
        }
        Iterator it = resultSet.iterator();
        Object[] oaSummarizedTuple = null;
        int iGroupIndex = 0;
        int iLastGroupIndex = 0;
        boolean bFirst = true;
        boolean bGroupBreak = false;
        double dBaseReference = ndeBaseReference.getValue();
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        for (i = 0; i < iOrthogonalSeriesCount; ++i) {
            iaColumnIndexes[i] = (Integer)this.htLookup.get(saExpressionKeys[i]);
        }
        while (it.hasNext()) {
            Object[] oaTuple = (Object[])it.next();
            iGroupIndex = oaTuple[iSortColumnIndex] != null ? (iGroupingInterval == 0L ? ++iGroupIndex : (int)Math.floor(Math.abs((((Number)oaTuple[iSortColumnIndex]).doubleValue() - dBaseReference) / (double)iGroupingInterval))) : (iGroupingInterval == 0L ? ++iGroupIndex : (int)Math.floor(Math.abs(dBaseReference / (double)iGroupingInterval)));
            if (!bFirst) {
                boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
            }
            if (bGroupBreak || bFirst) {
                if (oaSummarizedTuple != null) {
                    for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                        oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
                        iafa[i].initialize();
                    }
                } else {
                    bFirst = false;
                }
                oaSummarizedTuple = oaTuple;
            } else {
                it.remove();
            }
            for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                try {
                    iafa[i].accumulate(oaTuple[iaColumnIndexes[i]]);
                    continue;
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
            }
            iLastGroupIndex = iGroupIndex;
        }
        if (oaSummarizedTuple != null) {
            for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
            }
        }
    }

    private int groupingUnit2CDateUnit(GroupingUnitType unit) {
        if (unit != null) {
            switch (unit.getValue()) {
                case 0: {
                    return 13;
                }
                case 1: {
                    return 12;
                }
                case 2: {
                    return 11;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 1;
                }
            }
        }
        return 14;
    }

    private final void groupDateTime(List resultSet, int iSortColumnIndex, SortOption so, String[] saExpressionKeys, CDateTime ndeBaseReference, long iGroupingInterval, GroupingUnitType groupingUnit, IAggregateFunction[] iafa) throws ChartException {
        int i;
        Collections.sort(resultSet, new GroupingComparator(iSortColumnIndex, so));
        if (ndeBaseReference == null) {
            Object obj = ((Object[])resultSet.get(0))[iSortColumnIndex];
            ndeBaseReference = obj instanceof CDateTime ? (CDateTime)((Object)obj) : (obj instanceof Calendar ? new CDateTime((Calendar)obj) : (obj instanceof Date ? new CDateTime((Date)obj) : new CDateTime(0L)));
        }
        Iterator it = resultSet.iterator();
        Object[] oaSummarizedTuple = null;
        int iGroupIndex = 0;
        int iLastGroupIndex = 0;
        boolean bFirst = true;
        boolean bGroupBreak = false;
        CDateTime dBaseReference = ndeBaseReference;
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        for (int i2 = 0; i2 < iOrthogonalSeriesCount; ++i2) {
            iaColumnIndexes[i2] = (Integer)this.htLookup.get(saExpressionKeys[i2]);
        }
        int cunit = this.groupingUnit2CDateUnit(groupingUnit);
        while (it.hasNext()) {
            Object[] oaTuple = (Object[])it.next();
            if (oaTuple[iSortColumnIndex] != null) {
                if (iGroupingInterval == 0L) {
                    ++iGroupIndex;
                } else {
                    CDateTime dBaseValue = null;
                    Object obj = oaTuple[iSortColumnIndex];
                    dBaseValue = obj instanceof CDateTime ? (CDateTime)((Object)obj) : (obj instanceof Calendar ? new CDateTime((Calendar)obj) : (obj instanceof Date ? new CDateTime((Date)obj) : new CDateTime()));
                    double diff = CDateTime.computeDifference(dBaseValue, dBaseReference, cunit);
                    iGroupIndex = (int)Math.floor(Math.abs(diff / (double)iGroupingInterval));
                }
            } else if (iGroupingInterval == 0L) {
                ++iGroupIndex;
            } else {
                CDateTime dBaseValue = new CDateTime(0L);
                double diff = CDateTime.computeDifference(dBaseValue, dBaseReference, cunit);
                iGroupIndex = (int)Math.floor(Math.abs(diff / (double)iGroupingInterval));
            }
            if (!bFirst) {
                boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
            }
            if (bGroupBreak || bFirst) {
                if (oaSummarizedTuple != null) {
                    for (int i3 = 0; i3 < iOrthogonalSeriesCount; ++i3) {
                        oaSummarizedTuple[iaColumnIndexes[i3]] = iafa[i3].getAggregatedValue();
                        iafa[i3].initialize();
                    }
                } else {
                    bFirst = false;
                }
                oaSummarizedTuple = oaTuple;
            } else {
                it.remove();
            }
            for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                try {
                    iafa[i].accumulate(oaTuple[iaColumnIndexes[i]]);
                    continue;
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
            }
            iLastGroupIndex = iGroupIndex;
        }
        if (oaSummarizedTuple != null) {
            for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
            }
        }
    }

    private final void groupTextually(List resultSet, int iSortColumnIndex, SortOption so, String[] saExpressionKeys, String ndeBaseReference, long iGroupingInterval, IAggregateFunction[] iafa) throws ChartException {
        int i;
        Collections.sort(resultSet, new GroupingComparator(iSortColumnIndex, so));
        if (ndeBaseReference == null) {
            ndeBaseReference = ChartUtil.stringValue(((Object[])resultSet.get(0))[iSortColumnIndex]);
        }
        Iterator it = resultSet.iterator();
        Object[] oaSummarizedTuple = null;
        int iGroupIndex = 0;
        int iLastGroupIndex = 0;
        int iGroupCounter = 0;
        boolean bFirst = true;
        boolean bGroupBreak = false;
        String dBaseReference = ndeBaseReference;
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        for (i = 0; i < iOrthogonalSeriesCount; ++i) {
            iaColumnIndexes[i] = (Integer)this.htLookup.get(saExpressionKeys[i]);
        }
        while (it.hasNext()) {
            Object[] oaTuple = (Object[])it.next();
            if (oaTuple[iSortColumnIndex] != null) {
                String dBaseValue = String.valueOf(oaTuple[iSortColumnIndex]);
                if (!dBaseValue.equals(dBaseReference)) {
                    ++iGroupCounter;
                    dBaseReference = dBaseValue;
                }
                if ((long)iGroupCounter > iGroupingInterval) {
                    ++iGroupIndex;
                }
            } else {
                if (dBaseReference != null) {
                    ++iGroupCounter;
                    dBaseReference = null;
                }
                if ((long)iGroupCounter > iGroupingInterval) {
                    ++iGroupIndex;
                }
            }
            if (!bFirst) {
                boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
            }
            if (bGroupBreak) {
                iGroupCounter = 0;
            }
            if (bGroupBreak || bFirst) {
                if (oaSummarizedTuple != null) {
                    for (int i2 = 0; i2 < iOrthogonalSeriesCount; ++i2) {
                        oaSummarizedTuple[iaColumnIndexes[i2]] = iafa[i2].getAggregatedValue();
                        iafa[i2].initialize();
                    }
                } else {
                    bFirst = false;
                }
                oaSummarizedTuple = oaTuple;
            } else {
                it.remove();
            }
            for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                try {
                    iafa[i].accumulate(oaTuple[iaColumnIndexes[i]]);
                    continue;
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
            }
            iLastGroupIndex = iGroupIndex;
        }
        if (oaSummarizedTuple != null) {
            for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
            }
        }
    }

    public final int getGroupCount() {
        return this.iaGroupBreaks.length + 1;
    }

    public final int getGroupRowCount(int iGroupIndex) {
        int startRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        int endRow = iGroupIndex > this.iaGroupBreaks.length - 1 ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex];
        return endRow - startRow;
    }

    public final int getColumnCount() {
        return this.saExpressionKeys.length;
    }

    public final int getRowCount() {
        return this.liResultSet.size();
    }

    public final Object getGroupKey(int iGroupIndex, String sExpressionKey) {
        if (!this.htLookup.containsKey(sExpressionKey)) {
            return "";
        }
        int iColumnIndex = (Integer)this.htLookup.get(sExpressionKey);
        int iRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        Iterator it = this.liResultSet.iterator();
        int i = 0;
        while (it.hasNext() && i++ < iRow) {
            it.next();
        }
        if (it.hasNext()) {
            return ((Object[])it.next())[iColumnIndex];
        }
        return null;
    }

    public final Object getGroupKey(int iGroupIndex, int iColumnIndex) {
        int iRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        Iterator it = this.liResultSet.iterator();
        int i = 0;
        while (it.hasNext() && i++ < iRow) {
            it.next();
        }
        if (it.hasNext()) {
            return ((Object[])it.next())[iColumnIndex];
        }
        return null;
    }

    public final ResultSetDataSet getSubset(int iGroupIndex, String sExpressionKey) {
        return new ResultSetDataSet(this, new int[]{(Integer)this.htLookup.get(sExpressionKey)}, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex >= this.iaGroupBreaks.length - 1 ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public final ResultSetDataSet getSubset(int iGroupIndex, EList elExpressionKeys) {
        int n = elExpressionKeys.size();
        int[] iaColumnIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            String sExpressionKey = ((Query)elExpressionKeys.get(i)).getDefinition();
            iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpressionKey);
        }
        return new ResultSetDataSet(this, iaColumnIndexes, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex > this.iaGroupBreaks.length - 1 ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public final ResultSetDataSet getSubset(int iGroupIndex, String[] sExpressionKeys) {
        if (sExpressionKeys == null) {
            return null;
        }
        int n = sExpressionKeys.length;
        int[] iaColumnIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            String sExpressionKey = sExpressionKeys[i];
            iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpressionKey);
        }
        return new ResultSetDataSet(this, iaColumnIndexes, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex > this.iaGroupBreaks.length - 1 ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public final ResultSetDataSet getSubset(int iGroupIndex, int iColumnIndex) {
        return new ResultSetDataSet(this, new int[]{iColumnIndex}, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex >= this.iaGroupBreaks.length ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public final ResultSetDataSet getSubset(EList elExpressions) throws ChartException {
        int n = elExpressions.size();
        int[] iaColumnIndexes = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                String sExpression = ((Query)elExpressions.get(i)).getDefinition();
                iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpression);
            }
        }
        catch (Exception e) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle());
        }
        return new ResultSetDataSet(this, iaColumnIndexes, 0L, this.getRowCount());
    }

    public final ResultSetDataSet getSubset(String sExpressionKey) {
        return new ResultSetDataSet(this, new int[]{(Integer)this.htLookup.get(sExpressionKey)}, 0L, this.getRowCount());
    }

    public final ResultSetDataSet getSubset(String[] sExpressionKeys) throws ChartException {
        if (sExpressionKeys == null) {
            return null;
        }
        int n = sExpressionKeys.length;
        int[] iaColumnIndexes = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                String sExpression = sExpressionKeys[i];
                iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpression);
            }
        }
        catch (Exception e) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle());
        }
        return new ResultSetDataSet(this, iaColumnIndexes, 0L, this.getRowCount());
    }

    public final ResultSetDataSet getSubset(int iColumnIndex) {
        return new ResultSetDataSet(this, new int[]{iColumnIndex}, 0L, this.getRowCount());
    }

    public final Object[] getMergedGroupingBaseValues(int iColumnIndex, SortOption sorting) {
        int groupCount = this.getGroupCount();
        ArrayList idxList = new ArrayList(groupCount);
        ArrayList<Object> baseValue = new ArrayList<Object>();
        for (int k = 0; k < groupCount; ++k) {
            Object oValue;
            ResultSetDataSet rsd = this.getSubset(k, iColumnIndex);
            ArrayList<Integer> idx = new ArrayList<Integer>();
            if (k == 0) {
                int i = 0;
                while (rsd.hasNext()) {
                    oValue = rsd.next()[0];
                    baseValue.add(oValue);
                    idx.add(new Integer(i++));
                }
            } else {
                while (rsd.hasNext()) {
                    oValue = rsd.next()[0];
                    boolean matched = false;
                    int insertPoint = -1;
                    for (int j = 0; j < baseValue.size(); ++j) {
                        Object ov = baseValue.get(j);
                        int cprt = ResultSetWrapper.compareObjects(oValue, ov);
                        if (cprt == 0) {
                            if (!idx.contains(new Integer(j))) {
                                idx.add(new Integer(j));
                                matched = true;
                                break;
                            }
                            if (sorting == null) continue;
                            insertPoint = j + 1;
                            continue;
                        }
                        if (cprt < 0) {
                            if (sorting != SortOption.DESCENDING_LITERAL) continue;
                            insertPoint = j + 1;
                            continue;
                        }
                        if (cprt <= 0 || sorting != SortOption.ASCENDING_LITERAL) continue;
                        insertPoint = j + 1;
                    }
                    if (matched) continue;
                    if (sorting != null && insertPoint == -1) {
                        insertPoint = 0;
                    }
                    if (insertPoint == -1 || insertPoint >= baseValue.size()) {
                        baseValue.add(oValue);
                        idx.add(new Integer(baseValue.size() - 1));
                        continue;
                    }
                    baseValue.add(insertPoint, oValue);
                    for (int i = 0; i < idx.size(); ++i) {
                        int x = (Integer)idx.get(i);
                        if (x < insertPoint) continue;
                        idx.set(i, new Integer(x + 1));
                    }
                    idx.add(new Integer(insertPoint));
                    Iterator itr = idxList.iterator();
                    while (itr.hasNext()) {
                        List gidx = (List)itr.next();
                        for (int i = 0; i < gidx.size(); ++i) {
                            int x = (Integer)gidx.get(i);
                            if (x < insertPoint) continue;
                            gidx.set(i, new Integer(x + 1));
                        }
                    }
                }
            }
            idxList.add(idx);
        }
        int maxLen = baseValue.size();
        Iterator itr = idxList.iterator();
        while (itr.hasNext()) {
            List lst = (List)itr.next();
            if (lst.size() >= maxLen) continue;
            int inc = maxLen - lst.size();
            for (int i = 0; i < inc; ++i) {
                lst.add(new Integer(-1));
            }
        }
        return new Object[]{baseValue, idxList};
    }

    public final int getColumnDataType(int iColumnIndex) {
        return this.iaDataTypes[iColumnIndex];
    }

    public Iterator iterator() {
        if (this.liResultSet != null) {
            return this.liResultSet.iterator();
        }
        return null;
    }

    private final int[] findGroupBreaks(boolean bGrouped) {
        int iColumnIndex;
        int n = iColumnIndex = bGrouped ? 0 : -1;
        if (iColumnIndex == -1) {
            return NO_GROUP_BREAKS;
        }
        Iterator it = this.liResultSet.iterator();
        ArrayList<Integer> al = new ArrayList<Integer>(16);
        boolean bFirst = true;
        Object oPreviousValue = null;
        int iRowIndex = 0;
        while (it.hasNext()) {
            Object oValue = ((Object[])it.next())[iColumnIndex];
            ++iRowIndex;
            if (bFirst) {
                bFirst = false;
                oPreviousValue = oValue;
                continue;
            }
            if (ResultSetWrapper.compareObjects(oPreviousValue, oValue) != 0) {
                al.add(new Integer(iRowIndex - 1));
            }
            oPreviousValue = oValue;
        }
        int[] ia = new int[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            ia[i] = (Integer)al.get(i);
        }
        return ia;
    }

    public static int compareObjects(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a instanceof String) {
            int iC = a.toString().compareTo(b.toString());
            if (iC != 0) {
                iC = iC < 0 ? -1 : 1;
            }
            return iC;
        }
        if (a instanceof Number) {
            double d2;
            double d1 = ((Number)a).doubleValue();
            return d1 == (d2 = ((Number)b).doubleValue()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Date) {
            long d2;
            long d1 = ((Date)a).getTime();
            return d1 == (d2 = ((Date)b).getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Calendar) {
            long d2;
            long d1 = ((Calendar)a).getTime().getTime();
            return d1 == (d2 = ((Calendar)b).getTime().getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        return ResultSetWrapper.compareObjects(a.toString(), b.toString());
    }

    private static final class GroupingComparator
    implements Comparator {
        private final int iSortKey;
        private final boolean ascending;
        private final Collator collator;

        GroupingComparator(int iSortKey, SortOption so) {
            this.iSortKey = iSortKey;
            this.ascending = so == null || so == SortOption.ASCENDING_LITERAL;
            this.collator = Collator.getInstance();
        }

        public final int compare(Object o1, Object o2) {
            Object[] oaTuple1 = (Object[])o1;
            Object[] oaTuple2 = (Object[])o2;
            Object oC1 = oaTuple1[this.iSortKey];
            Object oC2 = oaTuple2[this.iSortKey];
            if (oC1 == null && oC2 == null) {
                return 0;
            }
            if (oC1 == null && oC2 != null) {
                return this.ascending ? -1 : 1;
            }
            if (oC1 != null && oC2 == null) {
                return this.ascending ? 1 : -1;
            }
            int ct = oC1 instanceof String ? this.collator.compare(oC1.toString(), oC2.toString()) : ((Comparable)oC1).compareTo(oC2);
            return this.ascending ? ct : -ct;
        }
    }
}

