/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.factory;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.util.Date;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;

public class DateFormatWrapperFactory {
    public static final IDateFormatWrapper getPreferredDateFormat(int iUnit) {
        return DateFormatWrapperFactory.getPreferredDateFormat(iUnit, ULocale.getDefault());
    }

    public static final IDateFormatWrapper getPreferredDateFormat(int iUnit, ULocale locale) {
        IDateFormatWrapper df = null;
        switch (iUnit) {
            case 1: {
                df = new DateFormatWrapper((DateFormat)new SimpleDateFormat("yyyy", locale));
                break;
            }
            case 2: {
                df = new MonthDateFormat(locale);
                break;
            }
            case 5: {
                df = new DateFormatWrapper(DateFormat.getDateInstance((int)1, (ULocale)locale));
                break;
            }
            case 11: {
                df = new HourDateFormat(locale);
                break;
            }
            case 12: 
            case 13: {
                df = new DateFormatWrapper((DateFormat)new SimpleDateFormat("HH:mm:ss", locale));
            }
        }
        return df;
    }

    static class MonthDateFormat
    implements IDateFormatWrapper {
        private ULocale locale;

        public MonthDateFormat(ULocale locale) {
            this.locale = locale;
        }

        public String format(Date date) {
            StringBuffer str = new StringBuffer();
            FieldPosition pos = new FieldPosition(3);
            DateFormat df = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
            df.format(date, str, pos);
            int endIndex = pos.getEndIndex() + (str.charAt(pos.getEndIndex()) == ',' ? 2 : 1);
            if (endIndex >= str.length()) {
                return str.substring(0, pos.getBeginIndex());
            }
            return str.substring(0, pos.getBeginIndex()) + str.substring(endIndex);
        }
    }

    static class HourDateFormat
    implements IDateFormatWrapper {
        private ULocale locale;

        public HourDateFormat(ULocale locale) {
            this.locale = locale;
        }

        public String format(Date date) {
            return DateFormat.getDateInstance((int)1, (ULocale)this.locale).format(date) + "\n" + new SimpleDateFormat("HH:mm", this.locale).format(date);
        }
    }

    static class DateFormatWrapper
    implements IDateFormatWrapper {
        private DateFormat formater;

        public DateFormatWrapper(DateFormat formater) {
            this.formater = formater;
        }

        public String format(Date date) {
            return this.formater.format(date);
        }
    }
}

