/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;

public final class ImageCache {
    private Hashtable htImages = new Hashtable();
    private static ImageCache ic = null;

    private ImageCache() {
    }

    public static synchronized ImageCache instance() {
        if (ic == null) {
            ic = new ImageCache();
        }
        return ic;
    }

    public final void clear() {
        this.htImages.clear();
    }

    public final Object getImage(IDisplayServer xs, String sUrl) throws ChartException {
        if (this.htImages.containsKey(sUrl)) {
            return this.htImages.get(sUrl);
        }
        URL u = null;
        try {
            u = new URL(sUrl);
        }
        catch (MalformedURLException muex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 4, muex);
        }
        Object o = xs.loadImage(u);
        this.htImages.put(sUrl, o);
        return o;
    }
}

