/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.RAInputStream;

public class RAFolderInputStream
extends RAInputStream {
    private RandomAccessFile randomFile;

    public RAFolderInputStream(File file) throws FileNotFoundException {
        this.randomFile = new RandomAccessFile(file, "r");
    }

    public int read() throws IOException {
        return this.randomFile.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.randomFile.read(b, off, len);
    }

    public int readInt() throws IOException {
        byte[] ch = new byte[4];
        this.randomFile.readFully(ch, 0, 4);
        int ret = 0;
        for (int i = 0; i < ch.length; ++i) {
            ret = ret << 8 & 0xFFFFFF00 | ch[i] & 0xFF;
        }
        return ret;
    }

    public long readLong() throws IOException {
        return this.randomFile.readLong();
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.randomFile.readFully(b, off, len);
    }

    public long getStreamLength() throws IOException {
        return this.randomFile.length();
    }

    public void seek(long localPos) throws IOException {
        this.randomFile.seek(localPos);
    }

    public long getOffset() throws IOException {
        return this.randomFile.getFilePointer();
    }

    public long length() throws IOException {
        return this.getStreamLength();
    }

    public void close() throws IOException {
        this.randomFile.close();
        super.close();
    }
}

