/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class JavascriptEvalUtil {
    private static Scriptable sharedScope;
    private static Logger logger;
    protected static final int SCRIPT_CACHE_SIZE = 200;
    protected static Map compiledScriptCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Object evaluateRawScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) throws BirtException {
        boolean enterContext;
        Object result = null;
        boolean bl = enterContext = cx == null;
        if (enterContext) {
            cx = Context.enter();
        }
        try {
            Script compiledScript = JavascriptEvalUtil.getCompiledScript(cx, scope, scriptText, source, lineNo);
            result = compiledScript.exec(cx, scope);
        }
        catch (RhinoException e) {
            throw JavascriptEvalUtil.wrapRhinoException(e, scriptText, source, lineNo);
        }
        finally {
            if (enterContext) {
                Context.exit();
            }
        }
        return result;
    }

    public static Object evaluateScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) throws BirtException {
        return JavascriptEvalUtil.convertJavascriptValue(JavascriptEvalUtil.evaluateRawScript(cx, scope, scriptText, source, lineNo));
    }

    protected static Script getCompiledScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) {
        if (!$assertionsDisabled && scriptText == null) {
            throw new AssertionError();
        }
        Script compiledScript = (Script)compiledScriptCache.get(scriptText);
        if (compiledScript == null) {
            compiledScript = cx.compileString(scriptText, source, lineNo, null);
            compiledScriptCache.put(scriptText, compiledScript);
        }
        return compiledScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertToJavascriptValue(Object value, Scriptable scope) {
        if (value instanceof Date) {
            Context cx = Context.enter();
            try {
                Long timeVal = new Long(((Date)value).getTime());
                Scriptable scriptable = ScriptRuntime.newObject((Context)cx, (Scriptable)scope, (String)"Date", (Object[])new Object[]{timeVal});
                return scriptable;
            }
            finally {
                Context.exit();
            }
        }
        return value;
    }

    public static Object convertToJavascriptValue(Object value) {
        if (sharedScope == null) {
            Context cx = Context.enter();
            sharedScope = new ImporterTopLevel(cx);
            Context.exit();
        }
        return JavascriptEvalUtil.convertToJavascriptValue(value, sharedScope);
    }

    public static Object convertJavascriptValue(Object inputObj) {
        if (inputObj instanceof Undefined) {
            return null;
        }
        if (inputObj instanceof IdScriptableObject) {
            String jsClass = ((Scriptable)inputObj).getClassName();
            if ("Date".equals(jsClass)) {
                return new Date((long)Context.toNumber((Object)inputObj));
            }
            if ("Boolean".equals(jsClass)) {
                return new Boolean(Context.toBoolean((Object)inputObj));
            }
            if ("Number".equals(jsClass)) {
                return new Double(Context.toNumber((Object)inputObj));
            }
            if ("String".equals(jsClass)) {
                return inputObj.toString();
            }
        } else if (inputObj instanceof NativeJavaObject) {
            return ((NativeJavaObject)inputObj).unwrap();
        }
        return inputObj;
    }

    public static BirtException wrapRhinoException(RhinoException e, String scriptText, String source, int lineNo) {
        if (source == null) {
            source = e.sourceName();
            lineNo = e.lineNumber();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Unexpected RhinoException. Source=" + source + ", line=" + lineNo + ", Script=\n" + scriptText + "\n", e);
        }
        return new CoreException("birt.core.JavascriptError", new Object[]{e.getLocalizedMessage(), source, new Integer(lineNo), scriptText}, (Throwable)e);
    }

    public static String transformToJsConstants(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int length = s.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !JavascriptEvalUtil.class.desiredAssertionStatus();
        logger = Logger.getLogger(JavascriptEvalUtil.class.getName());
        compiledScriptCache = Collections.synchronizedMap(new LinkedHashMap(200, 0.75f, true){
            private static final long serialVersionUID = 5787175209573500620L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 200;
            }
        });
    }
}

