/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;

public class RAFolderOutputStream
extends RAOutputStream {
    FolderArchiveWriter archive;
    private RandomAccessFile randomFile;
    protected byte[] buf;
    protected int count;

    public RAFolderOutputStream(FolderArchiveWriter archive, File file) throws FileNotFoundException {
        this.archive = archive;
        this.randomFile = new RandomAccessFile(file, "rw");
        try {
            this.randomFile.setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.buf = new byte[8192];
        this.count = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.randomFile.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.randomFile.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.write(writeBuffer, 0, 8);
    }

    public long getOffset() throws IOException {
        return this.randomFile.getFilePointer() + (long)this.count;
    }

    public void seek(long localPos) throws IOException {
        if (localPos != this.getOffset()) {
            this.flushBuffer();
            this.randomFile.seek(localPos);
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.randomFile.close();
        super.close();
        this.archive.removeStream(this);
    }
}

