/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.script.IJavascriptInitializer;
import org.eclipse.birt.core.script.IJavascriptWrapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptContext {
    protected static Logger logger;
    protected Context context;
    protected ImporterTopLevel global;
    protected Scriptable sharedScope;
    protected Scriptable scope;
    protected HashMap compiledScripts;
    protected NativeObject params;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ScriptContext() {
        this(null);
    }

    public ScriptContext(ScriptableObject root) {
        block3: {
            this.compiledScripts = new HashMap();
            try {
                this.context = Context.enter();
                this.global = new ImporterTopLevel();
                if (root != null) {
                    this.global.setPrototype((Scriptable)root);
                }
                this.global.initStandardObjects(this.context, true);
                this.scope = this.global;
                this.sharedScope = this.context.newObject(this.scope);
            }
            catch (Exception ex) {
                Context.exit();
                this.scope = null;
                this.context = null;
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, ex.getMessage());
            }
        }
    }

    public void registerBean(String name, Object value) {
        if (!$assertionsDisabled && this.context == null) {
            throw new AssertionError();
        }
        Object sObj = Context.javaToJS((Object)value, (Scriptable)this.scope);
        this.scope.put(name, this.scope, sObj);
    }

    public void exit() {
        if (this.context != null) {
            Context.exit();
            this.context = null;
            this.compiledScripts.clear();
        }
    }

    public Scriptable enterScope() {
        return this.enterScope(null);
    }

    public Scriptable enterScope(Scriptable newScope) {
        if (newScope == null) {
            newScope = this.context.newObject(this.scope);
        }
        newScope.setPrototype(this.scope);
        this.scope = newScope;
        this.sharedScope.setPrototype(this.scope);
        return newScope;
    }

    public void exitScope() {
        Scriptable protoScope = this.scope.getPrototype();
        if (protoScope != null) {
            this.scope = protoScope;
        }
        this.sharedScope.setPrototype(this.scope);
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public Scriptable getSharedScope() {
        return this.sharedScope;
    }

    public Scriptable getRootScope() {
        return this.global;
    }

    public Context getContext() {
        return this.context;
    }

    public Object lookupBean(String name) {
        if (!$assertionsDisabled && this.context == null) {
            throw new AssertionError();
        }
        return this.scope.get(name, this.scope);
    }

    public Object eval(String source) {
        return this.eval(source, "<inline>", 1);
    }

    public Object eval(String source, String name, int lineNo) {
        if (!$assertionsDisabled && this.context == null) {
            throw new AssertionError();
        }
        Script script = (Script)this.compiledScripts.get(source);
        if (script == null) {
            script = this.context.compileString(source, name, lineNo, null);
            this.compiledScripts.put(source, script);
        }
        Object value = script.exec(this.context, this.scope);
        return this.jsToJava(value);
    }

    public Object jsToJava(Object jsValue) {
        if (jsValue instanceof Scriptable) {
            String className = ((Scriptable)jsValue).getClassName();
            if ("Date".equals(className)) {
                return Context.toType((Object)jsValue, (Class)Date.class);
            }
            if ("Boolean".equals(className)) {
                return Boolean.valueOf(Context.toString((Object)jsValue));
            }
            if ("String".equals(className)) {
                return Context.toString((Object)jsValue);
            }
        }
        if (jsValue instanceof Integer) {
            return jsValue;
        }
        return Context.toType((Object)jsValue, (Class)Object.class);
    }

    public Object javaToJs(Object value) {
        return Context.javaToJS((Object)value, (Scriptable)this.scope);
    }

    public static synchronized void registerInitializer(IJavascriptInitializer initializer) {
    }

    public static synchronized void unregisterInitializer(IJavascriptInitializer initializer) {
    }

    public static synchronized void registerWrapper(IJavascriptWrapper wrapper) {
    }

    public static synchronized void unregisterWrapper(IJavascriptWrapper wrapper) {
    }

    static {
        $assertionsDisabled = !ScriptContext.class.desiredAssertionStatus();
        logger = Logger.getLogger(ScriptContext.class.getName());
    }
}

