/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.birt.chart.script.ScriptClassLoaderAdapter;

public class BIRTScriptClassLoader
extends ScriptClassLoaderAdapter {
    public static final String PROPERTYSEPARATOR = ";";
    public static final String WEBAPP_CLASSPATH_KEY = "webapplication.projectclasspath";
    public static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    public static final String PROJECT_CLASSPATH_KEY = "user.projectclasspath";

    public Class loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
        ClassNotFoundException ex;
        Class c;
        block4: {
            if (className == null) {
                return null;
            }
            c = null;
            ex = null;
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                ex = e;
                c = BIRTScriptClassLoader.getClassUsingCustomClassPath(className, WEBAPP_CLASSPATH_KEY, parentLoader);
                if (c != null || (c = BIRTScriptClassLoader.getClassUsingCustomClassPath(className, PROJECT_CLASSPATH_KEY, parentLoader)) != null) break block4;
                c = BIRTScriptClassLoader.getClassUsingCustomClassPath(className, WORKSPACE_CLASSPATH_KEY, parentLoader);
            }
        }
        if (c == null) {
            throw ex;
        }
        return c;
    }

    private static Class getClassUsingCustomClassPath(String className, String classPathKey, ClassLoader parentLoader) {
        String classPath = System.getProperty(classPathKey);
        if (classPath == null || classPath.length() == 0 || className == null) {
            return null;
        }
        String[] classPathArray = classPath.split(PROPERTYSEPARATOR, -1);
        URL[] urls = null;
        if (classPathArray.length != 0) {
            ArrayList<URL> l = new ArrayList<URL>();
            for (int i = 0; i < classPathArray.length; ++i) {
                String cpValue = classPathArray[i];
                File file = new File(cpValue);
                try {
                    l.add(file.toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            urls = l.toArray(new URL[l.size()]);
        }
        if (urls != null) {
            URLClassLoader cl = new URLClassLoader(urls, parentLoader);
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }
}

