/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class Position
extends AbstractEnumerator {
    public static final int ABOVE = 0;
    public static final int BELOW = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int INSIDE = 4;
    public static final int OUTSIDE = 5;
    public static final Position ABOVE_LITERAL = new Position(0, "Above", "Above");
    public static final Position BELOW_LITERAL = new Position(1, "Below", "Below");
    public static final Position LEFT_LITERAL = new Position(2, "Left", "Left");
    public static final Position RIGHT_LITERAL = new Position(3, "Right", "Right");
    public static final Position INSIDE_LITERAL = new Position(4, "Inside", "Inside");
    public static final Position OUTSIDE_LITERAL = new Position(5, "Outside", "Outside");
    private static final Position[] VALUES_ARRAY = new Position[]{ABOVE_LITERAL, BELOW_LITERAL, LEFT_LITERAL, RIGHT_LITERAL, INSIDE_LITERAL, OUTSIDE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static Position get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Position result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Position getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Position result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Position get(int value) {
        switch (value) {
            case 0: {
                return ABOVE_LITERAL;
            }
            case 1: {
                return BELOW_LITERAL;
            }
            case 2: {
                return LEFT_LITERAL;
            }
            case 3: {
                return RIGHT_LITERAL;
            }
            case 4: {
                return INSIDE_LITERAL;
            }
            case 5: {
                return OUTSIDE_LITERAL;
            }
        }
        return null;
    }

    private Position(int value, String name, String literal) {
        super(value, name, literal);
    }
}

