/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.internal.computations.Matrix;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.Location3D;

public class Vector {
    private double[] v = new double[4];

    public Vector() {
        this.v[0] = 0.0;
        this.v[1] = 0.0;
        this.v[2] = 0.0;
        this.v[3] = 1.0;
    }

    public Vector(Location3D start, Location3D end) {
        this.v[0] = end.getX() - start.getX();
        this.v[1] = end.getY() - start.getY();
        this.v[2] = end.getZ() - start.getZ();
        this.v[3] = 0.0;
    }

    public Vector(Vector v) {
        this.v[0] = v.v[0];
        this.v[1] = v.v[1];
        this.v[2] = v.v[2];
        this.v[3] = v.v[3];
    }

    public Vector(Location3D loc) {
        this.v[0] = loc.getX();
        this.v[1] = loc.getY();
        this.v[2] = loc.getZ();
        this.v[3] = 1.0;
    }

    public Vector(double x, double y, double z) {
        this(x, y, z, true);
    }

    public Vector(double x, double y, double z, boolean isPoint) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
        this.v[3] = isPoint ? 1.0 : 0.0;
    }

    public void set(double x, double y, double z, boolean isPoint) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
        this.v[3] = isPoint ? 1.0 : 0.0;
    }

    public void set(double x, double y, double z) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
    }

    public double get(int i) {
        return this.v[i];
    }

    public void add(Vector v) {
        this.v[0] = this.v[0] + v.v[0];
        this.v[1] = this.v[1] + v.v[1];
        this.v[2] = this.v[2] + v.v[2];
        this.v[3] = this.v[3] + v.v[3];
    }

    public void sub(Vector v) {
        this.v[0] = this.v[0] - v.v[0];
        this.v[1] = this.v[1] - v.v[1];
        this.v[2] = this.v[2] - v.v[2];
        this.v[3] = this.v[3] - v.v[3];
    }

    public void scale(double f) {
        this.v[0] = this.v[0] * f;
        this.v[1] = this.v[1] * f;
        this.v[2] = this.v[2] * f;
    }

    public void perspective(double distance) {
        this.v[0] = this.v[0] / this.v[2] * distance;
        this.v[1] = this.v[1] / this.v[2] * distance;
        this.v[2] = -1.0 / this.v[2];
    }

    public boolean isPoint() {
        return this.v[3] > 0.0;
    }

    public Vector crossProduct(Vector v) {
        return new Vector(this.v[1] * v.v[2] - this.v[2] * v.v[1], this.v[2] * v.v[0] - this.v[0] * v.v[2], this.v[0] * v.v[1] - this.v[1] * v.v[0], false);
    }

    public double scalarProduct(Vector v) {
        return this.v[0] * v.v[0] + this.v[1] * v.v[1] + this.v[2] * v.v[2];
    }

    public double cosineValue(Vector v) {
        return this.scalarProduct(v) / (Math.sqrt(this.scalarProduct(this)) * Math.sqrt(v.scalarProduct(v)));
    }

    public void rotate(Angle3D angle) {
        double xr = Math.toRadians(angle.getXAngle());
        double yr = Math.toRadians(angle.getYAngle());
        double zr = Math.toRadians(angle.getZAngle());
        Matrix xm = new Matrix(new double[][]{{Math.cos(xr), -Math.sin(xr), 0.0, 0.0}, {Math.sin(xr), Math.cos(xr), 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}}, 4, 4);
        Matrix ym = new Matrix(new double[][]{{Math.cos(yr), 0.0, -Math.sin(yr), 0.0}, {0.0, 1.0, 0.0, 0.0}, {Math.sin(yr), 0.0, Math.cos(yr), 0.0}, {0.0, 0.0, 0.0, 1.0}}, 4, 4);
        Matrix zm = new Matrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, Math.cos(zr), -Math.sin(zr), 0.0}, {0.0, Math.sin(zr), Math.cos(zr), 0.0}, {0.0, 0.0, 0.0, 1.0}}, 4, 4);
        Matrix t = new Matrix(this.v, 1);
        t = t.times(xm).times(ym).times(zm);
        this.v[0] = t.get(0, 0);
        this.v[1] = t.get(0, 1);
        this.v[2] = t.get(0, 2);
    }

    public void project(int dist) {
        this.v[0] = this.v[0] / this.v[2] * (double)dist;
        this.v[1] = this.v[0] / this.v[2] * (double)dist;
        this.v[2] = -1.0 / this.v[2];
    }

    public void inverse() {
        this.v[0] = -this.v[0];
        this.v[1] = -this.v[1];
        this.v[2] = -this.v[2];
    }

    public void multiply(Matrix m) {
        Matrix t = new Matrix(this.v, 1);
        t = t.times(m);
        this.v[0] = t.get(0, 0);
        this.v[1] = t.get(0, 1);
        this.v[2] = t.get(0, 2);
    }

    public Vector getMultiply(Matrix m) {
        Matrix t = new Matrix(this.v, 1);
        t = t.times(m);
        return new Vector(t.get(0, 0), t.get(0, 1), t.get(0, 2), this.v[3] > 0.0);
    }

    public String toString() {
        if (this.v != null) {
            return "X:" + this.v[0] + ",Y:" + this.v[1] + ",Z:" + this.v[2] + ",PV:" + this.v[3];
        }
        return super.toString();
    }
}

