/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.type.impl;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.TypeFactory;
import org.eclipse.birt.chart.model.type.TypePackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class BarSeriesImpl
extends SeriesImpl
implements BarSeries {
    protected static final RiserType RISER_EDEFAULT = RiserType.RECTANGLE_LITERAL;
    protected RiserType riser = RISER_EDEFAULT;
    protected boolean riserESet = false;
    protected ColorDefinition riserOutline = null;

    protected BarSeriesImpl() {
    }

    protected EClass eStaticClass() {
        return TypePackage.Literals.BAR_SERIES;
    }

    public RiserType getRiser() {
        return this.riser;
    }

    public void setRiser(RiserType newRiser) {
        RiserType oldRiser = this.riser;
        this.riser = newRiser == null ? RISER_EDEFAULT : newRiser;
        boolean oldRiserESet = this.riserESet;
        this.riserESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldRiser, (Object)this.riser, !oldRiserESet));
        }
    }

    public void unsetRiser() {
        RiserType oldRiser = this.riser;
        boolean oldRiserESet = this.riserESet;
        this.riser = RISER_EDEFAULT;
        this.riserESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 11, (Object)oldRiser, (Object)RISER_EDEFAULT, oldRiserESet));
        }
    }

    public boolean isSetRiser() {
        return this.riserESet;
    }

    public ColorDefinition getRiserOutline() {
        return this.riserOutline;
    }

    public NotificationChain basicSetRiserOutline(ColorDefinition newRiserOutline, NotificationChain msgs) {
        ColorDefinition oldRiserOutline = this.riserOutline;
        this.riserOutline = newRiserOutline;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldRiserOutline, (Object)newRiserOutline);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setRiserOutline(ColorDefinition newRiserOutline) {
        if (newRiserOutline != this.riserOutline) {
            NotificationChain msgs = null;
            if (this.riserOutline != null) {
                msgs = ((InternalEObject)this.riserOutline).eInverseRemove((InternalEObject)this, -13, null, msgs);
            }
            if (newRiserOutline != null) {
                msgs = ((InternalEObject)newRiserOutline).eInverseAdd((InternalEObject)this, -13, null, msgs);
            }
            if ((msgs = this.basicSetRiserOutline(newRiserOutline, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newRiserOutline, (Object)newRiserOutline));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return this.basicSetRiserOutline(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getRiser();
            }
            case 12: {
                return this.getRiserOutline();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setRiser((RiserType)((Object)newValue));
                return;
            }
            case 12: {
                this.setRiserOutline((ColorDefinition)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.unsetRiser();
                return;
            }
            case 12: {
                this.setRiserOutline(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.isSetRiser();
            }
            case 12: {
                return this.riserOutline != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (riser: ");
        if (this.riserESet) {
            result.append((Object)this.riser);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public final boolean canParticipateInCombination() {
        return true;
    }

    public boolean canShareAxisUnit() {
        return true;
    }

    public static final Series create() {
        BarSeries bs = TypeFactory.eINSTANCE.createBarSeries();
        ((BarSeriesImpl)bs).initialize();
        return bs;
    }

    protected final void initialize() {
        super.initialize();
        this.setRiserOutline(null);
        this.setRiser(RiserType.RECTANGLE_LITERAL);
        this.setVisible(true);
    }

    public final boolean canBeStacked() {
        return true;
    }

    public void translateFrom(Series series, int iSeriesDefinitionIndex, Chart chart) {
        this.setRiser(RiserType.RECTANGLE_LITERAL);
        this.setLabel(series.getLabel());
        if (((Object)((Object)series.getLabelPosition())).equals((Object)Position.INSIDE_LITERAL) || ((Object)((Object)series.getLabelPosition())).equals((Object)Position.OUTSIDE_LITERAL)) {
            this.setLabelPosition(series.getLabelPosition());
        } else {
            this.setLabelPosition(Position.OUTSIDE_LITERAL);
        }
        this.setVisible(series.isVisible());
        this.setStacked(series.isStacked());
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_Triggers())) {
            this.getTriggers().addAll((Collection)series.getTriggers());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataPoint())) {
            this.setDataPoint(series.getDataPoint());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataDefinition())) {
            this.getDataDefinition().add(series.getDataDefinition().get(0));
        }
        if (series instanceof BarSeries) {
            this.setRiserOutline(((BarSeries)series).getRiserOutline());
        } else if (series instanceof PieSeries) {
            this.setRiserOutline(((PieSeries)series).getSliceOutline());
        } else if (series instanceof StockSeries) {
            this.setRiserOutline(((StockSeries)series).getLineAttributes().getColor());
        }
        if (!(chart instanceof ChartWithAxes)) {
            throw new IllegalArgumentException(Messages.getString("error.invalid.argument.for.barSeries", new Object[]{chart.getClass().getName()}, ULocale.getDefault()));
        }
        ((Axis)((ChartWithAxes)chart).getAxes().get(0)).setCategoryAxis(true);
        chart.setSampleData(this.getConvertedSampleData(chart.getSampleData(), iSeriesDefinitionIndex));
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, int iSeriesDefinitionIndex) {
        EList osdList = currentSampleData.getOrthogonalSampleData();
        for (int i = 0; i < osdList.size(); ++i) {
            if (i != iSeriesDefinitionIndex) continue;
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(this.getConvertedOrthogonalSampleDataRepresentation(osd.getDataSetRepresentation()));
            currentSampleData.getOrthogonalSampleData().set(i, (Object)osd);
        }
        return currentSampleData;
    }

    private String getConvertedOrthogonalSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        StringBuffer sbNewRepresentation = new StringBuffer("");
        while (strtok.hasMoreTokens()) {
            String sElement = strtok.nextToken().trim();
            if (sElement.startsWith("H")) {
                StringTokenizer strStockTokenizer = new StringTokenizer(sElement);
                sbNewRepresentation.append(strStockTokenizer.nextToken().trim().substring(1));
            } else {
                sbNewRepresentation.append(sElement);
            }
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    public String getDisplayName() {
        return Messages.getString("BarSeriesImpl.displayName");
    }
}

