/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.internal.computations.Polygon;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.component.Label;

public class ChartUtil {
    private static final double EPS = 1.0E-9;

    public static final boolean isColorTransparent(ColorDefinition cdef) {
        return cdef == null || cdef.isSetTransparency() && cdef.getTransparency() == 0;
    }

    public static final boolean isShadowDefined(Label la) {
        return !ChartUtil.isColorTransparent(la.getShadowColor());
    }

    public static final boolean mathEqual(double v1, double v2) {
        return Math.abs(v1 - v2) < 1.0E-9;
    }

    public static final boolean mathNE(double v1, double v2) {
        return Math.abs(v1 - v2) >= 1.0E-9;
    }

    public static final boolean mathLT(double lv, double rv) {
        return rv - lv > 1.0E-9;
    }

    public static final boolean mathLE(double lv, double rv) {
        return rv - lv > 1.0E-9 || Math.abs(lv - rv) < 1.0E-9;
    }

    public static final boolean mathGT(double lv, double rv) {
        return lv - rv > 1.0E-9;
    }

    public static final boolean mathGE(double lv, double rv) {
        return lv - rv > 1.0E-9 || Math.abs(lv - rv) < 1.0E-9;
    }

    public static final double convertPixelsToPoints(IDisplayServer idsSWT, double dOriginalHeight) {
        return dOriginalHeight * 72.0 / (double)idsSWT.getDpiResolution();
    }

    public static final int getQuadrant(double dAngle) {
        if ((dAngle -= (double)((int)dAngle / 360 * 360)) < 0.0) {
            dAngle += 360.0;
        }
        if (dAngle == 0.0) {
            return -1;
        }
        if (dAngle == 90.0) {
            return -2;
        }
        if (dAngle == 180.0) {
            return -3;
        }
        if (dAngle == 270.0) {
            return -4;
        }
        if (dAngle >= 0.0 && dAngle < 90.0) {
            return 1;
        }
        if (dAngle > 90.0 && dAngle < 180.0) {
            return 2;
        }
        if (dAngle > 180.0 && dAngle < 270.0) {
            return 3;
        }
        return 4;
    }

    public static boolean intersects(Polygon pg1, Polygon pg2) {
        if (pg1 != null) {
            return pg1.intersects(pg2);
        }
        return false;
    }

    public static void mergeFont(FontDefinition original, FontDefinition source) {
        if (source != null) {
            if (original.getAlignment() == null) {
                original.setAlignment(source.getAlignment());
            } else if (!original.getAlignment().isSetHorizontalAlignment() && source.getAlignment() != null) {
                original.getAlignment().setHorizontalAlignment(source.getAlignment().getHorizontalAlignment());
            }
            if (original.getName() == null) {
                original.setName(source.getName());
            }
            if (!original.isSetBold()) {
                original.setBold(source.isBold());
            }
            if (!original.isSetItalic()) {
                original.setItalic(source.isItalic());
            }
            if (!original.isSetRotation()) {
                original.setRotation(source.getRotation());
            }
            if (!original.isSetSize()) {
                original.setSize(source.getSize());
            }
            if (!original.isSetWordWrap()) {
                original.setWordWrap(source.isWordWrap());
            }
            if (!original.isSetUnderline()) {
                original.setUnderline(source.isUnderline());
            }
            if (!original.isSetStrikethrough()) {
                original.setStrikethrough(source.isStrikethrough());
            }
        }
    }

    public static String stringValue(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

