/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.impl;

import java.util.HashMap;
import org.eclipse.datatools.connectivity.oda.OdaException;

public final class DataTypes {
    public static final int INT = 4;
    public static final int DOUBLE = 8;
    public static final int STRING = 12;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BLOB = 2004;
    public static final int BIGDECIMAL = 2;
    private static HashMap typeStringIntPair = new HashMap();
    private static HashMap typeIntStringPair = new HashMap();

    public static int getType(String typeName) throws OdaException {
        String preparedTypeName = typeName.trim();
        if (typeStringIntPair.containsKey(preparedTypeName)) {
            return (Integer)typeStringIntPair.get(preparedTypeName);
        }
        throw new OdaException();
    }

    public static String getTypeString(int type) throws OdaException {
        Integer typeInteger = new Integer(type);
        if (typeIntStringPair.containsKey(typeInteger)) {
            return typeIntStringPair.get(typeInteger).toString();
        }
        throw new OdaException();
    }

    public static boolean isValidType(String typeName) {
        return typeStringIntPair.containsKey(typeName.trim());
    }

    private DataTypes() {
    }

    static {
        typeStringIntPair.put("Int", new Integer(4));
        typeStringIntPair.put("Double", new Integer(8));
        typeStringIntPair.put("String", new Integer(12));
        typeStringIntPair.put("Date", new Integer(91));
        typeStringIntPair.put("Time", new Integer(92));
        typeStringIntPair.put("Timestamp", new Integer(93));
        typeStringIntPair.put("Bigdecimal", new Integer(2));
        typeIntStringPair.put(new Integer(4), "Int");
        typeIntStringPair.put(new Integer(8), "Double");
        typeIntStringPair.put(new Integer(12), "String");
        typeIntStringPair.put(new Integer(91), "Date");
        typeIntStringPair.put(new Integer(92), "Time");
        typeIntStringPair.put(new Integer(93), "Timestamp");
        typeIntStringPair.put(new Integer(2), "Bigdecimal");
    }
}

