/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.CellContextInfo;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.ColumnBandCopyAction;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableColumn;

class ColumnBandInsertAction
extends ColumnBandCopyAction {
    private static final int INSERT_AFTER = 1;
    private static final int INSERT_BEFORE = -1;
    private int targetColumnIndex;
    List originalCells = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColumnBandInsertAction(ColumnBandAdapter adapter) {
        super(adapter);
    }

    protected boolean canInsert(int columnIndex, int insertFlag) {
        int columnCount = this.adapter.getColumnCount();
        this.targetColumnIndex = columnIndex;
        if (insertFlag == -1) {
            --this.targetColumnIndex;
        }
        if (this.targetColumnIndex > columnCount) {
            this.targetColumnIndex = columnCount;
        }
        if (this.targetColumnIndex >= columnCount || this.targetColumnIndex < 1) {
            this.originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(1));
        } else {
            this.originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(this.targetColumnIndex));
            if (!this.isValidInsertAndPasteArea(this.originalCells)) {
                return false;
            }
        }
        return true;
    }

    protected List insertColumnBand(int columnIndex, int insertFlag) throws SemanticException {
        boolean canDone = this.canInsert(columnIndex, insertFlag);
        if (!canDone) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_INSERT_FORBIDDEN");
        }
        TableColumn column = new TableColumn();
        this.adapter.getModule().getActivityStack().startTrans();
        try {
            this.pasteColumn(column, this.targetColumnIndex, true);
            this.insertCells(this.targetColumnIndex);
        }
        catch (SemanticException e) {
            this.adapter.getModule().getActivityStack().rollback();
            throw e;
        }
        this.adapter.getModule().getActivityStack().commit();
        return Collections.EMPTY_LIST;
    }

    private boolean isValidInsertAndPasteArea(List cells) {
        int numOfRows = this.adapter.getRowCount();
        int rowCount = 0;
        for (int i = 0; i < cells.size(); ++i) {
            CellContextInfo contextInfo = (CellContextInfo)cells.get(i);
            rowCount += contextInfo.getRowSpan();
        }
        if (!$assertionsDisabled && rowCount > numOfRows) {
            throw new AssertionError();
        }
        return rowCount >= numOfRows;
    }

    private void insertCells(int columnIndex) throws SemanticException {
        int slotCount = this.adapter.getElementHandle().getDefn().getSlotCount();
        for (int i = 0; i < slotCount; ++i) {
            SlotHandle slot = this.adapter.getElementHandle().getSlot(i);
            for (int j = 0; j < slot.getCount(); ++j) {
                DesignElementHandle content = slot.get(j);
                if (content instanceof RowHandle) {
                    this.insertCell((RowHandle)content, columnIndex);
                }
                if (!(content instanceof GroupHandle)) continue;
                this.insertCellsInGroup((GroupHandle)content, columnIndex);
            }
        }
    }

    private void insertCell(RowHandle row, int columnIndex) throws SemanticException {
        int pos;
        if (!$assertionsDisabled && row == null) {
            throw new AssertionError();
        }
        if (columnIndex == 0) {
            pos = 0;
        } else if (columnIndex == this.adapter.getColumnCount() - 1) {
            pos = -1;
        } else {
            CellHandle cell = this.adapter.findCell(row, columnIndex);
            if (cell == null) {
                return;
            }
            if (cell.getColumnSpan() != 1) {
                cell.setColumnSpan(cell.getColumnSpan() + 1);
                return;
            }
            pos = cell.getContainerSlotHandle().findPosn(cell) + 1;
        }
        if (pos != -1) {
            row.addElement(new Cell().getHandle(this.adapter.getModule()), 0, pos);
        } else {
            row.addElement(new Cell().getHandle(this.adapter.getModule()), 0);
        }
    }

    private void insertCellsInGroup(GroupHandle group, int columnIndex) throws SemanticException {
        if (!$assertionsDisabled && group == null) {
            throw new AssertionError();
        }
        int slotCount = group.getDefn().getSlotCount();
        for (int i = 0; i < slotCount; ++i) {
            SlotHandle slot = group.getSlot(i);
            for (int j = 0; j < slot.getCount(); ++j) {
                DesignElementHandle content = slot.get(j);
                if (!(content instanceof RowHandle)) continue;
                this.insertCell((RowHandle)content, columnIndex);
            }
        }
    }

    static {
        $assertionsDisabled = !ColumnBandInsertAction.class.desiredAssertionStatus();
    }
}

