/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class PropertyHandle
extends SimpleValueHandle {
    protected ElementPropertyDefn propDefn;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyHandle(DesignElementHandle element, String propName) {
        super(element);
        this.propDefn = element.getElement().getPropertyDefn(propName);
    }

    public PropertyHandle(DesignElementHandle element, ElementPropertyDefn prop) {
        super(element);
        this.propDefn = prop;
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.propDefn;
    }

    public IPropertyDefn getDefn() {
        return this.propDefn;
    }

    public Object getValue() {
        Object value = this.getElement().getProperty(this.getModule(), this.propDefn);
        if (value instanceof ReferenceValue) {
            return ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, this.getElementHandle().getModule());
        }
        return value;
    }

    public void setValue(Object value) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.setProperty(this.propDefn, value);
    }

    public MemberRef getReference() {
        return new CachedMemberRef(this.propDefn);
    }

    public boolean isSet() {
        FactoryPropertyHandle handle = new FactoryPropertyHandle(this.elementHandle, this.propDefn);
        return handle.isSet();
    }

    public boolean isLocal() {
        Object value = this.getElement().getLocalProperty(this.getModule(), this.propDefn);
        return value != null;
    }

    public boolean equals(Object propertyHandle) {
        if (!(propertyHandle instanceof PropertyHandle)) {
            return false;
        }
        DesignElement element = ((PropertyHandle)propertyHandle).getElement();
        IPropertyDefn propDefn = ((PropertyHandle)propertyHandle).getDefn();
        return element == this.getElement() && propDefn == this.getDefn();
    }

    public List getReferenceableElementList() {
        if (this.propDefn.getTypeCode() != 15 && this.propDefn.getSubTypeCode() != 15) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList();
        ElementDefn elementDefn = (ElementDefn)this.propDefn.getTargetElementType();
        if (!$assertionsDisabled && elementDefn == null) {
            throw new AssertionError();
        }
        ModuleHandle moduleHandle = (ModuleHandle)this.getModule().getHandle(this.getModule());
        if ("DataSet".equals(elementDefn.getName())) {
            return moduleHandle.getVisibleDataSets();
        }
        if ("DataSource".equals(elementDefn.getName())) {
            return moduleHandle.getVisibleDataSources();
        }
        if ("Style".equals(elementDefn.getName())) {
            return ((ReportDesignHandle)moduleHandle).getAllStyles();
        }
        if ("Theme".equals(elementDefn.getName())) {
            return moduleHandle.getVisibleThemes(1);
        }
        return list;
    }

    public boolean isReadOnly() {
        boolean isReadOnly = false;
        Module root = this.getElementHandle().getModule();
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError();
        }
        if (root.isReadOnly()) {
            isReadOnly = true;
        } else {
            switch (this.propDefn.getValueType()) {
                case 0: 
                case 2: 
                case 4: {
                    IElementDefn elementDefn = this.getElementHandle().getDefn();
                    if (!elementDefn.isPropertyReadOnly(this.propDefn.getName())) break;
                    isReadOnly = true;
                    break;
                }
                case 3: {
                    if (!this.propDefn.isReadOnly()) break;
                    isReadOnly = true;
                }
            }
        }
        if (isReadOnly) {
            return true;
        }
        return this.isReadOnlyInContext();
    }

    public boolean isVisible() {
        boolean isVisible = true;
        switch (this.propDefn.getValueType()) {
            case 0: 
            case 2: 
            case 4: {
                IElementDefn elementDefn = this.getElementHandle().getDefn();
                if (elementDefn.isPropertyVisible(this.propDefn.getName())) break;
                isVisible = false;
                break;
            }
            case 3: {
                if (this.propDefn.isVisible()) break;
                isVisible = false;
            }
        }
        return isVisible;
    }

    public void addItem(Object item) throws SemanticException {
        if (item == null) {
            return;
        }
        if (item instanceof IStructure) {
            super.addItem((IStructure)item);
        } else {
            PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
            cmd.addItem(this.propDefn, item);
        }
    }

    public void removeItem(Object item) throws SemanticException {
        if (item == null) {
            return;
        }
        if (item instanceof IStructure) {
            super.removeItem((IStructure)item);
        } else {
            PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
            cmd.removeItem(this.propDefn, item);
        }
    }

    private boolean isReadOnlyInContext() {
        String propName;
        MasterPage masterPage;
        DesignElementHandle element = this.getElementHandle();
        return element instanceof MasterPageHandle && !(masterPage = (MasterPage)element.getElement()).isCustomType(this.getModule()) && ("height".equals(propName = this.propDefn.getName()) || "width".equals(propName));
    }

    static {
        $assertionsDisabled = !PropertyHandle.class.desiredAssertionStatus();
    }
}

