/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IStyledElementModel;
import org.eclipse.birt.report.model.util.DataBoundColumnUtil;
import org.eclipse.birt.report.model.util.UnusedBoundColumnsMgr;

public abstract class ReportItemHandle
extends ReportElementHandle
implements IReportItemModel,
IStyledElementModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportItemHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public DataSetHandle getDataSet() {
        DesignElement dataSet = ((ReportItem)this.getElement()).getDataSetElement(this.module);
        if (dataSet == null) {
            return null;
        }
        if (!$assertionsDisabled && !(dataSet instanceof DataSet)) {
            throw new AssertionError();
        }
        return (DataSetHandle)dataSet.getHandle(dataSet.getRoot());
    }

    public void setDataSet(DataSetHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("dataSet", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, handle.getName());
            }
            this.setStringProperty("dataSet", valueToSet);
        }
    }

    public DimensionHandle getX() {
        return super.getDimensionProperty("x");
    }

    public DimensionHandle getY() {
        return super.getDimensionProperty("y");
    }

    public void setX(String dimension) throws SemanticException {
        this.setProperty("x", dimension);
    }

    public void setX(double dimension) throws SemanticException {
        this.setFloatProperty("x", dimension);
    }

    public void setY(String dimension) throws SemanticException {
        this.setProperty("y", dimension);
    }

    public void setY(double dimension) throws SemanticException {
        this.setFloatProperty("y", dimension);
    }

    public void setHeight(String dimension) throws SemanticException {
        this.setProperty("height", dimension);
    }

    public void setHeight(double dimension) throws SemanticException {
        this.setFloatProperty("height", dimension);
    }

    public void setWidth(String dimension) throws SemanticException {
        this.setProperty("width", dimension);
    }

    public void setWidth(double dimension) throws SemanticException {
        this.setFloatProperty("width", dimension);
    }

    public DimensionHandle getWidth() {
        return super.getDimensionProperty("width");
    }

    public DimensionHandle getHeight() {
        return super.getDimensionProperty("height");
    }

    public String getBookmark() {
        return this.getStringProperty("bookmark");
    }

    public void setBookmark(String value) throws SemanticException {
        this.setStringProperty("bookmark", value);
    }

    public Iterator visibilityRulesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("visibility");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public String getOnCreate() {
        return this.getStringProperty("onCreate");
    }

    public void setOnCreate(String value) throws SemanticException {
        this.setProperty("onCreate", value);
    }

    public String getOnRender() {
        return this.getStringProperty("onRender");
    }

    public void setOnRender(String value) throws SemanticException {
        this.setProperty("onRender", value);
    }

    public Iterator paramBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("paramBindings");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public void setTocExpression(String expression) throws SemanticException {
        this.setStringProperty("toc", expression);
    }

    public String getTocExpression() {
        return this.getStringProperty("toc");
    }

    public String getOnPrepare() {
        return this.getStringProperty("onPrepare");
    }

    public void setOnPrepare(String script) throws SemanticException {
        this.setProperty("onPrepare", script);
    }

    public String getOnPageBreak() {
        return this.getStringProperty("onPageBreak");
    }

    public void setOnPageBreak(String script) throws SemanticException {
        this.setProperty("onPageBreak", script);
    }

    public Iterator columnBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("boundDataColumns");
        return propHandle.iterator();
    }

    public PropertyHandle getColumnBindings() {
        return this.getPropertyHandle("boundDataColumns");
    }

    public ComputedColumnHandle addColumnBinding(ComputedColumn addColumn, boolean inForce) throws SemanticException {
        if (addColumn == null) {
            return null;
        }
        String expr = addColumn.getExpression();
        if (expr == null) {
            return null;
        }
        List columns = (List)this.getProperty("boundDataColumns");
        if (columns == null) {
            return (ComputedColumnHandle)this.getPropertyHandle("boundDataColumns").addItem(addColumn);
        }
        ComputedColumn column = DataBoundColumnUtil.getColumn(columns, expr);
        if (column != null && !inForce) {
            return (ComputedColumnHandle)column.handle(this.getPropertyHandle("boundDataColumns"), columns.indexOf(column));
        }
        return (ComputedColumnHandle)this.getPropertyHandle("boundDataColumns").addItem(addColumn);
    }

    public void removedUnusedColumnBindings() throws SemanticException {
        UnusedBoundColumnsMgr.removedUnusedBoundColumns(this);
    }

    static {
        $assertionsDisabled = !ReportItemHandle.class.desiredAssertionStatus();
    }
}

