/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutGroupBand;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;

public class LayoutUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected static int getRowCount(LayoutTable table) {
        int i;
        int rowCount = 0;
        LayoutSlot slot = table.getHeader();
        rowCount += slot.getRowCount();
        slot = table.getDetail();
        rowCount += slot.getRowCount();
        slot = table.getFooter();
        rowCount += slot.getRowCount();
        LayoutGroupBand groupSlot = table.getGroupHeaders();
        for (i = 0; i < groupSlot.getGroupCount(); ++i) {
            slot = groupSlot.getLayoutSlot(i);
            rowCount += slot.getRowCount();
        }
        groupSlot = table.getGroupFooters();
        for (i = 0; i < groupSlot.getGroupCount(); ++i) {
            slot = groupSlot.getLayoutSlot(i);
            rowCount += slot.getRowCount();
        }
        return rowCount;
    }

    protected static List getFlattenedLayoutSlots(LayoutTable table) {
        int i;
        ArrayList<LayoutSlot> list = new ArrayList<LayoutSlot>();
        list.add(table.getHeader());
        LayoutGroupBand band = table.getGroupHeaders();
        for (i = 0; i < band.getGroupCount(); ++i) {
            list.add(band.getLayoutSlot(i));
        }
        list.add(table.getDetail());
        band = table.getGroupFooters();
        for (i = 0; i < band.getGroupCount(); ++i) {
            list.add(band.getLayoutSlot(i));
        }
        list.add(table.getFooter());
        return list;
    }

    private static LayoutSlot getLayoutSlotOfCell(CellHandle cell) {
        ReportItem compoundElement = LayoutUtil.getCompoundContainer(cell.getElement());
        if (!(compoundElement instanceof TableItem)) {
            return null;
        }
        TableItem table = (TableItem)compoundElement;
        LayoutTable layoutTable = table.getLayoutModel(cell.getModule());
        LayoutSlot layoutSlot = null;
        DesignElementHandle grandPa = cell.getContainer().getContainer();
        int groupLevel = 0;
        int slotId = cell.getContainer().getContainerSlotHandle().getSlotID();
        if (grandPa instanceof TableHandle) {
            layoutSlot = layoutTable.getLayoutSlot(slotId);
        } else {
            groupLevel = ((TableGroup)grandPa.getElement()).getGroupLevel();
            layoutSlot = layoutTable.getLayoutSlot(groupLevel, slotId);
        }
        return layoutSlot;
    }

    public static int getEffectiveColumnSpan(CellHandle cell) {
        LayoutCell layoutCell;
        LayoutSlot layoutSlot = LayoutUtil.getLayoutSlotOfCell(cell);
        if (layoutSlot == null) {
            return cell.getColumnSpan();
        }
        int rowId = cell.getContainer().getContainerSlotHandle().findPosn(cell.getContainer());
        LayoutRow layoutRow = layoutSlot.getLayoutRow(rowId);
        int columnPosn = layoutRow.findCellColumnPos((Cell)cell.getElement());
        if (columnPosn <= 0) {
            return 0;
        }
        int effectiveColumnSpan = 0;
        for (int i = columnPosn - 1; i < layoutRow.getColumnCount() && (layoutCell = layoutRow.getLayoutCell(i)).getContent() == cell.getElement(); ++i) {
            ++effectiveColumnSpan;
        }
        return effectiveColumnSpan;
    }

    public static int getEffectiveRowSpan(CellHandle cell) {
        LayoutRow layoutRow;
        LayoutCell layoutCell;
        LayoutSlot layoutSlot = LayoutUtil.getLayoutSlotOfCell(cell);
        if (layoutSlot == null) {
            return cell.getColumnSpan();
        }
        int rowId = cell.getContainer().getContainerSlotHandle().findPosn(cell.getContainer());
        int effectiveRowSpan = 0;
        for (int i = rowId; i < layoutSlot.getRowCount() && (layoutCell = (layoutRow = layoutSlot.getLayoutRow(i)).getLayoutCell(cell)) != null; ++i) {
            if (layoutCell.isEffectualDrop()) {
                if (!$assertionsDisabled && !layoutCell.isCellStartPosition()) {
                    throw new AssertionError();
                }
                return layoutCell.getRowSpanForDrop();
            }
            ++effectiveRowSpan;
        }
        return effectiveRowSpan;
    }

    public static ReportItem getCompoundContainer(IDesignElement element) {
        DesignElement tmpElement = (DesignElement)element;
        int maxLevel = 3;
        for (int i = 0; i < maxLevel; ++i) {
            if (tmpElement == null || tmpElement instanceof TableItem || tmpElement instanceof GridItem) {
                return (ReportItem)tmpElement;
            }
            tmpElement = tmpElement.getContainer();
        }
        return null;
    }

    static {
        $assertionsDisabled = !LayoutUtil.class.desiredAssertionStatus();
    }
}

