/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.AbstractNameScope;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class StyleNameScope
extends AbstractNameScope {
    StyleNameScope(Module module) {
        super(module, 0);
    }

    public List getElements(int level) {
        Theme theme = this.module.getTheme(this.module);
        if (theme == null && this.module instanceof Library) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashMap<String, DesignElement> elements = new LinkedHashMap<String, DesignElement>();
        if (theme != null) {
            ContainerSlot styles = theme.getSlot(0);
            for (int i = 0; i < styles.getCount(); ++i) {
                DesignElement style = styles.getContent(i);
                elements.put(style.getName(), style);
            }
        }
        if (this.module instanceof Library) {
            return new ArrayList(elements.values());
        }
        NameSpace ns = this.module.getNameSpace(this.nameSpaceID);
        Iterator iter = ns.getElements().iterator();
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            elements.put(element.getName(), element);
        }
        return new ArrayList(elements.values());
    }

    private ElementRefValue resolve(DesignElement element) {
        return new ElementRefValue(null, element);
    }

    private ElementRefValue resolve(String elementName) {
        NameSpace ns;
        Theme theme = this.module.getTheme(this.module);
        if (theme == null && this.module instanceof Library) {
            return new ElementRefValue(null, elementName);
        }
        DesignElement target = null;
        if (this.module instanceof ReportDesign && (target = (ns = this.module.getNameSpace(this.nameSpaceID)).getElement(elementName)) != null) {
            return new ElementRefValue(null, target);
        }
        DesignElement libraryStyle = null;
        if (theme != null) {
            ContainerSlot styles = theme.getSlot(0);
            for (int i = 0; i < styles.getCount(); ++i) {
                DesignElement style = styles.getContent(i);
                if (!style.getName().equalsIgnoreCase(elementName)) continue;
                libraryStyle = style;
                break;
            }
        }
        if (libraryStyle != null) {
            return new ElementRefValue(null, libraryStyle);
        }
        return new ElementRefValue(null, elementName);
    }

    public ElementRefValue resolve(DesignElement element, PropertyDefn propDefn) {
        return this.resolve(element);
    }

    public ElementRefValue resolve(String elementName, PropertyDefn propDefn) {
        return this.resolve(elementName);
    }
}

