/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ArgumentInfo;
import org.eclipse.birt.report.model.metadata.ArgumentInfoList;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ExtensionChoice;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionLoader;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MethodInfo;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class PeerExtensionLoader
extends ExtensionLoader {
    public static final String EXTENSION_POINT = "org.eclipse.birt.report.model.reportItemModel";
    private static final String ELEMENT_TAG = "reportItem";

    public PeerExtensionLoader() {
        super(EXTENSION_POINT);
    }

    void loadExtension(IExtension extension) throws ExtensionException, MetaDataException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        PeerExtensionElementLoader loader = new PeerExtensionElementLoader(extension);
        for (int i = 0; i < configElements.length; ++i) {
            IConfigurationElement currentTag = configElements[i];
            if (!ELEMENT_TAG.equals(currentTag.getName())) continue;
            loader.loadElement(currentTag);
        }
    }

    class PeerExtensionElementLoader
    extends ExtensionLoader.ExtensionElementLoader {
        private static final String STYLE_PROPERTY_TAG = "styleProperty";
        private static final String METHOD_TAG = "method";
        private static final String ARGUMENT_TAG = "argument";
        private static final String TOOL_TIP_ID_ATTRIB = "toolTipID";
        private static final String RETURN_TYPE_ATTRIB = "returnType";
        private static final String TAG_ID_ATTRIB = "tagID";
        private static final String IS_STATIC_ATTRIB = "isStatic";
        private static final String STYLE_TAG = "style";
        private static final String DEFAULT_STYLE_ATTRIB = "defaultStyle";
        private static final String IS_NAME_REQUIRED_ATTRIB = "isNameRequired";
        private static final String CLASS_ATTRIB = "class";

        PeerExtensionElementLoader(IExtension extension) {
            super(extension);
        }

        void loadElement(IConfigurationElement elementTag) throws MetaDataException, ExtensionException {
            IReportItemFactory factory = null;
            PeerExtensionElementDefn elementDefn = null;
            String extensionName = elementTag.getAttribute("extensionName");
            String displayNameID = elementTag.getAttribute("displayNameID");
            String defaultStyle = elementTag.getAttribute(DEFAULT_STYLE_ATTRIB);
            String isNameRequired = elementTag.getAttribute(IS_NAME_REQUIRED_ATTRIB);
            String className = elementTag.getAttribute(CLASS_ATTRIB);
            this.checkRequiredAttribute("extensionName", extensionName);
            this.checkRequiredAttribute(CLASS_ATTRIB, className);
            try {
                factory = (IReportItemFactory)elementTag.createExecutableExtension(CLASS_ATTRIB);
                elementDefn = new PeerExtensionElementDefn(extensionName, factory);
                elementDefn.setAbstract(false);
                elementDefn.setAllowsUserProperties(false);
                elementDefn.setCanExtend(true);
                elementDefn.setDisplayNameKey(displayNameID);
                elementDefn.setExtends(null);
                elementDefn.setJavaClass(null);
                elementDefn.setSelector(defaultStyle);
                if ("true".equalsIgnoreCase(isNameRequired)) {
                    elementDefn.setNameOption(2);
                } else {
                    elementDefn.setNameOption(1);
                }
                ArrayList propList = new ArrayList();
                IConfigurationElement[] elements = elementTag.getChildren();
                for (int i = 0; i < elements.length; ++i) {
                    ExtensionPropertyDefn extPropDefn;
                    if ("property".equalsIgnoreCase(elements[i].getName())) {
                        extPropDefn = this.loadProperty(elementTag, elements[i], elementDefn);
                        elementDefn.addProperty(extPropDefn);
                        continue;
                    }
                    if ("propertyVisibility".equalsIgnoreCase(elements[i].getName())) {
                        this.loadPropertyVisibility(elements[i], elementDefn);
                        continue;
                    }
                    if ("propertyGroup".equalsIgnoreCase(elements[i].getName())) {
                        this.loadPropertyGroup(elementTag, elements[i], elementDefn, propList);
                        continue;
                    }
                    if (STYLE_PROPERTY_TAG.equalsIgnoreCase(elements[i].getName())) continue;
                    if (METHOD_TAG.equalsIgnoreCase(elements[i].getName())) {
                        extPropDefn = this.loadMethod(elementTag, elements[i], elementDefn);
                        elementDefn.addProperty(extPropDefn);
                        continue;
                    }
                    if (!STYLE_TAG.equalsIgnoreCase(elements[i].getName())) continue;
                    PredefinedStyle style = this.loadStyle(elementTag, elements[i], elementDefn);
                    MetaDataDictionary.getInstance().addPredefinedStyle(style);
                }
            }
            catch (FrameworkException e) {
                throw new ExtensionException(new String[]{className}, "FAILED_TO_CREATE_INSTANCE");
            }
            elementDefn.extensionPoint = PeerExtensionLoader.EXTENSION_POINT;
            MetaDataDictionary.getInstance().addExtension(elementDefn);
        }

        ExtensionPropertyDefn loadProperty(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) throws ExtensionException {
            String name = propTag.getAttribute("name");
            String displayNameID = propTag.getAttribute("displayNameID");
            String type = propTag.getAttribute("type");
            String canInherit = propTag.getAttribute("canInherit");
            String defaultValue = propTag.getAttribute("defaultValue");
            String isEncrypted = propTag.getAttribute("isEncryptable");
            String defaultDisplayName = propTag.getAttribute("defaultDisplayName");
            this.checkRequiredAttribute("name", name);
            this.checkRequiredAttribute("type", type);
            PropertyType propType = MetaDataDictionary.getInstance().getPropertyType(type);
            if (propType == null) {
                throw new ExtensionException(new String[]{type}, "INVALID_PROPERTY_TYPE");
            }
            ExtensionPropertyDefn extPropDefn = new ExtensionPropertyDefn(((PeerExtensionElementDefn)elementDefn).getReportItemFactory().getMessages());
            extPropDefn.setName(name);
            extPropDefn.setDisplayNameID(displayNameID);
            extPropDefn.setType(propType);
            try {
                Object value = extPropDefn.validateXml(null, defaultValue);
                extPropDefn.setDefault(value);
            }
            catch (PropertyValueException e) {
                throw new ExtensionException(new String[]{defaultValue}, "INVALID_DEFAULT_VALUE");
            }
            extPropDefn.setIntrinsic(false);
            extPropDefn.setStyleProperty(false);
            extPropDefn.setDefaultDisplayName(defaultDisplayName);
            if (!StringUtil.isBlank(canInherit)) {
                extPropDefn.setCanInherit(Boolean.valueOf(canInherit));
            }
            if (!StringUtil.isBlank(isEncrypted)) {
                extPropDefn.setIsEncryptable(Boolean.valueOf(isEncrypted));
            }
            ArrayList<ExtensionChoice> choiceList = new ArrayList<ExtensionChoice>();
            IConfigurationElement[] elements = propTag.getChildren();
            for (int k = 0; k < elements.length; ++k) {
                if (!"choice".equalsIgnoreCase(elements[k].getName())) continue;
                ExtensionChoice choiceDefn = new ExtensionChoice(((PeerExtensionElementDefn)elementDefn).getReportItemFactory().getMessages());
                this.loadChoice(elements[k], choiceDefn, extPropDefn);
                choiceList.add(choiceDefn);
            }
            if (choiceList.size() > 0) {
                IChoice[] choices = new Choice[choiceList.size()];
                choiceList.toArray(choices);
                ChoiceSet choiceSet = new ChoiceSet();
                choiceSet.setChoices(choices);
                extPropDefn.setDetails(choiceSet);
            }
            return extPropDefn;
        }

        ExtensionPropertyDefn loadMethod(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) throws ExtensionException {
            String name = propTag.getAttribute("name");
            String displayNameID = propTag.getAttribute("displayNameID");
            String toolTipID = propTag.getAttribute(TOOL_TIP_ID_ATTRIB);
            String returnType = propTag.getAttribute(RETURN_TYPE_ATTRIB);
            String isStatic = propTag.getAttribute(IS_STATIC_ATTRIB);
            if (name == null) {
                throw new ExtensionException(new String[0], "MISSING_METHOD_NAME");
            }
            if (displayNameID == null) {
                throw new ExtensionException(new String[0], "VALUE_REQUIRED");
            }
            MethodInfo methodInfo = new MethodInfo(false);
            methodInfo.setName(name);
            methodInfo.setDisplayNameKey(displayNameID);
            methodInfo.setReturnType(returnType);
            methodInfo.setToolTipKey(toolTipID);
            methodInfo.setStatic(Boolean.getBoolean(isStatic));
            IConfigurationElement[] elements = propTag.getChildren();
            ArgumentInfoList argumentList = null;
            for (int i = 0; i < elements.length; ++i) {
                if (!ARGUMENT_TAG.equalsIgnoreCase(elements[i].getName())) continue;
                ArgumentInfo argument = this.loadArgument(elementTag, elements[i], elementDefn);
                if (argumentList == null) {
                    argumentList = new ArgumentInfoList();
                }
                try {
                    argumentList.addArgument(argument);
                    continue;
                }
                catch (MetaDataException e) {
                    throw new ExtensionException(new String[0], "DUPLICATE_ARGUMENT_NAME");
                }
            }
            methodInfo.addArgumentList(argumentList);
            return this.addDefnTo(elementDefn, methodInfo);
        }

        private ExtensionPropertyDefn addDefnTo(ExtensionElementDefn elementDefn, MethodInfo methodInfo) throws ExtensionException {
            ExtensionPropertyDefn extPropDefn = new ExtensionPropertyDefn(((PeerExtensionElementDefn)elementDefn).getReportItemFactory().getMessages());
            PropertyType typeDefn = MetaDataDictionary.getInstance().getPropertyType(18);
            String name = methodInfo.getName();
            String displayNameID = methodInfo.getDisplayNameKey();
            extPropDefn.setName(name);
            extPropDefn.setDisplayNameID(displayNameID);
            extPropDefn.setType(typeDefn);
            extPropDefn.setGroupNameKey(null);
            extPropDefn.setCanInherit(true);
            extPropDefn.setIntrinsic(false);
            extPropDefn.setStyleProperty(false);
            extPropDefn.setDetails(methodInfo);
            return extPropDefn;
        }

        ArgumentInfo loadArgument(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) throws ExtensionException {
            String name = propTag.getAttribute("name");
            String tagID = propTag.getAttribute(TAG_ID_ATTRIB);
            String type = propTag.getAttribute("type");
            if (name == null) {
                return null;
            }
            ArgumentInfo argument = new ArgumentInfo();
            argument.setName(name);
            argument.setType(type);
            argument.setDisplayNameKey(tagID);
            return argument;
        }

        PredefinedStyle loadStyle(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) throws ExtensionException {
            String name = propTag.getAttribute("name");
            String displayNameID = propTag.getAttribute("displayNameID");
            PredefinedStyle style = new PredefinedStyle();
            style.setName(name);
            style.setDisplayNameKey(displayNameID);
            return style;
        }
    }
}

