/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.extension.oda.ODAProviderFactory;
import org.eclipse.birt.report.model.parser.CompatibleOdaDataSetPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.parser.SimpleDataSetState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;

public class OdaDataSetState
extends SimpleDataSetState {
    private static final String OBSOLETE_FLAT_FILE_ID = "org.eclipse.birt.report.data.oda.flatfile.dataSet";
    private static final String NEW_FLAT_FILE_ID = "org.eclipse.datatools.connectivity.oda.flatfile.dataSet";

    public OdaDataSetState(ModuleParserHandler handler) {
        super(handler);
        this.element = new OdaDataSet();
    }

    public OdaDataSetState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public DesignElement getElement() {
        return this.element;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.parseODADataSetExtensionID(attrs, false);
        this.initElement(attrs, true);
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("property") && (this.handler.isVersion("0") || this.handler.isVersion("1"))) {
            return new CompatibleOdaDataSetPropertyState(this.handler, this.getElement());
        }
        return super.startElement(tagName);
    }

    private void parseODADataSetExtensionID(Attributes attrs, boolean extensionNameRequired) {
        String extensionID = this.getAttrib(attrs, "extensionID");
        if (StringUtil.isBlank(extensionID)) {
            if (!extensionNameRequired) {
                return;
            }
            SemanticError e = new SemanticError(this.element, "Error.SemanticError.MISSING_EXTENSION");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
        } else {
            if (StringUtil.compareVersion(this.handler.getVersion(), "3") < 0 && OBSOLETE_FLAT_FILE_ID.equalsIgnoreCase(extensionID)) {
                extensionID = NEW_FLAT_FILE_ID;
            }
            if (ODAProviderFactory.getInstance().createODAProvider(this.element, extensionID) == null) {
                return;
            }
            if (!ODAProviderFactory.getInstance().createODAProvider(this.element, extensionID).isValidODADataSetExtensionID(extensionID)) {
                SemanticError e = new SemanticError((DesignElement)this.element, new String[]{extensionID}, "Error.SemanticError.EXTENSION_NOT_FOUND");
                RecoverableError.dealMissingInvalidExtension(this.handler, e);
            }
        }
        this.setProperty("extensionID", extensionID);
    }
}

