/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisOrigin;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Grid;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.util.CDateTime;

public abstract class PlotWithAxes
extends Methods {
    static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation.withaxes");
    protected int iDimension = 0;
    protected double dSeriesThickness = 10.0;
    protected double dXAxisPlotSpacing = 0.0;
    protected double dYAxisPlotSpacing = 0.0;
    protected double dZAxisPlotSpacing = 0.0;
    protected ColorDefinition cdShadow = ColorDefinitionImpl.GREY();
    protected LineAttributes laPlot = null;
    protected AllAxes aax = null;
    protected ChartWithAxes cwa;
    protected IDisplayServer ids;
    protected RunTimeContext rtc;
    protected Bounds boPlotBackground = BoundsImpl.create(0.0, 0.0, 100.0, 100.0);
    protected Insets insCA = null;
    protected transient double dPointToPixel = 0.0;

    protected static final int getDimension(ChartDimension cd) {
        switch (cd.getValue()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    protected static final int getAxisType(Axis ax) {
        int iAxisType = 0;
        AxisType at = ax.getType();
        switch (at.getValue()) {
            case 0: {
                iAxisType = 3;
                break;
            }
            case 1: {
                iAxisType = 5;
                break;
            }
            case 2: {
                iAxisType = 16;
                break;
            }
            case 3: {
                iAxisType = 8;
            }
        }
        if (ax.isPercent()) {
            iAxisType |= 0x20;
        }
        return iAxisType;
    }

    protected static final int getTickStyle(Axis ax, int iMajorOrMinor) {
        Grid gr;
        int iTickStyle = 0;
        Grid grid = gr = iMajorOrMinor == 0 ? ax.getMajorGrid() : ax.getMinorGrid();
        if (!gr.isSetTickStyle()) {
            return iTickStyle;
        }
        LineAttributes lia = gr.getTickAttributes();
        if (!(lia.isSetStyle() && lia.isSetThickness() && lia.isSetVisible() && lia.isVisible())) {
            return iTickStyle;
        }
        TickStyle ts = gr.getTickStyle();
        switch (ts.getValue()) {
            case 0: {
                iTickStyle = 1;
                break;
            }
            case 1: {
                iTickStyle = 2;
                break;
            }
            case 2: {
                iTickStyle = 1;
                break;
            }
            case 3: {
                iTickStyle = 2;
                break;
            }
            case 4: {
                iTickStyle = 3;
            }
        }
        return iTickStyle;
    }

    protected static final IntersectionValue getIntersection(Axis ax) {
        IntersectionValue iv = null;
        AxisOrigin ao = ax.getOrigin();
        iv = ao.getType() == IntersectionType.MAX_LITERAL ? IntersectionValue.MAX_VALUE : (ao.getType() == IntersectionType.MIN_LITERAL ? IntersectionValue.MIN_VALUE : new IntersectionValue(3, ao.getValue()));
        return iv;
    }

    public final int getDimension() {
        return this.iDimension;
    }

    public final double getSeriesThickness() {
        return this.dSeriesThickness;
    }

    public final double getHorizontalSpacingInPixels() {
        return this.dXAxisPlotSpacing;
    }

    public final double getVerticalSpacingInPixels() {
        return this.dYAxisPlotSpacing;
    }

    public abstract void compute(Bounds var1) throws ChartException, IllegalArgumentException;

    public abstract ISeriesRenderingHints getSeriesRenderingHints(SeriesDefinition var1, Series var2) throws ChartException, IllegalArgumentException;

    abstract void buildAxes() throws IllegalArgumentException, ChartException;

    public final AllAxes getAxes() {
        return this.aax;
    }

    public final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }

    public final IDisplayServer getDisplayServer() {
        return this.ids;
    }

    public final Bounds getPlotBounds() {
        return this.boPlotBackground;
    }

    public final Insets getPlotInsets() {
        return this.insCA;
    }

    protected final OneAxis findOrthogonalAxis(Series se) {
        Axis[] axaBase = ((ChartWithAxesImpl)this.cwa).getBaseAxes();
        Axis axPrimaryBase = axaBase[0];
        Axis[] axaOrthogonal = ((ChartWithAxesImpl)this.cwa).getOrthogonalAxes(axPrimaryBase, true);
        for (int i = 0; i < axaOrthogonal.length; ++i) {
            Series[] sea = axaOrthogonal[i].getRuntimeSeries();
            for (int j = 0; j < sea.length; ++j) {
                if (sea[j] != se) continue;
                if (i == 0) {
                    return this.aax.getPrimaryOrthogonal();
                }
                return this.aax.getOverlay(i - 1);
            }
        }
        return null;
    }

    protected void validateAxis(Axis ax) throws ChartException {
        if (!ax.isSetType()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, (Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.axis.data.type", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        if (!ax.getLabel().isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, (Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.axis.label.visibility", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        if (!ax.getTitle().isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, (Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.axis.title.visibility", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        if (!ax.isSetLabelPosition() && ax.getLabel().isVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, (Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.axis.label.position", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        if (!ax.isSetTitlePosition() && ax.getTitle().isVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, (Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.axis.title.position", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        LineAttributes liaTicks = ax.getMajorGrid().getTickAttributes();
        if (!ax.getMajorGrid().isSetTickStyle() && liaTicks.isVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, (Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.axis.major.tick.style", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        liaTicks = ax.getMinorGrid().getTickAttributes();
        if (!ax.getMinorGrid().isSetTickStyle() && liaTicks.isVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 20, (Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.axis.minor.tick.style", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        int iOrientation = ax.getOrientation().getValue();
        if (iOrientation == 1) {
            int iPosition = -1;
            if (ax.getLabel().isVisible() && (iPosition = ax.getLabelPosition().getValue()) != 2 && iPosition != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.vaxis.label.position", new Object[]{ax.getLabelPosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            if (ax.getTitle().isVisible() && (iPosition = ax.getTitlePosition().getValue()) != 2 && iPosition != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.vaxis.title.position", new Object[]{ax.getLabelPosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            int iTickStyle = ax.getMajorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 0 && iTickStyle != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.vaxis.major.tick.style", new Object[]{ax.getMajorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            iTickStyle = ax.getMinorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 0 && iTickStyle != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.vaxis.minor.tick.style", new Object[]{ax.getMinorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
        } else if (iOrientation == 0) {
            int iPosition = -1;
            if (ax.getLabel().isVisible() && (iPosition = ax.getLabelPosition().getValue()) != 0 && iPosition != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.haxis.label.position", new Object[]{ax.getLabelPosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            if (ax.getTitle().isVisible() && (iPosition = ax.getTitlePosition().getValue()) != 0 && iPosition != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.haxis.title.position", new Object[]{ax.getTitlePosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            int iTickStyle = ax.getMajorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 2 && iTickStyle != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.haxis.major.tick.style", new Object[]{ax.getMajorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            iTickStyle = ax.getMinorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 2 && iTickStyle != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 20, "exception.illegal.haxis.minor.tick.style", new Object[]{ax.getMinorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
    }

    protected final DataSetIterator getTypedDataSet(Axis ax, int iType, int iSeriesIndex) throws ChartException, IllegalArgumentException {
        Series[] sea = ax.getRuntimeSeries();
        if (sea.length == 0) {
            if ((iType & 1) == 1) {
                return new DataSetIterator(new Double[]{new Double(1.0), new Double(2.0)});
            }
            if ((iType & 8) == 8) {
                return new DataSetIterator(new Calendar[]{new CDateTime(), new CDateTime()});
            }
            if ((iType & 0x10) == 16) {
                return new DataSetIterator(new String[]{"Category1", "Category2", "Category3"});
            }
        }
        return this.getTypedDataSet(sea[iSeriesIndex], iType);
    }

    protected final DataSetIterator getTypedDataSet(Series se, int iType) throws ChartException, IllegalArgumentException {
        DataSetIterator dsi = new DataSetIterator(se.getDataSet());
        if ((dsi.getDataType() & 0x10) == 16 && ((iType & 2) == 2 || (iType & 4) == 4 || (iType & 8) == 8)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.text.data.numerical.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if ((dsi.getDataType() & 1) == 1 && (iType & 8) == 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if ((dsi.getDataType() & 8) == 8 && ((iType & 2) == 2 || (iType & 4) == 4)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        return dsi;
    }

    protected final int getOrientation(int iBaseOrOrthogonal) {
        if (!this.cwa.isTransposed()) {
            return iBaseOrOrthogonal == 1 || iBaseOrOrthogonal == 3 ? 0 : 1;
        }
        return iBaseOrOrthogonal == 1 || iBaseOrOrthogonal == 3 ? 1 : 0;
    }

    public final Anchor transposedAnchor(Orientation or, Anchor an) throws IllegalArgumentException {
        if (an == null) {
            return null;
        }
        int iOrientation = or.getValue();
        if (iOrientation == 0) {
            switch (an.getValue()) {
                case 0: {
                    return Anchor.WEST_LITERAL;
                }
                case 4: {
                    return Anchor.EAST_LITERAL;
                }
                case 2: {
                    return Anchor.NORTH_LITERAL;
                }
                case 6: {
                    return Anchor.SOUTH_LITERAL;
                }
                case 7: {
                    return Anchor.SOUTH_WEST_LITERAL;
                }
                case 1: {
                    return Anchor.NORTH_WEST_LITERAL;
                }
                case 5: {
                    return Anchor.SOUTH_EAST_LITERAL;
                }
                case 3: {
                    return Anchor.NORTH_EAST_LITERAL;
                }
            }
        } else if (iOrientation == 1) {
            switch (an.getValue()) {
                case 0: {
                    return Anchor.EAST_LITERAL;
                }
                case 4: {
                    return Anchor.WEST_LITERAL;
                }
                case 2: {
                    return Anchor.SOUTH_LITERAL;
                }
                case 6: {
                    return Anchor.NORTH_LITERAL;
                }
                case 7: {
                    return Anchor.NORTH_EAST_LITERAL;
                }
                case 1: {
                    return Anchor.SOUTH_EAST_LITERAL;
                }
                case 5: {
                    return Anchor.NORTH_WEST_LITERAL;
                }
                case 3: {
                    return Anchor.SOUTH_WEST_LITERAL;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.anchor.transpose"), new Object[]{an, or}));
    }

    public final double getTransposedAngle(double dOriginalAngle) throws IllegalArgumentException {
        if (dOriginalAngle >= 0.0 && dOriginalAngle <= 90.0) {
            return -(90.0 - dOriginalAngle);
        }
        if (dOriginalAngle < 0.0 && dOriginalAngle >= -90.0) {
            return dOriginalAngle + 90.0;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.angle.range.transpose"), new Double(dOriginalAngle)));
    }

    public final int transposeLabelPosition(int iBaseOrOrthogonal, int iOriginalPosition) throws IllegalArgumentException {
        if (!this.cwa.isTransposed()) {
            return iOriginalPosition;
        }
        if (iBaseOrOrthogonal == 1) {
            switch (iOriginalPosition) {
                case 3: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
                case 5: 
                case 6: {
                    return iOriginalPosition;
                }
            }
        } else if (iBaseOrOrthogonal == 2) {
            switch (iOriginalPosition) {
                case 3: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
                case 5: 
                case 6: {
                    return iOriginalPosition;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.combination.axis.label.position"), new Integer(iBaseOrOrthogonal), new Integer(iOriginalPosition)));
    }

    protected final int transposeTickStyle(int iBaseOrOrthogonal, int iOriginalStyle) throws IllegalArgumentException {
        if (!this.cwa.isTransposed() || iOriginalStyle == 3 || iOriginalStyle == 0) {
            return iOriginalStyle;
        }
        if (iBaseOrOrthogonal == 1) {
            switch (iOriginalStyle) {
                case 2: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
        } else if (iBaseOrOrthogonal == 2) {
            switch (iOriginalStyle) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.combination.axis.tick.style"), new Integer(iBaseOrOrthogonal), new Integer(iOriginalStyle)));
    }

    protected final double adjustHorizontal(double dBlockX, double dBlockWidth, AllAxes aax) throws ChartException, IllegalArgumentException {
        double dX;
        OneAxis axPH = aax.areAxesSwapped() ? aax.getPrimaryOrthogonal() : aax.getPrimaryBase();
        OneAxis axPV = aax.areAxesSwapped() ? aax.getPrimaryBase() : aax.getPrimaryOrthogonal();
        AutoScale scX = axPH.getScale();
        AutoScale scY = axPV.getScale();
        int iXLabelLocation = axPH.getLabelPosition();
        int iYLabelLocation = axPV.getLabelPosition();
        int iYTitleLocation = axPV.getTitlePosition();
        Label laXAxisLabels = axPH.getLabel();
        Label laYAxisLabels = axPV.getLabel();
        Label laYAxisTitle = axPV.getTitle();
        int iYTickStyle = axPV.getCombinedTickStyle();
        IntersectionValue iv = axPV.getIntersectionValue();
        boolean bTicksLeft = (iYTickStyle & 1) == 1;
        boolean bTicksRight = (iYTickStyle & 2) == 2;
        double dAppliedYAxisPlotSpacing = iv.iType == 1 || iv.iType == 2 ? this.dYAxisPlotSpacing : 0.0;
        double dStart = scY.getStart();
        double dEnd = scY.getEnd();
        scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
        if (!scY.isStepFixed()) {
            Object[] oaMinMax = scY.getMinMax();
            while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation) && scY.zoomOut()) {
                scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                if (scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) continue;
                break;
            }
        }
        double dYAxisLabelsThickness = scY.computeAxisLabelThickness(this.ids, axPV.getLabel(), 1);
        double dYAxisTitleThickness = 0.0;
        if (laYAxisTitle.isVisible()) {
            String sPreviousValue = laYAxisTitle.getCaption().getValue();
            laYAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
            try {
                dYAxisTitleThickness = PlotWithAxes.computeBox(this.ids, iYTitleLocation, laYAxisTitle, 0.0, 0.0).getWidth();
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            finally {
                laYAxisTitle.getCaption().setValue(sPreviousValue);
            }
        }
        double dX1 = dX = PlotWithAxes.getLocation(scX, iv);
        double dX2 = dX;
        if (iv.iType == 2) {
            if (scX.getDirection() == -1) {
                dX = PlotWithAxes.getLocation(scX, IntersectionValue.MAX_VALUE);
            }
            dX1 = dX -= dAppliedYAxisPlotSpacing;
            dX2 = dX;
            if (bTicksLeft) {
                dX1 -= 5.0;
            }
            if (iYLabelLocation == 1) {
                dX1 -= dYAxisLabelsThickness;
                dX2 += Math.max(bTicksRight ? 5.0 : 0.0, dAppliedYAxisPlotSpacing);
            } else if (iYLabelLocation == 2) {
                dX2 += Math.max((double)(bTicksRight ? 5 : 0) + dYAxisLabelsThickness, dAppliedYAxisPlotSpacing);
            }
            if (iYTitleLocation == 1) {
                dX1 -= dYAxisTitleThickness;
            } else if (iYTitleLocation == 2) {
                dX2 += dYAxisTitleThickness;
            }
            if (dX1 < dBlockX) {
                double dDelta = dBlockX - dX1;
                dX1 = dBlockX;
                dX += dDelta;
                dX2 += dDelta;
            }
            double dDeltaX1 = dX - dX1;
            double dDeltaX2 = dX2 - dX;
            if (iYLabelLocation == 2) {
                dX2 = dX + dAppliedYAxisPlotSpacing;
            }
            dYAxisLabelsThickness = dX2 - dX1;
            scX.computeAxisStartEndShifts(this.ids, laXAxisLabels, 0, iXLabelLocation, aax);
            boolean startEndChanged = false;
            if (scX.getDirection() == -1) {
                if (dYAxisLabelsThickness > scX.getEndShift()) {
                    dEnd = dX2;
                    startEndChanged = true;
                } else {
                    dEnd = scX.getEnd();
                }
                dStart = scX.getStart();
            } else {
                if (dYAxisLabelsThickness > scX.getStartShift()) {
                    dStart = dX2;
                    startEndChanged = true;
                } else {
                    dStart = scX.getStart();
                }
                dEnd = scX.getEnd();
            }
            scX.resetShifts();
            scX.setEndPoints(dStart, dEnd);
            if (scX.getDirection() == -1) {
                scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax);
            } else {
                scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax);
            }
            if (!scX.isStepFixed()) {
                Object[] oaMinMax = scX.getMinMax();
                while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation) && scX.zoomOut()) {
                    scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scX.getDirection() == -1 ? scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax) : scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax);
                    if (scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) continue;
                    break;
                }
            }
            if (scX.getDirection() == -1) {
                if (dYAxisLabelsThickness < scX.getEndShift()) {
                    dX = scX.getEnd() - (dX2 - dX);
                }
            } else if (dYAxisLabelsThickness < scX.getStartShift()) {
                dX = scX.getStart() - (dX2 - dX);
            }
            dX2 = (dX -= this.insCA.getLeft()) + dDeltaX2;
            dX1 = dX - dDeltaX1;
            axPV.setTitleCoordinate(iYTitleLocation == 1 ? dX1 - 1.0 : dX2 + 1.0 - dYAxisTitleThickness);
        } else if (iv.iType == 1) {
            if (scX.getDirection() == -1) {
                dX = PlotWithAxes.getLocation(scX, IntersectionValue.MIN_VALUE);
            }
            dX1 = dX += dAppliedYAxisPlotSpacing;
            dX2 = dX;
            if (bTicksRight) {
                dX2 += 5.0;
            }
            if (iYLabelLocation == 2) {
                dX2 += dYAxisLabelsThickness;
                dX1 -= Math.max(bTicksLeft ? 5.0 : 0.0, dAppliedYAxisPlotSpacing);
            } else if (iYLabelLocation == 1) {
                dX1 -= Math.max((double)(bTicksLeft ? 5 : 0) + dYAxisLabelsThickness, dAppliedYAxisPlotSpacing);
            }
            if (iYTitleLocation == 2) {
                dX2 += dYAxisTitleThickness;
            } else if (iYTitleLocation == 1) {
                dX1 -= dYAxisTitleThickness;
            }
            if (dX2 > dBlockX + dBlockWidth) {
                double dDelta = dX2 - (dBlockX + dBlockWidth);
                dX2 = dBlockX + dBlockWidth;
                dX -= dDelta;
                dX1 -= dDelta;
            }
            double dDeltaX1 = dX - dX1;
            double dDeltaX2 = dX2 - dX;
            if (iYLabelLocation == 1) {
                dX1 = dX - dAppliedYAxisPlotSpacing;
            }
            dYAxisLabelsThickness = dX2 - dX1;
            scX.computeAxisStartEndShifts(this.ids, laXAxisLabels, 0, iXLabelLocation, aax);
            boolean startEndChanged = false;
            if (scX.getDirection() == -1) {
                if (dYAxisLabelsThickness > scX.getStartShift()) {
                    dStart = dX1;
                    startEndChanged = true;
                } else {
                    dStart = scX.getStart();
                }
                dEnd = scX.getEnd();
            } else {
                if (dYAxisLabelsThickness > scX.getEndShift()) {
                    dEnd = dX1;
                    startEndChanged = true;
                } else {
                    dEnd = scX.getEnd();
                }
                dStart = scX.getStart();
            }
            scX.resetShifts();
            scX.setEndPoints(dStart, dEnd);
            if (scX.getDirection() == -1) {
                scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax);
            } else {
                scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax);
            }
            if (!scX.isStepFixed()) {
                Object[] oaMinMax = scX.getMinMax();
                while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation) && scX.zoomOut()) {
                    scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scX.getDirection() == -1 ? scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax) : scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax);
                    if (scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) continue;
                    break;
                }
            }
            if (scX.getDirection() == -1) {
                if (dYAxisLabelsThickness < scX.getStartShift()) {
                    dX = scX.getStart() - (dX1 - dX);
                }
            } else if (dYAxisLabelsThickness < scX.getEndShift()) {
                dX = scX.getEnd() - (dX1 - dX);
            }
            dX2 = (dX += this.insCA.getRight()) + dDeltaX2;
            dX1 = dX - dDeltaX1;
            axPV.setTitleCoordinate(iYTitleLocation == 1 ? dX1 - 1.0 : dX2 + 1.0 - dYAxisTitleThickness);
        } else {
            double dDeltaX1 = 0.0;
            double dDeltaX2 = 0.0;
            if (iYTitleLocation == 2) {
                dX2 += dYAxisTitleThickness;
            } else if (iYTitleLocation == 1) {
                dX1 -= dYAxisTitleThickness;
            }
            if (iYLabelLocation == 1) {
                int n = bTicksRight ? 5 : 0;
                dDeltaX1 = dX - (dX1 -= (double)(bTicksLeft ? 5 : 0) + dYAxisLabelsThickness);
                dDeltaX2 = (dX2 += (double)n) - dX;
                if (dX1 < dBlockX) {
                    Object[] oaMinMax = scX.getMinMax();
                    boolean bForceBreak = false;
                    block8: do {
                        double dDelta;
                        double dAMax_RI;
                        double dAMin_AMax;
                        scX.setEndPoints(scX.getStart() - scX.getStartShift(), scX.getEnd() + scX.getEndShift());
                        scX.resetShifts();
                        double[] da = scX.getEndPoints();
                        double dT_RI = dBlockX - dX1;
                        if (scX.getDirection() == -1) {
                            dAMin_AMax = da[0] - da[1];
                            dAMax_RI = Math.abs(da[0] - dX);
                            dDelta = dT_RI / dAMax_RI * dAMin_AMax;
                            dEnd = da[1] + dDelta;
                            dStart = da[0];
                            if (dEnd < dBlockX) {
                                dEnd = dBlockX;
                                bForceBreak = true;
                            }
                        } else {
                            dAMin_AMax = da[1] - da[0];
                            dAMax_RI = Math.abs(da[1] - dX);
                            dDelta = dT_RI / dAMax_RI * dAMin_AMax;
                            dStart = da[0] + dDelta;
                            dEnd = da[1];
                            if (dStart < dBlockX) {
                                dStart = dBlockX;
                                bForceBreak = true;
                            }
                        }
                        scX.setEndPoints(dStart, dEnd);
                        scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                        while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                            if (!scX.zoomOut()) {
                                bForceBreak = true;
                                continue block8;
                            }
                            scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                            if (scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) continue;
                            bForceBreak = true;
                            continue block8;
                        }
                    } while (Math.abs((dX1 = (dX = PlotWithAxes.getLocation(scX, iv)) - dDeltaX1) - dBlockX) > 1.0 && !bForceBreak);
                } else {
                    dStart = scX.getStart();
                    dEnd = scX.getEnd();
                    scX.setEndPoints(dStart, dEnd);
                    scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                    if (!scX.isStepFixed()) {
                        Object[] oaMinMax = scX.getMinMax();
                        while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation) && scX.zoomOut()) {
                            scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                            if (scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) continue;
                            break;
                        }
                    }
                    dX = PlotWithAxes.getLocation(scX, iv);
                }
                dX1 = dX - dDeltaX1;
                dX2 = dX + dDeltaX2;
            } else if (iYLabelLocation == 2) {
                dDeltaX1 = dX - (dX1 -= (double)(bTicksLeft ? 5 : 0));
                dDeltaX2 = (dX2 += (double)(bTicksRight ? 5 : 0) + dYAxisLabelsThickness) - dX;
                if (dX2 > dBlockX + dBlockWidth) {
                    Object[] oaMinMax = scX.getMinMax();
                    boolean bForceBreak = false;
                    block11: do {
                        double dDelta;
                        double dAMin_RI;
                        double dAMin_AMax;
                        scX.setEndPoints(scX.getStart() - scX.getStartShift(), scX.getEnd() + scX.getEndShift());
                        scX.resetShifts();
                        double[] da = scX.getEndPoints();
                        double dT_RI = dX2 - (dBlockX + dBlockWidth);
                        if (scX.getDirection() == -1) {
                            dAMin_AMax = da[0] - da[1];
                            dAMin_RI = Math.abs(dX - da[1]);
                            dDelta = Math.abs(dT_RI / dAMin_RI) * dAMin_AMax;
                            dStart = da[0] - dDelta;
                            dEnd = da[1];
                            if (dStart > dBlockX + dBlockWidth) {
                                dStart = dBlockX + dBlockWidth;
                                bForceBreak = true;
                            }
                        } else {
                            dAMin_AMax = da[1] - da[0];
                            dAMin_RI = Math.abs(dX - da[0]);
                            dDelta = dT_RI / dAMin_RI * dAMin_AMax;
                            dEnd = da[1] - dDelta;
                            dStart = da[0];
                            if (dEnd > dBlockX + dBlockWidth) {
                                dEnd = dBlockX + dBlockWidth;
                                bForceBreak = true;
                            }
                        }
                        scX.setEndPoints(dStart, dEnd);
                        scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                        if (scX.isStepFixed()) continue;
                        while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                            if (!scX.zoomOut()) {
                                bForceBreak = true;
                                continue block11;
                            }
                            scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                            if (scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) continue;
                            bForceBreak = true;
                            continue block11;
                        }
                    } while (Math.abs((dX2 = (dX = PlotWithAxes.getLocation(scX, iv)) + dDeltaX2) - (dBlockX + dBlockWidth)) > 1.0 && !bForceBreak);
                } else {
                    dStart = scX.getStart();
                    dEnd = scX.getEnd();
                    scX.setEndPoints(dStart, dEnd);
                    scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                    if (!scX.isStepFixed()) {
                        Object[] oaMinMax = scX.getMinMax();
                        while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation) && scX.zoomOut()) {
                            scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                            if (scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) continue;
                            break;
                        }
                    }
                    dX = PlotWithAxes.getLocation(scX, iv);
                }
                dX2 = dX + dDeltaX2;
                dX1 = dX - dDeltaX1;
            }
            axPV.setTitleCoordinate(iYTitleLocation == 1 ? dX1 - 1.0 : dX2 + 1.0 - dYAxisTitleThickness);
        }
        return dX;
    }

    protected final double adjustVerticalDueToHorizontal(double dBlockY, double dBlockHeight, AllAxes aax) throws ChartException, IllegalArgumentException {
        boolean bForwardScale;
        double dY;
        OneAxis axPH = aax.areAxesSwapped() ? aax.getPrimaryOrthogonal() : aax.getPrimaryBase();
        OneAxis axPV = aax.areAxesSwapped() ? aax.getPrimaryBase() : aax.getPrimaryOrthogonal();
        AutoScale scX = axPH.getScale();
        AutoScale scY = axPV.getScale();
        int iXLabelLocation = axPH.getLabelPosition();
        int iYLabelLocation = axPV.getLabelPosition();
        int iXTitleLocation = axPH.getTitlePosition();
        Label laXAxisTitle = axPH.getTitle();
        Label laYAxisLabels = axPV.getLabel();
        int iXTickStyle = axPH.getCombinedTickStyle();
        IntersectionValue iv = axPH.getIntersectionValue();
        double dXAxisLabelsThickness = scX.computeAxisLabelThickness(this.ids, axPH.getLabel(), 0);
        double dXAxisTitleThickness = 0.0;
        if (laXAxisTitle.isVisible()) {
            String sPreviousValue = laXAxisTitle.getCaption().getValue();
            laXAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
            try {
                dXAxisTitleThickness = PlotWithAxes.computeBox(this.ids, iXTitleLocation, laXAxisTitle, 0.0, 0.0).getHeight();
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            finally {
                laXAxisTitle.getCaption().setValue(sPreviousValue);
            }
        }
        double dY1 = dY = PlotWithAxes.getLocation(scY, iv);
        double dY2 = dY;
        boolean bTicksAbove = (iXTickStyle & 1) == 1;
        boolean bTicksBelow = (iXTickStyle & 2) == 2;
        double dAppliedXAxisPlotSpacing = iv.iType == 1 || iv.iType == 2 ? this.dXAxisPlotSpacing : 0.0;
        boolean bl = bForwardScale = scY.getDirection() == 1;
        if (bForwardScale && iv.iType == 2 || !bForwardScale && iv.iType == 1) {
            dY1 = dY -= dAppliedXAxisPlotSpacing;
            dY2 = dY;
            if (bTicksAbove) {
                dY1 -= 5.0;
            }
            if (iXLabelLocation == 3) {
                dY1 -= dXAxisLabelsThickness;
                dY2 += Math.max(bTicksBelow ? 5.0 : 0.0, dAppliedXAxisPlotSpacing);
            } else if (iXLabelLocation == 4) {
                dY2 += Math.max((double)(bTicksBelow ? 5 : 0) + dXAxisLabelsThickness, dAppliedXAxisPlotSpacing);
            }
            if (iXTitleLocation == 3) {
                dY1 -= dXAxisTitleThickness;
            } else if (iXTitleLocation == 4) {
                dY2 += dXAxisTitleThickness;
            }
            if (dY1 < dBlockY) {
                double dDelta = dBlockY - dY1;
                dY1 = dBlockY;
                dY += dDelta;
                dY2 += dDelta;
            }
            double dDeltaY1 = dY - dY1;
            double dDeltaY2 = dY2 - dY;
            dXAxisLabelsThickness = 0.0;
            if (iXLabelLocation == 3) {
                dXAxisLabelsThickness = dY2 - dY1;
            } else if (iXLabelLocation == 4) {
                dY2 = dY + dAppliedXAxisPlotSpacing;
                dXAxisLabelsThickness = dY2 - dY1;
            }
            if (bForwardScale && dXAxisLabelsThickness > scY.getStartShift() || !bForwardScale && dXAxisLabelsThickness > scY.getEndShift()) {
                double dStart = scY.getStart();
                double dEnd = dY2 - scY.getEndShift();
                if (bForwardScale) {
                    dStart = dY2 - scY.getStartShift();
                    dEnd = scY.getEnd();
                }
                scY.resetShifts();
                scY.setEndPoints(dStart, dEnd);
                scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                if (!scY.isStepFixed()) {
                    Object[] oaMinMax = scY.getMinMax();
                    while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation) && scY.zoomOut()) {
                        scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                        if (scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) continue;
                        break;
                    }
                }
            }
            dY1 = (dY -= this.insCA.getTop()) - dDeltaY1;
            dY2 = dY + dDeltaY2;
            axPH.setTitleCoordinate(iXTitleLocation == 3 ? dY1 - 1.0 : dY2 + 1.0 - dXAxisTitleThickness);
        } else if (bForwardScale && iv.iType == 1 || !bForwardScale && iv.iType == 2) {
            dY1 = dY += dAppliedXAxisPlotSpacing;
            dY2 = dY;
            if (bTicksBelow) {
                dY2 += 5.0;
            }
            if (iXLabelLocation == 3) {
                dY1 -= Math.max((double)(bTicksAbove ? 5 : 0) + dXAxisLabelsThickness, dAppliedXAxisPlotSpacing);
            } else if (iXLabelLocation == 4) {
                dY2 += dXAxisLabelsThickness;
                dY1 -= Math.max(bTicksAbove ? 5.0 : 0.0, dAppliedXAxisPlotSpacing);
            }
            if (iXTitleLocation == 3) {
                dY1 -= dXAxisTitleThickness;
            } else if (iXTitleLocation == 4) {
                dY2 += dXAxisTitleThickness;
            }
            if (dY2 > dBlockY + dBlockHeight) {
                double dDelta = dY2 - (dBlockY + dBlockHeight);
                dY2 = dBlockY + dBlockHeight;
                dY -= dDelta;
                dY1 -= dDelta;
            }
            double dDeltaY1 = dY - dY1;
            double dDeltaY2 = dY2 - dY;
            dXAxisLabelsThickness = 0.0;
            if (iXLabelLocation == 3) {
                dY1 = dY - dAppliedXAxisPlotSpacing;
                dXAxisLabelsThickness = dY2 - dY1;
            } else if (iXLabelLocation == 4) {
                dXAxisLabelsThickness = dY2 - dY1;
            }
            if (bForwardScale && dXAxisLabelsThickness > scY.getEndShift() || !bForwardScale && dXAxisLabelsThickness > scY.getStartShift()) {
                double dStart = dY1 + scY.getStartShift();
                double dEnd = scY.getEnd();
                if (bForwardScale) {
                    dStart = scY.getStart();
                    dEnd = dY1 + scY.getEndShift();
                }
                scY.resetShifts();
                scY.setEndPoints(dStart, dEnd);
                scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                if (!scY.isStepFixed()) {
                    Object[] oaMinMax = scY.getMinMax();
                    while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation) && scY.zoomOut()) {
                        scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                        if (scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) continue;
                        break;
                    }
                }
            }
            dY1 = (dY += this.insCA.getBottom()) - dDeltaY1;
            dY2 = dY + dDeltaY2;
            axPH.setTitleCoordinate(iXTitleLocation == 3 ? dY1 - 1.0 : dY2 + 1.0 - dXAxisTitleThickness);
        } else {
            double dDeltaY1 = 0.0;
            double dDeltaY2 = 0.0;
            if (iXLabelLocation == 3) {
                dY1 -= (double)(bTicksAbove ? 5 : 0) + dXAxisLabelsThickness;
                dY2 += (double)(bTicksBelow ? 5 : 0);
                if (iXTitleLocation == 3) {
                    dY1 -= dXAxisTitleThickness;
                } else if (iXTitleLocation == 4) {
                    dY2 += dXAxisTitleThickness;
                }
                dDeltaY1 = dY - dY1;
                dDeltaY2 = dY2 - dY;
                if (dY1 < dBlockY) {
                    Object[] oaMinMax = scY.getMinMax();
                    boolean bForceBreak = false;
                    do {
                        double dStart;
                        double dEnd;
                        double dAMin_RI;
                        double dAMin_AMax;
                        scY.setEndPoints(scY.getStart() + scY.getStartShift(), scY.getEnd() - scY.getEndShift());
                        scY.resetShifts();
                        double[] da = scY.getEndPoints();
                        double dT_RI = dBlockY - dY1;
                        if (bForwardScale) {
                            dAMin_AMax = da[1] - da[0];
                            dAMin_RI = da[1] - dY;
                            dEnd = da[1];
                            dStart = dT_RI / dAMin_RI * dAMin_AMax + da[0];
                            if (dStart < dBlockY) {
                                dStart = dBlockY;
                                bForceBreak = true;
                            }
                        } else {
                            dAMin_AMax = da[0] - da[1];
                            dAMin_RI = da[0] - dY;
                            dStart = da[0];
                            dEnd = dT_RI / dAMin_RI * dAMin_AMax + da[1];
                            if (dEnd < dBlockY) {
                                dEnd = dBlockY;
                                bForceBreak = true;
                            }
                        }
                        scY.setEndPoints(dStart, dEnd);
                        scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                        if (!scY.isStepFixed()) {
                            while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                                if (!scY.zoomOut()) {
                                    bForceBreak = true;
                                    break;
                                }
                                scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                                int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                                if (scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) continue;
                                bForceBreak = true;
                                break;
                            }
                        }
                        dY = PlotWithAxes.getLocation(scY, iv);
                        dY1 = dY - dDeltaY1;
                        dY2 = dY + dDeltaY2;
                    } while (Math.abs(dY1 - dBlockY) > 1.0 && !bForceBreak);
                }
            } else if (iXLabelLocation == 4) {
                dY1 -= (double)(bTicksAbove ? 5 : 0);
                dY2 += (double)(bTicksBelow ? 5 : 0) + dXAxisLabelsThickness;
                if (iXTitleLocation == 3) {
                    dY1 -= dXAxisTitleThickness;
                } else if (iXTitleLocation == 4) {
                    dY2 += dXAxisTitleThickness;
                }
                dDeltaY1 = dY - dY1;
                dDeltaY2 = dY2 - dY;
                if (dY2 > dBlockY + dBlockHeight) {
                    Object[] oaMinMax = scY.getMinMax();
                    boolean bForceBreak = false;
                    do {
                        double dStart;
                        double dEnd;
                        double dX2_AMax;
                        double dAMin_AMax;
                        scY.setEndPoints(scY.getStart() + scY.getStartShift(), scY.getEnd() - scY.getEndShift());
                        scY.resetShifts();
                        double[] da = scY.getEndPoints();
                        double dX2_X1 = dY2 - (dBlockY + dBlockHeight);
                        if (bForwardScale) {
                            dAMin_AMax = da[1] - da[0];
                            dX2_AMax = dY - da[0];
                            dEnd = da[1] - dX2_X1 / dX2_AMax * dAMin_AMax;
                            dStart = da[0];
                            if (dEnd > dBlockY + dBlockHeight) {
                                dEnd = dBlockY + dBlockHeight;
                                bForceBreak = true;
                            }
                        } else {
                            dAMin_AMax = da[0] - da[1];
                            dX2_AMax = dY - da[1];
                            dStart = da[0] - dX2_X1 / dX2_AMax * dAMin_AMax;
                            dEnd = da[1];
                            if (dStart > dBlockY + dBlockHeight) {
                                dStart = dBlockY + dBlockHeight;
                                bForceBreak = true;
                            }
                        }
                        scY.setEndPoints(dStart, dEnd);
                        scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                        if (!scY.isStepFixed()) {
                            while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                                if (!scY.zoomOut()) {
                                    bForceBreak = true;
                                    break;
                                }
                                scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                                int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                                if (scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) continue;
                                bForceBreak = true;
                                break;
                            }
                        }
                        dY = PlotWithAxes.getLocation(scY, iv);
                        dY2 = dY + dDeltaY2;
                        dY1 = dY - dDeltaY1;
                    } while (Math.abs(dY2 - (dBlockY + dBlockHeight)) > 1.0 && !bForceBreak);
                }
            }
            axPH.setTitleCoordinate(iXTitleLocation == 3 ? dY1 - 1.0 : dY2 + 1.0 - dXAxisTitleThickness);
        }
        return dY;
    }

    protected boolean isRightToLeft() {
        if (this.rtc == null) {
            return false;
        }
        return this.rtc.isRightToLeft();
    }

    protected Position switchPosition(Position po) {
        if (this.isRightToLeft()) {
            if (po == Position.RIGHT_LITERAL) {
                po = Position.LEFT_LITERAL;
            } else if (po == Position.LEFT_LITERAL) {
                po = Position.RIGHT_LITERAL;
            } else if (po == Position.ABOVE_LITERAL) {
                po = Position.BELOW_LITERAL;
            } else if (po == Position.BELOW_LITERAL) {
                po = Position.ABOVE_LITERAL;
            }
        }
        return po;
    }

    protected Anchor switchAnchor(Anchor anchor) {
        if (this.isRightToLeft()) {
            switch (anchor.getValue()) {
                case 2: {
                    anchor = Anchor.WEST_LITERAL;
                    break;
                }
                case 1: {
                    anchor = Anchor.NORTH_WEST_LITERAL;
                    break;
                }
                case 3: {
                    anchor = Anchor.SOUTH_WEST_LITERAL;
                    break;
                }
                case 6: {
                    anchor = Anchor.EAST_LITERAL;
                    break;
                }
                case 7: {
                    anchor = Anchor.NORTH_EAST_LITERAL;
                    break;
                }
                case 5: {
                    anchor = Anchor.SOUTH_EAST_LITERAL;
                }
            }
        }
        return anchor;
    }

    protected int switchTickStyle(int tickStyle) {
        if (this.isRightToLeft()) {
            if (tickStyle == 1) {
                tickStyle = 2;
            } else if (tickStyle == 2) {
                tickStyle = 1;
            }
        }
        return tickStyle;
    }

    protected IntersectionValue switchIntersection(IntersectionValue iv) {
        if (this.isRightToLeft()) {
            if (iv.getType() == 1) {
                iv = IntersectionValue.MIN_VALUE;
            } else if (iv.getType() == 2) {
                iv = IntersectionValue.MAX_VALUE;
            }
        }
        return iv;
    }
}

