/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.script;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.chart.script.IChartScriptContext;
import org.eclipse.birt.chart.script.IExternalContext;

public class ChartScriptContext
implements IChartScriptContext {
    private static final long serialVersionUID = 1L;
    private transient IExternalContext externalContext;
    private ULocale locale;
    private transient Chart cm;
    private transient ILogger logger;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ByteArrayOutputStream bao = null;
        try {
            bao = SerializerImpl.instance().asXml(this.cm, true);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.log(e);
            }
            bao = new ByteArrayOutputStream();
        }
        out.writeObject(bao.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ByteArrayInputStream bai = new ByteArrayInputStream((byte[])in.readObject());
        try {
            this.cm = SerializerImpl.instance().fromXml(bai, true);
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.log(e);
            }
            this.cm = null;
        }
    }

    public Chart getChartInstance() {
        return this.cm;
    }

    public void setChartInstance(Chart cm) {
        this.cm = cm;
    }

    public IExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(IExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public Locale getLocale() {
        return this.locale == null ? null : this.locale.toLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = ULocale.forLocale((Locale)locale);
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }
}

