/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.RAInputStream;

public class RAFileInputStream
extends RAInputStream {
    private RandomAccessFile parent;
    private long startPos;
    private long endPos;
    private long cur;
    private byte[] buf;
    private int bufLen;
    private int bufCur;

    public RAFileInputStream(RandomAccessFile parentFile, long startPos, long endPos) {
        this.parent = parentFile;
        this.startPos = startPos;
        this.endPos = endPos;
        this.buf = new byte[8192];
        this.cur = 0L;
        this.bufLen = 0;
        this.bufCur = 0;
    }

    private void readToBuffer() throws IOException {
        this.bufLen = 0;
        this.bufCur = 0;
        long availableSize = this.endPos - this.localPosToGlobalPos(this.cur);
        if (availableSize <= 0L) {
            return;
        }
        int len = (int)Math.min((long)this.buf.length, availableSize);
        this.seekParent(this.cur);
        this.bufLen = this.parent.read(this.buf, 0, len);
        this.cur += (long)this.bufLen;
    }

    public int read() throws IOException {
        if (this.bufLen <= 0 || this.bufLen == this.bufCur) {
            this.readToBuffer();
        }
        if (this.bufLen <= 0) {
            return -1;
        }
        return this.buf[this.bufCur++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        while ((count = this.read1(b, off + n, len - n)) >= 0 && (n += count) < len) {
        }
        return n > 0 ? n : -1;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        if (this.bufLen <= 0 || this.bufLen == this.bufCur) {
            this.readToBuffer();
        }
        if (this.bufLen <= 0) {
            return -1;
        }
        int availableSize = this.bufLen - this.bufCur;
        if (len > availableSize) {
            len = availableSize;
        }
        System.arraycopy(this.buf, this.bufCur, b, off, len);
        this.bufCur += len;
        return len;
    }

    public int readInt() throws IOException {
        byte[] ch = new byte[4];
        this.readFully(ch, 0, 4);
        int ret = 0;
        for (int i = 0; i < ch.length; ++i) {
            ret = ret << 8 & 0xFFFFFF00 | ch[i] & 0xFF;
        }
        return ret;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    public long getStreamLength() {
        return this.endPos - this.startPos;
    }

    public void seek(long localPos) throws IOException {
        if (this.localPosToGlobalPos(localPos) >= this.endPos) {
            throw new IOException("The seek position is out of range.");
        }
        if (localPos < this.cur - (long)this.bufLen || localPos > this.cur) {
            this.cur = localPos;
            this.bufCur = 0;
            this.bufLen = 0;
        } else {
            this.bufCur = this.bufLen - (int)(this.cur - localPos);
        }
    }

    public long getOffset() throws IOException {
        return this.cur - (long)this.bufLen + (long)this.bufCur;
    }

    public long length() throws IOException {
        return this.getStreamLength();
    }

    private long localPosToGlobalPos(long localPos) {
        return localPos + this.startPos;
    }

    private void seekParent(long localPos) throws IOException {
        this.parent.seek(this.localPosToGlobalPos(localPos));
    }
}

