/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Logger;

public class StringFormatter {
    protected static Logger logger = Logger.getLogger(StringFormatter.class.getName());
    protected String formatPattern;
    private ULocale locale = ULocale.getDefault();
    private char chcase;
    private int nand;
    private int natt;
    private boolean dir;

    private void init() {
        this.formatPattern = "";
        this.chcase = (char)32;
        this.nand = 0;
        this.natt = 0;
        this.dir = false;
    }

    public StringFormatter() {
        this.applyPattern(null);
    }

    public StringFormatter(ULocale locale) {
        this.locale = locale;
        this.applyPattern(null);
    }

    public StringFormatter(Locale locale) {
        this(ULocale.forLocale((Locale)locale));
    }

    public StringFormatter(String format) {
        this.applyPattern(format);
    }

    public StringFormatter(String format, ULocale locale) {
        this.locale = locale;
        this.applyPattern(format);
    }

    public StringFormatter(String format, Locale locale) {
        this(format, ULocale.forLocale((Locale)locale));
    }

    public void applyPattern(String format) {
        this.init();
        if (format == null) {
            return;
        }
        int c = 32;
        StringBuffer scan = new StringBuffer(format);
        int len = scan.length();
        block6: for (int i = 0; i < len; ++i) {
            c = scan.charAt(i);
            switch (c) {
                case 64: {
                    ++this.natt;
                    continue block6;
                }
                case 38: {
                    ++this.nand;
                    continue block6;
                }
                case 60: 
                case 62: {
                    this.chcase = (char)c;
                    continue block6;
                }
                case 33: {
                    this.dir = true;
                }
            }
        }
        if ("Zip Code + 4".equalsIgnoreCase(format)) {
            this.applyPattern("@@@@@-@@@@");
            return;
        }
        if ("Phone Number".equalsIgnoreCase(format)) {
            this.applyPattern("(@@@)@@@-@@@@");
            return;
        }
        if ("Social Security Number".equalsIgnoreCase(format)) {
            this.applyPattern("@@@-@@-@@@@");
            return;
        }
        this.formatPattern = format;
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    public void setLocale(ULocale theLocale) {
        this.locale = theLocale;
    }

    public void setLocale(Locale theLocale) {
        this.setLocale(ULocale.forLocale((Locale)theLocale));
    }

    private String handleCase(String val, char option) {
        if (option == '<') {
            return val.toLowerCase();
        }
        if (option == '>') {
            return val.toUpperCase();
        }
        return val;
    }

    public String format(String str) {
        if (this.formatPattern.equals("Unformatted")) {
            return str;
        }
        int len = str.length();
        int col = this.natt + this.nand;
        int ext = 0;
        StringBuffer orig = new StringBuffer(str);
        StringBuffer fstr = new StringBuffer(this.formatPattern);
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        int pos = 0;
        int len2 = 0;
        char fc = ' ';
        String sc = null;
        if (!this.dir) {
            if (len > col) {
                ret.append(this.handleCase(orig.substring(0, len - col), this.chcase));
                pos = len - col;
                len = col;
            }
            ext = col - len;
        }
        len2 = this.formatPattern.length();
        block4: for (i = 0; i < len2; ++i) {
            fc = fstr.charAt(i);
            switch (fc) {
                case '&': 
                case '@': {
                    if (ext > 0 || len == 0) {
                        if (fc == '@') {
                            ret.append(' ');
                        }
                        --ext;
                        continue block4;
                    }
                    sc = orig.substring(pos, pos + 1);
                    ret.append(this.handleCase(sc, this.chcase));
                    ++pos;
                    --len;
                    continue block4;
                }
                case '!': 
                case '<': 
                case '>': {
                    continue block4;
                }
                default: {
                    ret.append(fc);
                }
            }
        }
        while (--len >= 0) {
            sc = orig.substring(pos, pos + 1);
            ret.append(this.handleCase(sc, this.chcase));
            ++pos;
        }
        return ret.toString();
    }

    public String parser(String str) throws ParseException {
        int k;
        int lenFormatStr;
        if (this.formatPattern == null || "".equals(this.formatPattern) || this.formatPattern.indexOf(">") > -1 || this.formatPattern.indexOf("<") > -1) {
            return str;
        }
        StringBuffer orig = new StringBuffer(str);
        StringBuffer fstr = new StringBuffer("");
        StringBuffer ret = new StringBuffer("");
        for (int i = 0; i < this.formatPattern.length(); ++i) {
            if (this.formatPattern.charAt(i) == '!' || this.formatPattern.charAt(i) == '>' || this.formatPattern.charAt(i) == '<') continue;
            fstr.append(this.formatPattern.charAt(i));
        }
        int fc = 32;
        int lenPattern = fstr.length();
        if (lenPattern > (lenFormatStr = orig.length())) {
            if (this.dir) {
                for (k = lenFormatStr; k < lenPattern; ++k) {
                    if (fstr.charAt(k) != '&') {
                        throw new ParseException("Unparseable string: \"" + orig.toString() + "\"", k);
                    }
                    orig.append(" ");
                }
            } else {
                for (k = 0; k < lenPattern - lenFormatStr; ++k) {
                    if (fstr.charAt(lenPattern - lenFormatStr - k - 1) != '&') {
                        throw new ParseException("Unparseable string: \"" + orig.toString() + "\"", 0);
                    }
                    orig.insert(0, " ");
                }
            }
        } else if (lenPattern < lenFormatStr) {
            if (this.dir) {
                for (k = lenPattern; k < lenFormatStr; ++k) {
                    fstr.append('&');
                }
            } else {
                for (k = lenPattern; k < lenFormatStr; ++k) {
                    fstr.insert(0, '&');
                }
            }
        }
        int index = 0;
        int count = lenPattern > lenFormatStr ? lenPattern : lenFormatStr;
        block10: for (int i = 0; i < count; ++i) {
            fc = fstr.charAt(i);
            switch (fc) {
                case 64: {
                    if (orig.charAt(index) != ' ') {
                        ret.append(orig.charAt(index));
                    }
                    ++index;
                    continue block10;
                }
                case 38: {
                    ret.append(orig.charAt(index));
                    ++index;
                    continue block10;
                }
                case 60: 
                case 62: {
                    return str;
                }
                default: {
                    if (orig.charAt(index) != fstr.charAt(i)) {
                        throw new ParseException("Unparseable string: \"" + orig.toString() + "\"", index);
                    }
                    ++index;
                }
            }
        }
        return ret.toString();
    }
}

