/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import com.ibm.icu.text.Collator;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;

public class BirtComp {
    private static Collator myCollator = Collator.getInstance();

    public static boolean anyOf(Object val, Object[] vals) {
        if (vals == null) {
            return false;
        }
        for (int i = 0; i < vals.length; ++i) {
            try {
                if (BirtComp.compare(val, vals[i]) != 0) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean between(Object val, Object r1, Object r2) {
        try {
            Object max;
            Object min;
            if (BirtComp.compare(r1, r2) <= 0) {
                min = r1;
                max = r2;
            } else {
                min = r2;
                max = r1;
            }
            return BirtComp.compare(val, min) >= 0 && BirtComp.compare(val, max) <= 0;
        }
        catch (BirtException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    private static int compare(Object obj1, Object obj2) throws BirtException {
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            return 0;
        }
        if (BirtComp.isSameType(obj1, obj2)) {
            if (obj1 instanceof Boolean) {
                if (obj1.equals(obj2)) {
                    return 0;
                }
                Boolean bool = (Boolean)obj1;
                if (bool.equals(Boolean.TRUE)) {
                    return 1;
                }
                return -1;
            }
            if (obj1 instanceof Comparable) {
                if (obj1 instanceof String) {
                    return myCollator.compare(obj1, obj2);
                }
                return ((Comparable)obj1).compareTo(obj2);
            }
            return myCollator.compare(obj1.toString(), obj2.toString());
        }
        if (BirtComp.isNumericOrString(obj1) && BirtComp.isNumericOrString(obj2)) {
            return DataTypeUtil.toDouble(obj1).compareTo(DataTypeUtil.toDouble(obj2));
        }
        if (BirtComp.isDateOrString(obj1) && BirtComp.isDateOrString(obj2)) {
            return DataTypeUtil.toDate(obj1).compareTo(DataTypeUtil.toDate(obj2));
        }
        throw new IllegalArgumentException();
    }

    private static boolean isSameType(Object resultExpr, Object resultOp1) {
        return resultExpr.getClass().equals(resultOp1.getClass());
    }

    private static boolean isNumericOrString(Object result) {
        return result instanceof Number || result instanceof String;
    }

    private static boolean isDateOrString(Object result) {
        return result instanceof Date || result instanceof String;
    }
}

