/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class FileArchiveWriter
implements IDocArchiveWriter {
    private String fileName;
    private FolderArchiveWriter folderWriter;
    private LinkedList openStreams = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileArchiveWriter(String fileName) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            throw new IOException("The file name is null or empty string.");
        }
        File fd = new File(fileName);
        this.fileName = fileName = fd.getCanonicalPath();
        String tempFolder = ArchiveUtil.generateUniqueFileFolderName(fileName);
        File archiveRootFolder = new File(tempFolder);
        if (!$assertionsDisabled && archiveRootFolder.exists()) {
            throw new AssertionError();
        }
        archiveRootFolder.mkdirs();
        this.folderWriter = new FolderArchiveWriter(tempFolder);
    }

    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        RAOutputStream raOutputStream = this.folderWriter.createRandomAccessStream(relativePath);
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.add(raOutputStream);
        }
        return raOutputStream;
    }

    public boolean dropStream(String relativePath) {
        return false;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean exists(String relativePath) {
        return this.folderWriter.exists(relativePath);
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
        this.folderWriter.setStreamSorter(streamSorter);
    }

    public void finish() throws IOException {
        if (this.folderWriter != null) {
            this.closeAllStream();
            this.folderWriter.toFileArchive(this.fileName);
            this.folderWriter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        IOException ioex = null;
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            Iterator iter = this.openStreams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.flush();
                }
                catch (IOException ex) {
                    ioex = ex;
                }
            }
        }
        if (ioex != null) {
            throw ioex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllStream() {
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            Iterator iter = this.openStreams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
            this.openStreams.clear();
        }
    }

    static {
        $assertionsDisabled = !FileArchiveWriter.class.desiredAssertionStatus();
    }
}

