/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import java.util.regex.Pattern;

public class BirtStr {
    private BirtStr() {
    }

    public static String left(String str, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (str == null) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        if (n >= str.length()) {
            return str;
        }
        return str.substring(0, n);
    }

    public static String left(String str) {
        return BirtStr.left(str, 1);
    }

    public static String right(String str, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (str == null) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        if (n >= str.length()) {
            return str;
        }
        return str.substring(str.length() - n, str.length());
    }

    public static String right(String str) {
        return BirtStr.right(str, 1);
    }

    public static String concat(String str1, String str2) {
        return str1 + str2;
    }

    public static String toUpper(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String toLower(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        String trimStr = str.trim();
        return trimStr.replaceAll("\\s+", " ");
    }

    public static String trimLeft(String str) {
        int st;
        if (str == null) {
            return null;
        }
        byte[] value = str.getBytes();
        for (st = 0; st < str.length() && value[st] <= 32; ++st) {
        }
        return st > 0 ? str.substring(st, str.length()) : str;
    }

    public static String trimRight(String str) {
        int end;
        if (str == null) {
            return null;
        }
        byte[] value = str.getBytes();
        for (end = str.length(); end < str.length() && value[str.length() - 1] <= 32; --end) {
        }
        return end < str.length() ? str.substring(0, end) : str;
    }

    public static int indexOf(String find_text, String str, int start) {
        if (start < 0) {
            throw new IllegalArgumentException();
        }
        if (find_text == null || str == null || str.indexOf(find_text) < 0) {
            return -1;
        }
        return str.indexOf(find_text, start);
    }

    public static int indexOf(String find_text, String str) {
        return BirtStr.indexOf(find_text, str, 0);
    }

    public static int search(String pattern, String str, int start) {
        if (start < 0) {
            throw new IllegalArgumentException();
        }
        if (pattern == null || str == null) {
            return -1;
        }
        String subStr = str.substring(start - 1);
        String newStr = pattern.replaceAll("\\Q?\\E", ".");
        String finalStr = newStr.replaceAll("\\Q*\\E", ".*");
        Pattern p = Pattern.compile(finalStr);
        String[] split = p.split(subStr);
        if (split.length == 1) {
            return -1;
        }
        if (split.length > 1) {
            return subStr.indexOf(split[0]) + split[0].length() + start - 1;
        }
        return -1;
    }

    public static int search(String pattern, String str) {
        return BirtStr.search(pattern, str, 1);
    }

    public static int charLength(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }
}

