/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.DefaultDOMHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.w3c.dom.Document;

public class XMLResourceImpl
extends ResourceImpl
implements XMLResource {
    protected Map idToEObjectMap;
    protected Map eObjectToIDMap;
    protected Map eObjectToExtensionMap;
    protected String encoding;
    protected boolean useZip;
    protected String publicId;
    protected String systemId;
    protected DOMHandler domHandler;
    protected static final Map DETACHED_EOBJECT_TO_ID_MAP = Collections.synchronizedMap(new WeakHashMap());

    public XMLResourceImpl() {
        this.init();
    }

    public XMLResourceImpl(URI uri) {
        super(uri);
        this.init();
    }

    protected void init() {
        this.encoding = "ASCII";
    }

    protected boolean useIDs() {
        return true;
    }

    protected boolean useIDAttributes() {
        return true;
    }

    protected boolean useUUIDs() {
        return false;
    }

    public Map getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
        }
        return this.defaultSaveOptions;
    }

    public Map getDefaultLoadOptions() {
        if (this.defaultLoadOptions == null) {
            this.defaultLoadOptions = new HashMap();
        }
        return this.defaultLoadOptions;
    }

    protected XMLHelper createXMLHelper() {
        return new XMLHelperImpl(this);
    }

    protected XMLLoad createXMLLoad() {
        return new XMLLoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new XMLSaveImpl(this.createXMLHelper());
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        XMLLoad xmlLoad = this.createXMLLoad();
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        xmlLoad.load(this, inputStream, options);
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        XMLSave xmlSave = this.createXMLSave();
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        xmlSave.save(this, outputStream, options);
    }

    public Document toDOM(Map options, Document doc, DOMHandler handler) {
        Document document;
        XMLSave xmlSave = this.createXMLSave();
        this.domHandler = handler;
        if (this.domHandler == null) {
            this.domHandler = new DefaultDOMHandlerImpl();
        }
        if ((document = doc) == null) {
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (this.defaultSaveOptions == null || this.defaultSaveOptions.isEmpty()) {
            return xmlSave.toDOM(this, document, this.domHandler, options);
        }
        if (options == null) {
            return xmlSave.toDOM(this, document, this.domHandler, this.defaultSaveOptions);
        }
        HashMap mergedOptions = new HashMap(this.defaultSaveOptions);
        mergedOptions.putAll(options);
        return xmlSave.toDOM(this, document, this.domHandler, mergedOptions);
    }

    public DOMHandler getDOMHandler() {
        return this.domHandler;
    }

    public boolean useZip() {
        return this.useZip;
    }

    public void setUseZip(boolean useZip) {
        this.useZip = useZip;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setDoctypeInfo(String publicId, String systemId) {
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map getIDToEObjectMap() {
        if (this.idToEObjectMap == null) {
            this.idToEObjectMap = new HashMap();
        }
        return this.idToEObjectMap;
    }

    public Map getEObjectToIDMap() {
        if (this.eObjectToIDMap == null) {
            this.eObjectToIDMap = new HashMap();
        }
        return this.eObjectToIDMap;
    }

    public Map getEObjectToExtensionMap() {
        if (this.eObjectToExtensionMap == null) {
            this.eObjectToExtensionMap = new HashMap();
        }
        return this.eObjectToExtensionMap;
    }

    public String getID(EObject eObject) {
        if (this.eObjectToIDMap == null) {
            return null;
        }
        return (String)this.eObjectToIDMap.get(eObject);
    }

    public void setID(EObject eObject, String id) {
        Object oldID;
        Object object = oldID = id != null ? this.getEObjectToIDMap().put(eObject, id) : this.getEObjectToIDMap().remove(eObject);
        if (oldID != null) {
            this.getIDToEObjectMap().remove(oldID);
        }
        if (id != null) {
            this.getIDToEObjectMap().put(id, eObject);
        }
    }

    public String getURIFragment(EObject eObject) {
        String id = this.getID(eObject);
        if (id != null) {
            return id;
        }
        return super.getURIFragment(eObject);
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = (EObject)this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        return this.useIDAttributes() ? super.getEObjectByID(id) : null;
    }

    protected boolean isPath(String uriFragment) {
        return uriFragment.startsWith("/");
    }

    protected boolean isAttachedDetachedHelperRequired() {
        return this.useIDs() || super.isAttachedDetachedHelperRequired();
    }

    protected void attachedHelper(EObject eObject) {
        super.attachedHelper(eObject);
        if (this.useIDs()) {
            String id = this.getID(eObject);
            if (this.useUUIDs() && id == null) {
                id = (String)DETACHED_EOBJECT_TO_ID_MAP.remove(eObject);
                if (id == null) {
                    id = EcoreUtil.generateUUID();
                }
                this.setID(eObject, id);
            } else if (id != null) {
                this.getIDToEObjectMap().put(id, eObject);
            }
        }
    }

    protected void detachedHelper(EObject eObject) {
        if (this.useIDs()) {
            if (this.useUUIDs()) {
                DETACHED_EOBJECT_TO_ID_MAP.put(eObject, this.getID(eObject));
            }
            if (this.idToEObjectMap != null && this.eObjectToIDMap != null) {
                this.setID(eObject, null);
            }
        }
        super.detachedHelper(eObject);
    }

    protected void doUnload() {
        super.doUnload();
        if (this.idToEObjectMap != null) {
            this.idToEObjectMap.clear();
        }
        if (this.eObjectToIDMap != null) {
            this.eObjectToIDMap.clear();
        }
        if (this.eObjectToExtensionMap != null) {
            this.eObjectToExtensionMap.clear();
        }
    }

    public String toKeyString() {
        StringBuffer result = new StringBuffer("Key type: ");
        result.append(this.getClass().toString());
        if (this.idToEObjectMap != null) {
            Object key;
            TreeMap tree = new TreeMap();
            Iterator<Object> i = this.idToEObjectMap.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                if (key == null) continue;
                tree.put(key.toString(), key);
            }
            i = tree.values().iterator();
            while (i.hasNext()) {
                key = i.next();
                Object value = this.idToEObjectMap.get(key);
                result.append("\r\n\t[Key=" + key + ", Value=" + value + "]");
            }
        }
        return result.toString();
    }
}

