/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Oval3DRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.render.MarkerRenderer;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Line
extends AxesRenderer {
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$Text3DRenderEvent;

    /*
     * Unable to fully structure code
     */
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        bRendering3D = this.isDimension3D();
        srh = null;
        srh3d = null;
        if (bRendering3D) {
            srh3d = (SeriesRenderingHints3D)isrh;
        } else {
            srh = (SeriesRenderingHints)isrh;
        }
        if (!bRendering3D && !srh.isCategoryScale() || bRendering3D && !srh3d.isXCategoryScale()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.xvalue.scale.lines", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        cwa = (ChartWithAxes)this.getModel();
        Line.logger.log(1, Messages.getString("info.render.series", new Object[]{this.getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        boClientArea = isrh.getClientAreaBounds(true);
        v0 = dSeriesThickness = bRendering3D != false ? 0.0 : srh.getSeriesThickness();
        if (cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
        }
        if (!(ls = (LineSeries)this.getSeries()).isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ls}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ls.isVisible()) {
            return;
        }
        cd = cwa.getDimension();
        sh = this.getRunTimeContext().getScriptHandler();
        dpha = isrh.getDataPoints();
        this.validateNullDatapoint(dpha);
        fX = 0.0;
        fY = 0.0;
        fZ = 0.0;
        fWidth = 0.0;
        fWidthZ = 0.0;
        fHeight = 0.0;
        lo = null;
        lo3d = null;
        v1 = bShowAsTape = cd.getValue() == 1 || cd.getValue() == 2;
        if (bShowAsTape) {
            bShowAsTape = this.validateShowAsTape();
        }
        ax = this.getAxis();
        ssl = null;
        if (!bRendering3D) {
            ssl = srh.getStackedSeriesLookup();
        }
        lia = ls.getLineAttributes();
        faX = new double[dpha.length];
        faY = new double[dpha.length];
        faZ = new double[dpha.length];
        sd = this.getSeriesDefinition();
        elPalette = sd.getSeriesPalette().getEntries();
        iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ls}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        m = null;
        if (ls.getMarkers().size() > 0) {
            m = (Marker)ls.getMarkers().get(iThisSeriesIndex % ls.getMarkers().size());
        }
        fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
        } else if (this.iSeriesIndex > 0) {
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get((this.iSeriesIndex - 1) % iPaletteSize)));
        }
        this.updateTranslucency(fPaletteEntry, (Series)ls);
        dTapeWidth = -1.0;
        dUnitSpacingZ = 0.0;
        for (i = 0; i < dpha.length; ++i) {
            if (bRendering3D) {
                lo3d = dpha[i].getLocation3D();
                if (dTapeWidth == -1.0) {
                    dUnitSpacing = cwa.isSetUnitSpacing() == false ? 50.0 : cwa.getUnitSpacing();
                    dTapeWidth = dpha[i].getSize2D().getHeight() * (100.0 - dUnitSpacing) / 100.0;
                    dUnitSpacingZ = dpha[i].getSize2D().getHeight() * dUnitSpacing / 200.0;
                }
            } else {
                lo = dpha[i].getLocation();
            }
            if (cwa.isTransposed()) {
                fHeight = dpha[i].getSize();
                fY = lo.getY() + fHeight / 2.0;
                lo.setY(fY);
                faY[i] = fY;
                if (ls.isStacked() || ax.isPercent()) {
                    au = ssl.getUnit((Series)ls, i);
                    v2 = dValue = Line.isNaN((Object)dpha[i].getOrthogonalValue()) != false ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                    if (ax.isPercent()) {
                        dValue = au.valuePercentage(dValue);
                    }
                    dEnd = 0.0;
                    if (dValue > 0.0) {
                        dEnd = au.getValueMax() + dValue;
                        au.setValueMax(dEnd);
                    } else if (dValue < 0.0) {
                        dEnd = au.getValueMin() + dValue;
                        au.setValueMin(dEnd);
                    }
                    dEnd = au.getLastValue() + dValue;
                    au.setLastValue(dEnd);
                    try {
                        faX[i] = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dEnd)));
                        if (!(faX[i] < srh.getPlotBaseLocation())) ** GOTO lbl107
                        faX[i] = srh.getPlotBaseLocation();
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                    }
                } else {
                    faX[i] = lo.getX();
                }
lbl107:
                // 3 sources

                dBaseLocation = srh.getPlotBaseLocation();
                if (ChartUtil.mathLT((double)faX[i], (double)boClientArea.getLeft())) {
                    if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft())) continue;
                    faX[i] = boClientArea.getLeft();
                } else if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft())) {
                    dBaseLocation = boClientArea.getLeft();
                }
                if (ChartUtil.mathGT((double)faX[i], (double)(boClientArea.getLeft() + boClientArea.getWidth()))) {
                    if (ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) continue;
                    faX[i] = boClientArea.getLeft() + boClientArea.getWidth();
                    continue;
                }
                if (!ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) continue;
                dBaseLocation = boClientArea.getLeft() + boClientArea.getWidth();
                continue;
            }
            if (bRendering3D) {
                fWidth = dpha[i].getSize2D().getWidth();
                fWidthZ = dpha[i].getSize2D().getHeight();
                fX = lo3d.getX() + fWidth / 2.0;
                fZ = lo3d.getZ() + fWidthZ - dUnitSpacingZ;
                lo3d.setX(fX);
                lo3d.setZ(fZ);
                faX[i] = fX;
                faZ[i] = fZ;
            } else {
                fWidth = dpha[i].getSize();
                fX = lo.getX() + fWidth / 2.0;
                lo.setX(fX);
                faX[i] = fX;
            }
            if (ls.isStacked() || ax.isPercent()) {
                if (bRendering3D) {
                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 15, "exception.no.stack.percent.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                }
                au = ssl.getUnit((Series)ls, i);
                v3 = dValue = Line.isNaN((Object)dpha[i].getOrthogonalValue()) != false ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                if (ax.isPercent()) {
                    dValue = au.valuePercentage(dValue);
                }
                dEnd = 0.0;
                if (dValue > 0.0) {
                    dEnd = au.getValueMax() + dValue;
                    au.setValueMax(dEnd);
                } else if (dValue < 0.0) {
                    dEnd = au.getValueMin() + dValue;
                    au.setValueMin(dEnd);
                }
                dEnd = au.getLastValue() + dValue;
                au.setLastValue(dEnd);
                try {
                    faY[i] = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dEnd)));
                    if (!(faY[i] > srh.getPlotBaseLocation())) ** GOTO lbl160
                    faY[i] = srh.getPlotBaseLocation();
                }
                catch (Exception ex) {
                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                }
            } else {
                faY[i] = bRendering3D != false ? lo3d.getY() : lo.getY();
            }
lbl160:
            // 3 sources

            if (bRendering3D) {
                plotBaseLocation = srh3d.getPlotBaseLocation();
                if (faY[i] < plotBaseLocation) {
                    faY[i] = plotBaseLocation;
                }
                if (!(faY[i] > plotBaseLocation + srh3d.getPlotHeight())) continue;
                faY[i] = plotBaseLocation + srh3d.getPlotHeight();
                continue;
            }
            dBaseLocation = srh.getPlotBaseLocation();
            if (faY[i] < boClientArea.getTop()) {
                if (dBaseLocation < boClientArea.getTop()) continue;
                faY[i] = boClientArea.getTop();
            } else if (dBaseLocation < boClientArea.getTop()) {
                dBaseLocation = boClientArea.getTop();
            }
            if (faY[i] > boClientArea.getTop() + boClientArea.getHeight()) {
                if (dBaseLocation > boClientArea.getTop() + boClientArea.getHeight()) continue;
                faY[i] = boClientArea.getTop() + boClientArea.getHeight();
                continue;
            }
            if (!(dBaseLocation > boClientArea.getTop() + boClientArea.getHeight())) continue;
            dBaseLocation = boClientArea.getTop() + boClientArea.getHeight();
        }
        if (ls.isSetCurve() && ls.isCurve()) {
            this.renderAsCurve(ipr, ls.getLineAttributes(), (ISeriesRenderingHints)(bRendering3D != false ? srh3d : srh), (Location[])(bRendering3D != false ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dTapeWidth, fPaletteEntry, ls.isSetPaletteLineColor() != false && ls.isPaletteLineColor() != false);
            this.renderShadowAsCurve(ipr, lia, (ISeriesRenderingHints)(bRendering3D != false ? srh3d : srh), (Location[])(bRendering3D != false ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dTapeWidth);
            if (m != null && m.isSetType()) {
                for (i = 0; i < dpha.length; ++i) {
                    if (bPaletteByCategory) {
                        fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize)));
                        this.updateTranslucency(fPaletteEntry, (Series)ls);
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                    this.renderMarker(ls, ipr, (Location)(bRendering3D != false ? Location3DImpl.create((double)faX[i], (double)faY[i], (double)faZ[i]) : LocationImpl.create((double)faX[i], (double)faY[i])), fPaletteEntry, dpha[i], -1, true);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                }
            }
        } else {
            if (!lia.isSetVisible()) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.visibility.line.unset", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            this.renderShadow(ipr, p, lia, (Location[])(bRendering3D != false ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dpha);
            this.renderDataPoints(ipr, p, (ISeriesRenderingHints)(bRendering3D != false ? srh3d : srh), dpha, lia, (Location[])(bRendering3D != false ? Location3DImpl.create((double[])faX, (double[])faY, (double[])faZ) : LocationImpl.create((double[])faX, (double[])faY)), bShowAsTape, dTapeWidth, fPaletteEntry, ls.isSetPaletteLineColor() != false && ls.isPaletteLineColor() != false);
            if (m != null && m.isSetType()) {
                for (i = 0; i < dpha.length; ++i) {
                    if (bPaletteByCategory) {
                        fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize)));
                        this.updateTranslucency(fPaletteEntry, (Series)ls);
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                    this.renderMarker(ls, ipr, (Location)(bRendering3D != false ? Location3DImpl.create((double)faX[i], (double)faY[i], (double)faZ[i]) : LocationImpl.create((double)faX[i], (double)faY[i])), fPaletteEntry, dpha[i], -1, true);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                }
            }
        }
        laDataPoint = null;
        pDataPoint = null;
        loDataPoint = null;
        loDataPoint3d = null;
        try {
            if (bRendering3D) {
                laDataPoint = srh3d.getLabelAttributes((Series)ls);
                if (laDataPoint.isVisible()) {
                    pDataPoint = srh3d.getLabelPosition((Series)ls);
                    loDataPoint3d = Location3DImpl.create((double)0.0, (double)0.0, (double)0.0);
                }
            } else {
                laDataPoint = srh.getLabelAttributes((Series)ls);
                if (laDataPoint.isVisible()) {
                    pDataPoint = srh.getLabelPosition((Series)ls);
                    loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
                }
            }
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        if (laDataPoint.isVisible()) {
            dSize = m == null ? 0.0 : (double)m.getSize();
            for (i = 0; i < dpha.length; ++i) {
                if (Line.isNaN((Object)dpha[i].getOrthogonalValue())) continue;
                laDataPoint.getCaption().setValue(dpha[i].getDisplayValue());
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
                if (laDataPoint.isVisible()) {
                    if (bRendering3D) {
                        switch (pDataPoint.getValue()) {
                            case 0: {
                                loDataPoint3d.set(faX[i], faY[i] + dSize + (double)p.getVerticalSpacing(), faZ[i] + 1.0);
                                break;
                            }
                            case 1: {
                                loDataPoint3d.set(faX[i], faY[i] - dSize - (double)p.getVerticalSpacing(), faZ[i] + 1.0);
                                break;
                            }
                            case 2: {
                                loDataPoint3d.set(faX[i] - dSize - (double)p.getHorizontalSpacing(), faY[i], faZ[i] + 1.0);
                                break;
                            }
                            case 3: {
                                loDataPoint3d.set(faX[i] + dSize + (double)p.getHorizontalSpacing(), faY[i], faZ[i] + 1.0);
                                break;
                            }
                            default: {
                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.line", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                            }
                        }
                        tre3d = (Text3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)ls, (DataPointHints)dpha[i]), Line.class$org$eclipse$birt$chart$event$Text3DRenderEvent == null ? Line.class$("org.eclipse.birt.chart.event.Text3DRenderEvent") : Line.class$org$eclipse$birt$chart$event$Text3DRenderEvent);
                        tre3d.setAction(2);
                        tre3d.setLabel(laDataPoint);
                        tre3d.setTextPosition(Methods.getLabelPosition((Position)pDataPoint));
                        tre3d.setLocation3D(loDataPoint3d);
                        this.getDeferredCache().addLabel((TextRenderEvent)tre3d);
                    } else {
                        switch (pDataPoint.getValue()) {
                            case 0: {
                                loDataPoint.set(faX[i], faY[i] - dSize - (double)p.getVerticalSpacing());
                                break;
                            }
                            case 1: {
                                loDataPoint.set(faX[i], faY[i] + dSize + (double)p.getVerticalSpacing());
                                break;
                            }
                            case 2: {
                                loDataPoint.set(faX[i] - dSize - (double)p.getHorizontalSpacing(), faY[i]);
                                break;
                            }
                            case 3: {
                                loDataPoint.set(faX[i] + dSize + (double)p.getHorizontalSpacing(), faY[i]);
                                break;
                            }
                            default: {
                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.line", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                            }
                        }
                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)ls, (DataPointHints)dpha[i]), 2, laDataPoint, pDataPoint, loDataPoint, null);
                    }
                }
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
            }
        }
        if (!bRendering3D && this.getSeries().getCurveFitting() != null) {
            larray = new Location[faX.length];
            for (i = 0; i < larray.length; ++i) {
                larray[i] = LocationImpl.create((double)faX[i], (double)faY[i]);
            }
            larray = Line.filterNull((Location[])larray);
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), bShowAsTape, true);
        }
    }

    protected boolean validateShowAsTape() {
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        LineSeries ls = (LineSeries)this.getSeries();
        if (!ls.isStacked()) {
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        } else {
            Axis[] axaOrthogonal = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            if (axaOrthogonal.length > 1) {
                return false;
            }
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        }
        return true;
    }

    protected final void renderMarker(Object oParent, IPrimitiveRenderer ipr, Location lo, Fill fPaletteEntry, DataPointHints dph, int markerSize, boolean bDeferred) throws ChartException {
        EList elTriggers;
        int iThisSeriesIndex;
        if (dph != null && Line.isNaN((Object)dph.getOrthogonalValue())) {
            return;
        }
        LineSeries ls = (LineSeries)this.getSeries();
        SeriesDefinition sd = this.getSeriesDefinition();
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        if (ls.getMarkers().size() > 0) {
            m = (Marker)ls.getMarkers().get(iThisSeriesIndex % ls.getMarkers().size());
        }
        StructureSource oSource = oParent instanceof Legend ? StructureSource.createLegend((Legend)((Legend)oParent)) : WrappedStructureSource.createSeriesDataPoint((Series)ls, (DataPointHints)dph);
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        Location panningOffset = this.getPanningOffset();
        PrimitiveRenderEvent preCopy = null;
        if (m == null || m != null && (!m.isSetVisible() || !m.isVisible())) {
            Oval3DRenderEvent ore;
            int iSize = 5;
            if (m != null) {
                iSize = m.getSize();
            }
            if (lo instanceof Location3D) {
                ore = (Oval3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)oSource, Oval3DRenderEvent.class);
                Location3D lo3d = (Location3D)lo;
                ore.setLocation3D(new Location3D[]{Location3DImpl.create((double)(lo3d.getX() - (double)iSize), (double)(lo3d.getY() + (double)iSize), (double)lo3d.getZ()), Location3DImpl.create((double)(lo3d.getX() - (double)iSize), (double)(lo3d.getY() - (double)iSize), (double)lo3d.getZ()), Location3DImpl.create((double)(lo3d.getX() + (double)iSize), (double)(lo3d.getY() - (double)iSize), (double)lo3d.getZ()), Location3DImpl.create((double)(lo3d.getX() + (double)iSize), (double)(lo3d.getY() + (double)iSize), (double)lo3d.getZ())});
                preCopy = ore.copy();
            } else {
                ore = (OvalRenderEvent)((EventObjectCache)ipr).getEventObject((Object)oSource, OvalRenderEvent.class);
                ore.setBounds(BoundsImpl.create((double)(lo.getX() - (double)iSize), (double)(lo.getY() - (double)iSize), (double)(iSize * 2), (double)(iSize * 2)));
                preCopy = ore.copy();
            }
        } else if (m.isSetVisible() && m.isVisible()) {
            MarkerRenderer mr = new MarkerRenderer(this.getDevice(), (Object)oSource, lo, ls.getLineAttributes(), fPaletteEntry, m, markerSize, this.getDeferredCache(), bDeferred, bTransposed);
            mr.draw(ipr);
            preCopy = mr.getRenderArea();
        }
        if (this.isInteractivityEnabled() && dph != null && (!(lo instanceof Location3D) || lo instanceof Location3D && this.get3DEngine().processEvent(preCopy, panningOffset.getX(), panningOffset.getY()) != null) && !(elTriggers = ls.getTriggers()).isEmpty()) {
            StructureSource iSource = oParent instanceof Legend ? StructureSource.createSeries((Series)ls) : WrappedStructureSource.createSeriesDataPoint((Series)ls, (DataPointHints)dph);
            InteractionEvent iev = (InteractionEvent)((EventObjectCache)ipr).getEventObject((Object)iSource, InteractionEvent.class);
            for (int t = 0; t < elTriggers.size(); ++t) {
                Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
                this.processTrigger(tg, iSource);
                iev.addTrigger(tg);
            }
            iev.setHotSpot(preCopy);
            ipr.enableInteraction(iev);
        }
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        int iThisSeriesIndex;
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        LineSeries ls = (LineSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = ColorDefinitionImpl.RED();
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes liaMarker = ls.getLineAttributes();
        if (!liaMarker.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.marker.linestyle.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (liaMarker.isVisible()) {
            LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), LineRenderEvent.class);
            if (fPaletteEntry instanceof ColorDefinition && ls.isSetPaletteLineColor() && ls.isPaletteLineColor()) {
                liaMarker = LineAttributesImpl.copyInstance((LineAttributes)liaMarker);
                liaMarker.setColor(ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)fPaletteEntry)));
            }
            lre.setLineAttributes(liaMarker);
            lre.setStart(LocationImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            ipr.drawLine(lre);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        if (ls.getMarkers().size() > 0) {
            m = (Marker)ls.getMarkers().get(iThisSeriesIndex % ls.getMarkers().size());
        }
        if (m != null && m.isVisible()) {
            this.renderMarker(lg, ipr, LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)(bo.getTop() + bo.getHeight() / 2.0)), fPaletteEntry, null, -1, false);
        }
    }

    protected void renderAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints srh, Location[] loa, boolean bShowAsTape, double tapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        CurveRenderer cr = new CurveRenderer((ChartWithAxes)this.getModel(), (BaseRenderer)this, lia, loa, bShowAsTape, tapeWidth, true, !this.isDimension3D(), paletteEntry, usePaletteLineColor, ((LineSeries)this.getSeries()).isConnectMissingValue());
        cr.draw(ipr);
    }

    protected void renderShadowAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints srh, Location[] loa, boolean bShowAsTape, double tapeWidth) throws ChartException {
        ColorDefinition cLineShadow = ((LineSeries)this.getSeries()).getShadowColor();
        if (!bShowAsTape && cLineShadow != null && cLineShadow.getTransparency() != ColorDefinitionImpl.TRANSPARENT().getTransparency() && lia.isSetVisible() && lia.isVisible()) {
            Location positionDelta = ((ChartWithAxes)this.getModel()).isTransposed() ? LocationImpl.create((double)-3.0, (double)0.0) : LocationImpl.create((double)0.0, (double)3.0);
            double[] shX = new double[loa.length];
            double[] shY = new double[loa.length];
            for (int i = 0; i < loa.length; ++i) {
                shX[i] = loa[i].getX() + positionDelta.getX();
                shY[i] = loa[i].getY() + positionDelta.getY();
            }
            LineAttributes liaShadow = LineAttributesImpl.copyInstance((LineAttributes)lia);
            liaShadow.setColor(cLineShadow);
            this.renderAsCurve(ipr, liaShadow, srh, LocationImpl.create((double[])shX, (double[])shY), bShowAsTape, tapeWidth, (Fill)liaShadow.getColor(), false);
        }
    }

    protected void renderDataPoints(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints srh, DataPointHints[] dpha, LineAttributes lia, Location[] loa, boolean bShowAsTape, double dTapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        Line3DRenderEvent lre3d;
        PolygonRenderEvent pre;
        if (!lia.isSetVisible() || !lia.isVisible()) {
            return;
        }
        Location[] loaPlane = null;
        Location[] loaLine = null;
        Location3D[] loa3d = null;
        Location3D[] loaPlane3d = null;
        Location3D[] loaLine3d = null;
        Series ls = this.getSeries();
        boolean bRendering3D = this.isDimension3D();
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ls), LineRenderEvent.class);
        PolygonRenderEvent polygonRenderEvent = bShowAsTape ? (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ls), PolygonRenderEvent.class) : (pre = null);
        Line3DRenderEvent line3DRenderEvent = bRendering3D ? (Line3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ls), Line3DRenderEvent.class) : (lre3d = null);
        Polygon3DRenderEvent pre3d = bShowAsTape && bRendering3D ? (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ls), Polygon3DRenderEvent.class) : null;
        DeferredCache dc = this.getDeferredCache();
        if (paletteEntry instanceof ColorDefinition && usePaletteLineColor) {
            lia = LineAttributesImpl.copyInstance((LineAttributes)lia);
            lia.setColor(ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)paletteEntry)));
        }
        if (!bRendering3D) {
            dTapeWidth = ((SeriesRenderingHints)srh).getSeriesThickness();
        }
        List<double[]> points = new ArrayList();
        if (bRendering3D) {
            loa3d = (Location3D[])loa;
            pre3d.setDoubleSided(true);
        }
        if (dpha.length > 0) {
            for (int i = 0; i < dpha.length; ++i) {
                if (Line.isNaN((Object)dpha[i].getOrthogonalValue())) continue;
                if (bRendering3D) {
                    points.add(new double[]{loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ()});
                } else {
                    points.add(new double[]{loa[i].getX(), loa[i].getY()});
                }
                if (!((LineSeries)ls).isConnectMissingValue() && (i == 0 || i > 0 && Line.isNaN((Object)dpha[i - 1].getOrthogonalValue()))) {
                    if (i != dpha.length - 1 && !Line.isNaN((Object)dpha[i + 1].getOrthogonalValue())) continue;
                    double iSize = (double)lia.getThickness() * 2.0;
                    if (bRendering3D) {
                        Line3DRenderEvent lre3dValue = (Line3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha[i]), class$org$eclipse$birt$chart$event$Line3DRenderEvent == null ? Line.class$("org.eclipse.birt.chart.event.Line3DRenderEvent") : class$org$eclipse$birt$chart$event$Line3DRenderEvent);
                        Location3D[] loa3dValue = new Location3D[]{Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)loa3d[i].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)(loa3d[i].getZ() - dTapeWidth))};
                        lre3dValue.setStart3D(loa3dValue[0]);
                        lre3dValue.setEnd3D(loa3dValue[1]);
                        lre3dValue.setLineAttributes(lia);
                        dc.addLine((LineRenderEvent)lre3dValue);
                        continue;
                    }
                    OvalRenderEvent ore = (OvalRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha[i]), class$org$eclipse$birt$chart$event$OvalRenderEvent == null ? Line.class$("org.eclipse.birt.chart.event.OvalRenderEvent") : class$org$eclipse$birt$chart$event$OvalRenderEvent);
                    ore.setBounds(BoundsImpl.create((double)(loa[i].getX() - iSize / 2.0), (double)(loa[i].getY() - iSize / 2.0), (double)iSize, (double)iSize));
                    ore.setOutline(lia);
                    ipr.drawOval(ore);
                    continue;
                }
                int pindex = this.getPreviousNonNullIndex(i, dpha);
                if (pindex == -1) continue;
                if (bRendering3D) {
                    if (loaLine3d == null) {
                        loaLine3d = new Location3D[]{Location3DImpl.create((double)loa3d[pindex].getX(), (double)loa3d[pindex].getY(), (double)loa3d[pindex].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)loa3d[i].getZ())};
                        lre3d.setStart3D(loaLine3d[0]);
                        lre3d.setEnd3D(loaLine3d[1]);
                        lre3d.setLineAttributes(lia);
                    } else {
                        loaLine3d[0].set(loa3d[pindex].getX(), loa3d[pindex].getY(), loa3d[pindex].getZ());
                        loaLine3d[1].set(loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ());
                        lre3d.setStart3D(loaLine3d[0]);
                        lre3d.setEnd3D(loaLine3d[1]);
                    }
                } else if (loaLine == null) {
                    loaLine = new Location[]{LocationImpl.create((double)loa[pindex].getX(), (double)loa[pindex].getY()), LocationImpl.create((double)loa[i].getX(), (double)loa[i].getY())};
                    lre.setStart(loaLine[0]);
                    lre.setEnd(loaLine[1]);
                    lre.setLineAttributes(lia);
                } else {
                    loaLine[0].set(loa[pindex].getX(), loa[pindex].getY());
                    loaLine[1].set(loa[i].getX(), loa[i].getY());
                }
                if (bShowAsTape) {
                    if (bRendering3D) {
                        if (loaPlane3d == null) {
                            loaPlane3d = new Location3D[]{Location3DImpl.create((double)loa3d[pindex].getX(), (double)loa3d[pindex].getY(), (double)loa3d[pindex].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)loa3d[i].getZ()), Location3DImpl.create((double)loa3d[i].getX(), (double)loa3d[i].getY(), (double)(loa3d[i].getZ() - dTapeWidth)), Location3DImpl.create((double)loa3d[pindex].getX(), (double)loa3d[pindex].getY(), (double)(loa3d[pindex].getZ() - dTapeWidth))};
                            pre3d.setOutline(null);
                            pre3d.setPoints3D(loaPlane3d);
                            pre3d.setBackground((Fill)lia.getColor().brighter());
                        } else {
                            loaPlane3d[0].set(loa3d[pindex].getX(), loa3d[pindex].getY(), loa3d[pindex].getZ());
                            loaPlane3d[1].set(loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ());
                            loaPlane3d[2].set(loa3d[i].getX(), loa3d[i].getY(), loa3d[i].getZ() - dTapeWidth);
                            loaPlane3d[3].set(loa3d[pindex].getX(), loa3d[pindex].getY(), loa3d[pindex].getZ() - dTapeWidth);
                            pre3d.setPoints3D(loaPlane3d);
                        }
                        dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
                    } else {
                        if (loaPlane == null) {
                            loaPlane = new Location[]{LocationImpl.create((double)loa[pindex].getX(), (double)loa[pindex].getY()), LocationImpl.create((double)loa[i].getX(), (double)loa[i].getY()), LocationImpl.create((double)(loa[i].getX() + dTapeWidth), (double)(loa[i].getY() - dTapeWidth)), LocationImpl.create((double)(loa[pindex].getX() + dTapeWidth), (double)(loa[pindex].getY() - dTapeWidth))};
                            pre.setOutline(null);
                            pre.setPoints(loaPlane);
                            pre.setBackground((Fill)lia.getColor().brighter());
                        } else {
                            loaPlane[0].set(loa[pindex].getX(), loa[pindex].getY());
                            loaPlane[1].set(loa[i].getX(), loa[i].getY());
                            loaPlane[2].set(loa[i].getX() + dTapeWidth, loa[i].getY() - dTapeWidth);
                            loaPlane[3].set(loa[pindex].getX() + dTapeWidth, loa[pindex].getY() - dTapeWidth);
                        }
                        dc.addPlane((PrimitiveRenderEvent)pre, 2);
                    }
                }
                if (bRendering3D) {
                    dc.addLine((LineRenderEvent)lre3d);
                    continue;
                }
                dc.addLine(lre);
            }
            points = Line.filterNull(points);
            if (this.isLastRuntimeSeriesInAxis()) {
                this.getRunTimeContext().putState((Object)AreaSeries.class, null);
            } else {
                this.getRunTimeContext().putState((Object)AreaSeries.class, points);
            }
        }
    }

    protected void renderShadow(IPrimitiveRenderer ipr, Plot p, LineAttributes lia, Location[] loa, boolean bShowAsTape, DataPointHints[] dpha) throws ChartException {
        ColorDefinition cLineShadow = ((LineSeries)this.getSeries()).getShadowColor();
        if (!bShowAsTape && cLineShadow != null && cLineShadow.getTransparency() != ColorDefinitionImpl.TRANSPARENT().getTransparency() && lia.isSetVisible() && lia.isVisible()) {
            Location[] loaShadow = null;
            Location positionDelta = ((ChartWithAxes)this.getModel()).isTransposed() ? LocationImpl.create((double)-3.0, (double)0.0) : LocationImpl.create((double)0.0, (double)3.0);
            LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)this.getSeries()), LineRenderEvent.class);
            DeferredCache dc = this.getDeferredCache();
            for (int i = 0; i < loa.length; ++i) {
                if (this.isNaN(loa[i])) continue;
                if (!((LineSeries)this.getSeries()).isConnectMissingValue() && (i == 0 || i > 0 && this.isNaN(loa[i - 1]))) {
                    if (i != loa.length - 1 && !this.isNaN(loa[i + 1])) continue;
                    double iSize = lia.getThickness();
                    OvalRenderEvent ore = (OvalRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha[i]), class$org$eclipse$birt$chart$event$OvalRenderEvent == null ? Line.class$("org.eclipse.birt.chart.event.OvalRenderEvent") : class$org$eclipse$birt$chart$event$OvalRenderEvent);
                    ore.setBounds(BoundsImpl.create((double)loa[i].getX(), (double)(loa[i].getY() + 3.0), (double)iSize, (double)iSize));
                    LineAttributes liaShadow = LineAttributesImpl.copyInstance((LineAttributes)lia);
                    liaShadow.setColor(cLineShadow);
                    ore.setOutline(liaShadow);
                    ore.setBackground((Fill)liaShadow.getColor());
                    ipr.drawOval(ore);
                    ipr.fillOval(ore);
                    continue;
                }
                int pindex = this.getPreviousNonNullIndex(i, loa);
                if (pindex == -1) continue;
                if (loaShadow == null) {
                    loaShadow = new Location[]{LocationImpl.create((double)(loa[pindex].getX() + positionDelta.getX()), (double)(loa[pindex].getY() + positionDelta.getY())), LocationImpl.create((double)(loa[i].getX() + positionDelta.getX()), (double)(loa[i].getY() + positionDelta.getY()))};
                } else {
                    loaShadow[0].set(loa[pindex].getX() + positionDelta.getX(), loa[pindex].getY() + positionDelta.getY());
                    loaShadow[1].set(loa[i].getX() + positionDelta.getX(), loa[i].getY() + positionDelta.getY());
                }
                lre.setStart(loaShadow[0]);
                lre.setEnd(loaShadow[1]);
                LineAttributes liaShadow = LineAttributesImpl.copyInstance((LineAttributes)lia);
                liaShadow.setColor(cLineShadow);
                lre.setLineAttributes(liaShadow);
                dc.addLine(lre);
            }
        }
    }

    protected int getPreviousNonNullIndex(int currentIndex, DataPointHints[] dpha) {
        for (int i = currentIndex - 1; i >= 0; --i) {
            if (dpha[i].getOrthogonalValue() == null) continue;
            return i;
        }
        return -1;
    }

    protected int getPreviousNonNullIndex(int currentIndex, Location[] loa) {
        for (int i = currentIndex - 1; i >= 0; --i) {
            if (Double.isNaN(loa[i].getX()) || Double.isNaN(loa[i].getY())) continue;
            return i;
        }
        return -1;
    }

    protected boolean isNaN(Location lo) {
        return lo == null || Double.isNaN(lo.getX()) || Double.isNaN(lo.getY());
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }
}

