/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.RenderOptionBase;

public class ReportRunner {
    protected static Logger logger;
    protected String[] args;
    protected String source;
    protected String targetFile = null;
    protected String mode = "RunAndRender";
    protected String locale = "en";
    protected String format = "html";
    protected String htmlType = "HTML";
    protected String encoding = "utf-8";
    protected HashMap params = new HashMap();
    protected long pageNumber = -1L;
    private IReportEngine engine;
    CommandLine results;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportRunner(String[] args) {
        this.args = (String[])args.clone();
    }

    public static void main(String[] args) {
        int result = new ReportRunner(args).execute();
        System.exit(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        if (this.args.length == 0) {
            this.printUsage();
            return 0;
        }
        try {
            if (this.engine == null) {
                EngineConfig config = new EngineConfig();
                Platform.startup((PlatformConfig)config);
                IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
                this.engine = factory.createReportEngine(config);
                this.engine.changeLogLevel(Level.WARNING);
            }
            this.parseOptions();
            if ("Run".equalsIgnoreCase(this.mode)) {
                int config = this.runReport();
                return config;
            }
            if ("Render".equalsIgnoreCase(this.mode)) {
                int config = this.renderReport();
                return config;
            }
            int config = this.runAndRenderReport();
            return config;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "exception in parsing the paramters", ex);
            int n = -1;
            return n;
        }
        finally {
            Platform.shutdown();
        }
    }

    protected int runAndRenderReport() {
        try {
            RenderOptionBase options;
            IReportRunnable runnable = this.engine.openReportDesign(this.source);
            HashMap inputValues = this.evaluateParameterValues(runnable);
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            task.setParameterValues(inputValues);
            if (this.format.equalsIgnoreCase("html")) {
                options = new HTMLRenderOption();
                if ("ReportletNoCSS".equals(this.htmlType)) {
                    ((HTMLRenderOption)options).setEmbeddable(true);
                }
                ((HTMLRenderOption)options).setHtmlPagination(true);
            } else {
                options = new RenderOptionBase();
            }
            options.setOutputFormat(this.format);
            options.setOutputFileName(this.targetFile);
            options.getOutputSetting().put("url-encoding", this.encoding);
            task.setRenderOption(options);
            if (this.format.equalsIgnoreCase("html")) {
                HTMLRenderContext renderContext = new HTMLRenderContext();
                renderContext.setImageDirectory("image");
                HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
                appContext.put("HTML_RENDER_CONTEXT", renderContext);
                task.setAppContext(appContext);
            }
            task.setLocale(this.getLocale(this.locale));
            task.run();
            return 0;
        }
        catch (EngineException e) {
            logger.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
            return -1;
        }
    }

    protected int runReport() {
        try {
            IReportRunnable runnable = this.engine.openReportDesign(this.source);
            IRunTask task = this.engine.createRunTask(runnable);
            HashMap inputValues = this.evaluateParameterValues(runnable);
            task.setParameterValues(inputValues);
            task.setAppContext(new HashMap());
            task.run(this.targetFile);
            task.close();
            return 0;
        }
        catch (EngineException e) {
            logger.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
            return -1;
        }
    }

    protected int renderReport() {
        try {
            RenderOptionBase options;
            IReportDocument document = this.engine.openReportDocument(this.source);
            IRenderTask task = this.engine.createRenderTask(document);
            if (this.format.equalsIgnoreCase("html")) {
                options = new HTMLRenderOption();
                if ("ReportletNoCSS".equals(this.htmlType)) {
                    ((HTMLRenderOption)options).setEmbeddable(true);
                }
            } else {
                options = new RenderOptionBase();
            }
            options.setOutputFormat(this.format);
            options.getOutputSetting().put("url-encoding", this.encoding);
            task.setRenderOption(options);
            if (this.format.equalsIgnoreCase("html")) {
                HTMLRenderContext renderContext = new HTMLRenderContext();
                renderContext.setImageDirectory("image");
                HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
                appContext.put("HTML_RENDER_CONTEXT", renderContext);
                task.setAppContext(appContext);
            }
            task.setLocale(this.getLocale(this.locale));
            if (this.pageNumber <= 0L) {
                int extPos = this.targetFile.lastIndexOf(46);
                if (!$assertionsDisabled && extPos == -1) {
                    throw new AssertionError();
                }
                String pathName = this.targetFile.substring(0, extPos);
                String extName = this.targetFile.substring(extPos);
                for (long i = 1L; i <= document.getPageCount(); ++i) {
                    String fileName = pathName + '_' + i + extName;
                    options.setOutputFileName(fileName);
                    task.render(i);
                }
            } else {
                options.setOutputFileName(this.targetFile);
                task.render(this.pageNumber);
            }
            task.close();
            return 0;
        }
        catch (EngineException e) {
            logger.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
            return -1;
        }
    }

    protected void printUsage() {
        System.out.println("org.eclipse.birt.report.engine.impl.ReportRunner");
        System.out.println("");
        System.out.println("--mode/-m [ run | render | runrender] the default is runrender");
        System.out.println(" for runrender mode:");
        System.out.println("\t we should add it in the end<design file>");
        System.out.println("\t --format/-f [ HTML | PDF ]");
        System.out.println("\t --output/-o <target file>");
        System.out.println("\t --htmlType/-t < HTML | ReportletNoCSS >");
        System.out.println("\t --locale /-l<locale>");
        System.out.println("\t --parameter/-p <parameterName=parameterValue>");
        System.out.println("\t --file/-F <parameter file>");
        System.out.println("\t --encoding/-e <target encoding>");
        System.out.println("\nLocale: default is english\n");
        System.out.println("\nparameters in command line will overide parameters in parameter file");
        System.out.println("\nparameter name can't include characters such as ' ', '=', ':' ");
        System.out.println("For RUN mode:");
        System.out.println("\t we should add it in the end<design file>");
        System.out.println("\t --output/-o <target file>");
        System.out.println("\t --locale /-l<locale>");
        System.out.println("\t --parameter/-p <parameterName=parameterValue>");
        System.out.println("\t --file/-F <parameter file>");
        System.out.println("\nLocale: default is english\n");
        System.out.println("\nparameters in command line will overide parameters in parameter file");
        System.out.println("\nparameter name can't include characters such as ' ', '=', ':' ");
        System.out.println("For RENDER mode:");
        System.out.println("\t we should add it in the end<design file>");
        System.out.println("\t --output/-o <target file>");
        System.out.println("\\t --page/-p <pageNumber>");
        System.out.println("\t --locale /-l<locale>");
        System.out.println("\nLocale: default is english\n");
    }

    private Locale getLocale(String locale) {
        int index = locale.indexOf(95);
        if (index != -1) {
            String language = locale.substring(0, index);
            String country = locale.substring(index + 1);
            return new Locale(language, country);
        }
        return new Locale(locale);
    }

    protected void parseRunOptions() throws Exception {
        if (this.results.hasOption('o')) {
            this.targetFile = this.results.getOptionValue('o');
        }
        this.parseParameterOptions();
    }

    protected void parseRenderOptions() throws Exception {
        if (!$assertionsDisabled && !this.mode.equals("Run")) {
            throw new AssertionError();
        }
        if (this.results.hasOption('f')) {
            this.format = this.results.getOptionValue('f');
        }
        if (this.results.hasOption('t')) {
            this.htmlType = this.results.getOptionValue('t');
        }
        if (this.results.hasOption('o')) {
            this.targetFile = this.results.getOptionValue('o');
        }
        if (this.results.hasOption('l')) {
            this.locale = this.results.getOptionValue('l');
        }
        if (this.results.hasOption('e')) {
            this.encoding = this.results.getOptionValue('e');
        }
        if (this.results.hasOption('p')) {
            this.pageNumber = Long.parseLong(this.results.getOptionValue('p'));
        }
        this.parseParameterOptions();
    }

    protected void parseRunAndRenderOptions() throws Exception {
        if (!$assertionsDisabled && !this.mode.equals("RunAndRender")) {
            throw new AssertionError();
        }
        if (this.results.hasOption('f')) {
            this.format = this.results.getOptionValue('f');
        }
        if (this.results.hasOption('t')) {
            this.htmlType = this.results.getOptionValue('t');
        }
        if (this.results.hasOption('o')) {
            this.targetFile = this.results.getOptionValue('o');
        }
        if (this.results.hasOption('l')) {
            this.locale = this.results.getOptionValue('l');
        }
        if (this.results.hasOption('e')) {
            this.encoding = this.results.getOptionValue('e');
        }
        this.parseParameterOptions();
    }

    protected void parseOptions() {
        this.source = this.args[this.args.length - 1];
        this.args[this.args.length - 1] = "";
        try {
            Options option = new Options();
            option.addOption("m", "mode", true, "RunAndRender");
            option.addOption("o", "output", true, "");
            option.addOption("f", "format", true, "html");
            option.addOption("t", "htmlType", true, "");
            option.addOption("l", "locale", true, "");
            option.addOption("e", "encoding", true, "");
            option.addOption("p", "parameter", true, "");
            option.addOption("p", "page", true, "");
            option.addOption("F", "file", true, "parameter file");
            this.results = new BasicParser().parse(option, this.args, true);
            if (this.results.hasOption('m')) {
                this.mode = this.results.getOptionValue('m');
            }
            if ("Run".equalsIgnoreCase(this.mode)) {
                this.parseRunOptions();
            } else if ("Render".equalsIgnoreCase(this.mode)) {
                this.parseRenderOptions();
            } else {
                this.parseRunAndRenderOptions();
            }
            this.checkTargetFileName();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.printUsage();
        }
    }

    protected void readParamString(String param, HashMap params) {
        if (param == null || param.length() < 2) {
            return;
        }
        int index = param.indexOf("=");
        if (index < 1) {
            return;
        }
        String name = param.substring(0, index).trim();
        String value = param.substring(index + 1).trim();
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
            value = value.substring(1, value.length() - 1);
        }
        params.put(name, value);
    }

    protected void parseParameterOptions() {
        String[] stringParams;
        if (this.results.hasOption('F')) {
            String fileName = this.results.getOptionValue('F');
            this.readParamFile(fileName, this.params);
        }
        if (this.results.hasOption('p') && (stringParams = this.results.getOptionValues('p')) != null) {
            for (int i = 0; i < stringParams.length; ++i) {
                this.readParamString(stringParams[i], this.params);
            }
        }
    }

    protected void readParamFile(String fileName, HashMap params) {
        File file = new File(fileName);
        Properties ps = new Properties();
        try {
            ps.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "file: " + file.getAbsolutePath() + " not exists!");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Can't open file: " + file.getAbsolutePath());
        }
        params.putAll(ps);
    }

    private HashMap evaluateParameterValues(IReportRunnable runnable) {
        HashMap<String, Object> inputValues = new HashMap<String, Object>();
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(runnable);
        Collection paramDefns = task.getParameterDefns(false);
        Iterator iter = paramDefns.iterator();
        while (iter.hasNext()) {
            IParameterDefnBase pBase = (IParameterDefnBase)iter.next();
            if (!(pBase instanceof IScalarParameterDefn)) continue;
            IScalarParameterDefn paramDefn = (IScalarParameterDefn)pBase;
            String paramName = paramDefn.getName();
            String inputValue = (String)this.params.get(paramName);
            int paramType = paramDefn.getDataType();
            try {
                Object paramValue = this.stringToObject(paramType, inputValue);
                if (paramValue == null) continue;
                inputValues.put(paramName, paramValue);
            }
            catch (BirtException ex) {
                logger.log(Level.SEVERE, "the value of parameter " + paramName + " is invalid", ex);
            }
        }
        return inputValues;
    }

    protected Object stringToObject(int type, String value) throws BirtException {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 5: {
                return DataTypeUtil.toBoolean((Object)value);
            }
            case 4: {
                return DataTypeUtil.toDate((Object)value);
            }
            case 3: {
                return DataTypeUtil.toBigDecimal((Object)value);
            }
            case 2: {
                return DataTypeUtil.toDouble((Object)value);
            }
            case 1: {
                return DataTypeUtil.toString((Object)value);
            }
        }
        return null;
    }

    protected void checkTargetFileName() {
        File designFile;
        String designFileName;
        int n;
        String fileExt = "." + this.format;
        if ("Run".equalsIgnoreCase(this.mode)) {
            fileExt = ".rptdocument";
        }
        if ((n = (designFileName = (designFile = new File(new File(this.source).getAbsolutePath())).getName()).lastIndexOf(46)) != -1) {
            designFileName = designFileName.substring(0, n);
        }
        if (this.targetFile == null) {
            this.targetFile = designFile.getParent() + File.separatorChar + designFileName + fileExt;
        } else if (!this.targetFile.toLowerCase().endsWith(fileExt.toLowerCase())) {
            this.targetFile = this.targetFile + File.separatorChar + designFileName + fileExt;
            File file = new File(this.targetFile);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
        }
    }

    static {
        $assertionsDisabled = !ReportRunner.class.desiredAssertionStatus();
        logger = Logger.getLogger(ReportRunner.class.getName());
    }
}

