/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import java.net.URI;
import org.eclipse.birt.report.engine.css.engine.value.Messages;
import org.w3c.dom.DOMException;

public abstract class AbstractValueFactory {
    public abstract String getPropertyName();

    protected DOMException createInvalidIdentifierDOMException(String ident) {
        Object[] p = new Object[]{this.getPropertyName(), ident};
        String s = Messages.formatMessage("invalid.identifier", p);
        return new DOMException(12, s);
    }

    protected DOMException createInvalidLexicalUnitDOMException(short type) {
        Object[] p = new Object[]{this.getPropertyName(), new Integer(type)};
        String s = Messages.formatMessage("invalid.lexical.unit", p);
        return new DOMException(9, s);
    }

    protected DOMException createInvalidFloatTypeDOMException(short t) {
        Object[] p = new Object[]{this.getPropertyName(), new Integer(t)};
        String s = Messages.formatMessage("invalid.float.type", p);
        return new DOMException(15, s);
    }

    protected DOMException createInvalidFloatValueDOMException(float f) {
        Object[] p = new Object[]{this.getPropertyName(), new Float(f)};
        String s = Messages.formatMessage("invalid.float.value", p);
        return new DOMException(15, s);
    }

    protected DOMException createInvalidStringTypeDOMException(short t) {
        Object[] p = new Object[]{this.getPropertyName(), new Integer(t)};
        String s = Messages.formatMessage("invalid.string.type", p);
        return new DOMException(15, s);
    }

    protected DOMException createMalformedLexicalUnitDOMException() {
        Object[] p = new Object[]{this.getPropertyName()};
        String s = Messages.formatMessage("malformed.lexical.unit", p);
        return new DOMException(15, s);
    }

    protected DOMException createDOMException() {
        Object[] p = new Object[]{this.getPropertyName()};
        String s = Messages.formatMessage("invalid.access", p);
        return new DOMException(9, s);
    }

    protected static String resolveURI(URI base, String value) {
        try {
            return base.resolve(value).toString();
        }
        catch (Exception ex) {
            return value;
        }
    }
}

