/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractLengthManager;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends AbstractLengthManager {
    protected static final StringMap values;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getPropertyName() {
        return "line-height";
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public Value getDefaultValue() {
        return CSSValueConstants.NORMAL_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                String s = lu.getStringValue().toLowerCase().intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return (Value)v;
            }
        }
        return super.createValue(lu, engine);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 21: {
                    return value;
                }
                case 2: {
                    float scale = value.getFloatValue();
                    IStyle cs = elt.getComputedStyle();
                    if (!$assertionsDisabled && cs == null) {
                        throw new AssertionError();
                    }
                    Value fontSize = (Value)cs.getProperty(38);
                    if (!$assertionsDisabled && fontSize == null) {
                        throw new AssertionError();
                    }
                    float fs = fontSize.getFloatValue();
                    return new FloatValue(1, fs * scale);
                }
            }
        }
        return super.computeValue(elt, engine, idx, value);
    }

    static {
        $assertionsDisabled = !LineHeightManager.class.desiredAssertionStatus();
        values = new StringMap();
        values.put("normal", CSSValueConstants.NORMAL_VALUE);
    }
}

