/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.List;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ListGroupContent;
import org.eclipse.birt.report.engine.content.impl.TableGroupContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.MultiLineItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ImageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;

public class OnPageBreakLayoutPageHandle
implements ILayoutPageHandler {
    ExecutionContext executionContext;

    public OnPageBreakLayoutPageHandle(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public void onPage(long page, Object context) {
        if (this.executionContext == null) {
            return;
        }
        List openningContents = this.executionContext.getAllOnPageBreaks();
        IResultSet currentRset = this.executionContext.getResultSet();
        block13: for (int i = 0; i < openningContents.size(); ++i) {
            Object[] pageBreakEvent = (Object[])openningContents.get(i);
            IResultSet rset = (IResultSet)pageBreakEvent[0];
            this.executionContext.setResultSet(rset);
            IContent content = (IContent)pageBreakEvent[1];
            ReportItemDesign design = (ReportItemDesign)content.getGenerateBy();
            int contentType = content.getContentType();
            switch (contentType) {
                case 1: {
                    CellScriptExecutor.handleOnPageBreak((ICellContent)content, this.executionContext);
                    continue block13;
                }
                case 3: {
                    DataItemScriptExecutor.handleOnPageBreak((IDataContent)content, this.executionContext);
                    continue block13;
                }
                case 4: {
                    if (!(design instanceof MultiLineItemDesign)) continue block13;
                    DynamicTextScriptExecutor.handleOnPageBreak((IForeignContent)content, this.executionContext);
                    continue block13;
                }
                case 5: {
                    ImageScriptExecutor.handleOnPageBreak((IImageContent)content, this.executionContext);
                    continue block13;
                }
                case 6: {
                    LabelScriptExecutor.handleOnPageBreak((ILabelContent)content, this.executionContext);
                    continue block13;
                }
                case 8: {
                    RowScriptExecutor.handleOnPageBreak((IRowContent)content, this.executionContext);
                    continue block13;
                }
                case 13: {
                    ListScriptExecutor.handleOnPageBreak((IListContent)content, this.executionContext);
                    continue block13;
                }
                case 10: {
                    if (design instanceof TableItemDesign) {
                        TableScriptExecutor.handleOnPageBreak((ITableContent)content, this.executionContext);
                        continue block13;
                    }
                    if (!(design instanceof GridItemDesign)) continue block13;
                    GridScriptExecutor.handleOnPageBreak((ITableContent)content, this.executionContext);
                    continue block13;
                }
                case 17: {
                    TableGroupScriptExecutor.handleOnPageBreak((TableGroupContent)content, this.executionContext);
                    continue block13;
                }
                case 16: {
                    ListGroupScriptExecutor.handleOnPageBreak((ListGroupContent)content, this.executionContext);
                    continue block13;
                }
                case 11: {
                    TextItemScriptExecutor.handleOnPageBreak((ITextContent)content, this.executionContext);
                }
            }
        }
        this.executionContext.setResultSet(currentRset);
    }
}

