/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.CellExecutor;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;

public class RowExecutor
extends QueryItemExecutor {
    int rowId;
    boolean startOfGroup;
    int currentCell;

    protected RowExecutor(ExecutorManager manager) {
        super(manager);
    }

    void setRowId(int rowId) {
        this.rowId = rowId;
    }

    int getRowId() {
        return this.rowId;
    }

    public IContent execute() {
        RowDesign rowDesign = (RowDesign)this.getDesign();
        IRowContent rowContent = this.report.createRowContent();
        this.setContent(rowContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(rowDesign, rowContent);
        this.processAction(rowDesign, rowContent);
        this.processBookmark(rowDesign, rowContent);
        this.processStyle(rowDesign, rowContent);
        this.processVisibility(rowDesign, rowContent);
        rowContent.setRowID(this.rowId);
        this.setGroupId(rowContent);
        if (this.context.isInFactory()) {
            RowScriptExecutor.handleOnCreate(rowContent, this.context);
        }
        this.startTOCEntry(rowContent);
        if (this.emitter != null) {
            this.emitter.startRow(rowContent);
        }
        this.currentCell = 0;
        return rowContent;
    }

    private void setGroupId(IRowContent rowContent) {
        IGroupContent group = rowContent.getGroup();
        IBandContent band = rowContent.getBand();
        IResultSet resultSet = this.getParentResultSet();
        if (group != null && band != null && resultSet != null) {
            int bandType = band.getBandType();
            if (bandType == 0) {
                rowContent.setGroupId(resultSet.getGroupId(group.getGroupLevel() + 2));
            } else if (bandType == 3 || bandType == 4) {
                rowContent.setGroupId(resultSet.getGroupId(group.getGroupLevel() + 1));
            }
        }
    }

    public void close() {
        IRowContent rowContent = (IRowContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endRow(rowContent);
        }
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(13, this);
    }

    public boolean hasNextChild() {
        RowDesign rowDesign = (RowDesign)this.design;
        return this.currentCell < rowDesign.getCellCount();
    }

    public IReportItemExecutor getNextChild() {
        RowDesign rowDesign = (RowDesign)this.design;
        if (this.currentCell < rowDesign.getCellCount()) {
            CellDesign cellDesign = rowDesign.getCell(this.currentCell++);
            CellExecutor executor = (CellExecutor)this.manager.createExecutor(this, cellDesign);
            executor.setStartOfGroup(this.startOfGroup && this.currentCell == 1);
            return executor;
        }
        return null;
    }
}

