/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OffsetIndexWriter {
    protected String indexFile;
    protected RandomAccessFile index;
    protected long maxOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OffsetIndexWriter(String indexFile) {
        this.indexFile = indexFile;
    }

    public void open() throws IOException {
        File file = new File(this.indexFile);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        this.index = new RandomAccessFile(file, "rw");
        this.maxOffset = -1L;
    }

    public void close() {
        if (this.index != null) {
            try {
                this.index.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void write(long offset, long value) throws IOException {
        if (!$assertionsDisabled && offset <= this.maxOffset) {
            throw new AssertionError();
        }
        this.index.writeLong(offset);
        this.index.writeLong(value);
        this.maxOffset = offset;
    }

    static {
        $assertionsDisabled = !OffsetIndexWriter.class.desiredAssertionStatus();
    }
}

