/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;

public class HTMLLayoutContext {
    protected String masterPage = null;
    protected boolean allowPageBreak = true;
    protected boolean pageEmpty = true;
    protected boolean finished;
    protected long pageNumber;
    protected HTMLReportLayoutEngine engine;
    boolean cancelFlag = false;
    boolean skipPageHint = false;
    ArrayList pageHint = new ArrayList();
    IContent startContent = null;
    IContent currentContent = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getMasterPage() {
        return this.masterPage;
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    public HTMLLayoutContext(HTMLReportLayoutEngine engine) {
        this.engine = engine;
    }

    public boolean allowPageBreak() {
        return this.allowPageBreak;
    }

    public void setAllowPageBreak(boolean allowPageBreak) {
        this.allowPageBreak = allowPageBreak;
    }

    public boolean isPageEmpty() {
        return this.pageEmpty;
    }

    public void setPageEmpty(boolean pageEmpty) {
        this.pageEmpty = pageEmpty;
    }

    public void setFinish(boolean finished) {
        this.finished = finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    void setCancelFlag(boolean flag) {
        this.cancelFlag = flag;
    }

    boolean getCancelFlag() {
        return this.cancelFlag;
    }

    void setSkipPageHint(boolean skip) {
        this.skipPageHint = skip;
    }

    boolean getSkipPageHint() {
        return this.skipPageHint;
    }

    public void startContent(IContent content) {
        if (!this.skipPageHint) {
            if (this.startContent == null) {
                this.startContent = content;
            }
            this.currentContent = content;
        }
    }

    public void continueContent(IContent content) {
        if (!this.skipPageHint && this.startContent != null) {
            this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
            this.startContent = null;
            this.currentContent = null;
        }
    }

    public void endContent(IContent content) {
    }

    public void endContentWithPageBreak(IContent content) {
        if (!this.skipPageHint && this.startContent != null) {
            this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
            this.startContent = null;
            this.currentContent = null;
        }
    }

    public void skipContent(IContent content) {
        if (!this.skipPageHint && this.startContent != null) {
            this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
            this.startContent = null;
            this.currentContent = null;
        }
    }

    public ArrayList getPageHint() {
        ArrayList<IContent[]> hint = new ArrayList<IContent[]>();
        hint.addAll(this.pageHint);
        if (this.startContent != null) {
            if (!$assertionsDisabled && this.currentContent == null) {
                throw new AssertionError();
            }
            hint.add(new IContent[]{this.startContent, this.currentContent});
        }
        return hint;
    }

    public void clearPageHint() {
        this.pageHint.clear();
        this.startContent = null;
        this.currentContent = null;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    static {
        $assertionsDisabled = !HTMLLayoutContext.class.desiredAssertionStatus();
    }
}

