/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.BufferedReportEmitter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.TableContentLayout;
import org.eclipse.birt.report.engine.internal.content.wrap.CellContentWrapper;
import org.eclipse.birt.report.engine.ir.CellDesign;

public class HTMLTableLayoutEmitter
extends ContentEmitterAdapter {
    private boolean needNestedLayout;
    private TableContentLayout layout;
    private IContentEmitter emitter;
    private IContentEmitter cellEmitter;
    private Stack groupStack = new Stack();
    int nestCellCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLTableLayoutEmitter(IContentEmitter emitter) {
        this.emitter = emitter;
        this.needNestedLayout = false;
    }

    public HTMLTableLayoutEmitter(IContentEmitter emitter, boolean needNestedLayout) {
        this.emitter = emitter;
        this.needNestedLayout = needNestedLayout;
    }

    public void end(IReportContent report) {
        this.emitter.end(report);
    }

    public String getOutputFormat() {
        return this.emitter.getOutputFormat();
    }

    public void initialize(IEmitterServices service) {
        this.emitter.initialize(service);
    }

    public void start(IReportContent report) {
        this.emitter.start(report);
    }

    public void startTable(ITableContent table) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTable(table);
        } else {
            this.layout = new TableContentLayout(table, "viewer");
            this.emitter.startTable(table);
        }
    }

    public void endTable(ITableContent table) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTable(table);
        } else {
            if (!$assertionsDisabled && this.layout == null) {
                throw new AssertionError();
            }
            this.resolveAll();
            this.flush();
            this.emitter.endTable(table);
            this.layout = null;
        }
    }

    public void startTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableGroup(group);
        } else {
            int groupLevel = group.getGroupLevel();
            this.groupStack.push(new Integer(groupLevel));
        }
    }

    public void endTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableGroup(group);
        } else {
            if (!$assertionsDisabled && this.groupStack.isEmpty()) {
                throw new AssertionError();
            }
            this.groupStack.pop();
        }
    }

    private int getGroupLevel() {
        if (!this.groupStack.isEmpty()) {
            return (Integer)this.groupStack.peek();
        }
        return -1;
    }

    public void startTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableBand(band);
        } else if (band.getBandType() == 4) {
            int groupLevel = this.getGroupLevel();
            this.resolveCellsOfDrop(groupLevel, false);
        }
    }

    public void endTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableBand(band);
        } else if (band.getBandType() == 4) {
            int groupLevel = this.getGroupLevel();
            this.resolveCellsOfDrop(groupLevel, true);
        }
    }

    public void startRow(IRowContent row) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startRow(row);
        } else {
            this.layout.createRow(row);
        }
    }

    public void endRow(IRowContent row) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endRow(row);
        } else if (!this.layout.hasDropCell()) {
            this.flush();
        }
    }

    public void startCell(ICellContent cell) {
        ++this.nestCellCount;
        if (this.cellEmitter != null) {
            this.cellEmitter.startCell(cell);
        } else {
            String dropType;
            BufferedReportEmitter buffer = new BufferedReportEmitter(this.emitter);
            this.cellEmitter = this.needNestedLayout ? new HTMLTableLayoutEmitter(buffer, true) : buffer;
            int colId = cell.getColumn();
            int colSpan = cell.getColSpan();
            int rowSpan = cell.getRowSpan();
            CellDesign cellDesign = (CellDesign)cell.getGenerateBy();
            if (cellDesign != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
                rowSpan = this.createDropID(this.getGroupLevel(), dropType);
            }
            this.layout.createCell(colId, rowSpan, colSpan, new CellContent(cell, buffer));
        }
    }

    public void endCell(ICellContent cell) {
        if (!$assertionsDisabled && this.cellEmitter == null) {
            throw new AssertionError();
        }
        --this.nestCellCount;
        if (this.nestCellCount == 0) {
            this.cellEmitter = null;
        } else {
            this.cellEmitter.endCell(cell);
        }
    }

    public void startContent(IContent content) {
        if (this.cellEmitter != null) {
            ContentEmitterUtil.startContent(content, this.cellEmitter);
        } else {
            ContentEmitterUtil.startContent(content, this.emitter);
        }
    }

    public void endContent(IContent content) {
        if (this.cellEmitter != null) {
            ContentEmitterUtil.endContent(content, this.cellEmitter);
        } else {
            ContentEmitterUtil.endContent(content, this.emitter);
        }
    }

    private int createDropID(int groupIndex, String dropType) {
        int dropId = -10 * (groupIndex + 1);
        if ("all".equals(dropType)) {
            --dropId;
        }
        return dropId;
    }

    public void resolveAll() {
        this.layout.resolveDropCells();
    }

    public void resolveCellsOfDrop(int groupLevel, boolean dropAll) {
        if (dropAll) {
            this.layout.resolveDropCells(this.createDropID(groupLevel, "all"));
        } else {
            this.layout.resolveDropCells(this.createDropID(groupLevel, "detail"));
        }
    }

    public void flush() {
        int rowCount = this.layout.getRowCount();
        int colCount = this.layout.getColCount();
        for (int i = 0; i < rowCount; ++i) {
            Row row = this.layout.getRow(i);
            IRowContent rowContent = (IRowContent)row.getContent();
            this.emitter.startRow(rowContent);
            for (int j = 0; j < colCount; ++j) {
                Cell cell = row.getCell(j);
                if (cell.getStatus() == 1) {
                    CellContent content = (CellContent)cell.getContent();
                    CellContentWrapper tempCell = new CellContentWrapper(content.cell);
                    tempCell.setColumn(cell.getColId());
                    tempCell.setRowSpan(cell.getRowSpan());
                    tempCell.setColSpan(cell.getColSpan());
                    this.emitter.startCell(tempCell);
                    if (content.buffer != null) {
                        content.buffer.flush();
                    }
                    this.emitter.endCell(tempCell);
                }
                if (cell.getStatus() != 0) continue;
                IReportContent report = rowContent.getReportContent();
                ICellContent cellContent = report.createCellContent();
                cellContent.setParent(rowContent);
                cellContent.setColumn(cell.getColId() + 1);
                cellContent.setRowSpan(cell.getRowSpan());
                cellContent.setColSpan(cell.getColSpan());
                this.emitter.startCell(cellContent);
                this.emitter.endCell(cellContent);
            }
            this.emitter.endRow(rowContent);
        }
        this.layout.reset();
    }

    static {
        $assertionsDisabled = !HTMLTableLayoutEmitter.class.desiredAssertionStatus();
    }

    private class CellContent
    implements Cell.Content {
        protected ICellContent cell;
        protected BufferedReportEmitter buffer;

        protected CellContent(ICellContent cell, BufferedReportEmitter buffer) {
            this.cell = cell;
            this.buffer = buffer;
        }

        public boolean isEmpty() {
            return this.buffer == null || this.buffer.isEmpty();
        }

        public void reset() {
            this.buffer = null;
        }
    }
}

