/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public class BorderConflictResolver {
    static final int POSITION_LEFT = 0;
    static final int POSITION_TOP = 1;
    static final int POSITION_RIGHT = 2;
    static final int POSITION_BOTTOM = 3;
    static HashMap styleMap = null;
    static /* synthetic */ Class class$org$eclipse$birt$report$engine$layout$pdf$BorderConflictResolver;

    public void resolveTableLeftBorder(IStyle tableLeft, IStyle rowLeft, IStyle columnLeft, IStyle cellLeft, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellLeft, 0), new BorderStyleInfo(columnLeft, 0), new BorderStyleInfo(rowLeft, 0), new BorderStyleInfo(tableLeft, 0)}, new BorderStyleInfo(usedStyle, 0));
    }

    public void resolveTableTopBorder(IStyle tableTop, IStyle rowTop, IStyle columnTop, IStyle cellTop, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(rowTop, 1), new BorderStyleInfo(columnTop, 1), new BorderStyleInfo(tableTop, 1)}, new BorderStyleInfo(usedStyle, 1));
    }

    public void resolveTableBottomBorder(IStyle tableBottom, IStyle rowBottom, IStyle columnBottom, IStyle cellBottom, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellBottom, 3), new BorderStyleInfo(rowBottom, 3), new BorderStyleInfo(columnBottom, 3), new BorderStyleInfo(tableBottom, 3)}, new BorderStyleInfo(usedStyle, 3));
    }

    public void resolveTableRightBorder(IStyle tableRight, IStyle rowRight, IStyle columnRight, IStyle cellRight, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellRight, 2), new BorderStyleInfo(columnRight, 2), new BorderStyleInfo(rowRight, 2), new BorderStyleInfo(tableRight, 2)}, new BorderStyleInfo(usedStyle, 2));
    }

    public void resolveCellLeftBorder(IStyle preColumnRight, IStyle columnLeft, IStyle preCellRight, IStyle cellLeft, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(preCellRight, 2), new BorderStyleInfo(cellLeft, 0), new BorderStyleInfo(preColumnRight, 2), new BorderStyleInfo(columnLeft, 0)}, new BorderStyleInfo(usedStyle, 0));
    }

    public void resolveCellTopBorder(IStyle preRowBottom, IStyle rowTop, IStyle preCellBottom, IStyle cellTop, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(preCellBottom, 3), new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(preRowBottom, 3), new BorderStyleInfo(rowTop, 1)}, new BorderStyleInfo(usedStyle, 1));
    }

    private void resolveBorder(BorderStyleInfo[] styles, BorderStyleInfo usedStyle) {
        for (int i = 0; i < styles.length; ++i) {
            if (!IStyle.HIDDEN_VALUE.equals(styles[i].getBorderStyle())) continue;
            usedStyle.setBorderStyle(IStyle.HIDDEN_VALUE);
            return;
        }
        this.resolveBorderWidth(styles, usedStyle);
    }

    private void resolveBorderWidth(BorderStyleInfo[] styles, BorderStyleInfo usedStyle) {
        int maxWidth = 0;
        int count = 1;
        int maxFirstIndex = 0;
        int[] ws = new int[styles.length];
        for (int i = 0; i < styles.length; ++i) {
            ws[i] = PropertyUtil.getDimensionValue(styles[i].getBorderWidth());
            if (ws[i] > maxWidth) {
                maxWidth = ws[i];
                count = 1;
                maxFirstIndex = i;
                continue;
            }
            if (ws[i] != maxWidth) continue;
            ++count;
        }
        if (count == 1) {
            usedStyle.copyBorder(styles[maxFirstIndex]);
            return;
        }
        ArrayList<BorderStyleInfo> styleList = new ArrayList<BorderStyleInfo>();
        for (int i = 0; i < styles.length; ++i) {
            if (ws[i] != maxWidth) continue;
            styleList.add(styles[i]);
        }
        this.resolveBorderStyle(styleList.toArray(new BorderStyleInfo[styleList.size()]), usedStyle);
    }

    private void resolveBorderStyle(BorderStyleInfo[] styles, BorderStyleInfo usedStyle) {
        int max = 0;
        int maxFirstIndex = 0;
        int[] ss = new int[styles.length];
        for (int i = 0; i < styles.length; ++i) {
            ss[i] = (Integer)styleMap.get(styles[i].getBorderStyle());
            if (ss[i] <= max) continue;
            max = ss[i];
            maxFirstIndex = i;
        }
        usedStyle.copyBorder(styles[maxFirstIndex]);
    }

    static {
        styleMap = new HashMap();
        styleMap.put(IStyle.NONE_VALUE, new Integer(0));
        styleMap.put(IStyle.INSET_VALUE, new Integer(1));
        styleMap.put(IStyle.GROOVE_VALUE, new Integer(2));
        styleMap.put(IStyle.OUTSET_VALUE, new Integer(3));
        styleMap.put(IStyle.RIDGE_VALUE, new Integer(4));
        styleMap.put(IStyle.DOTTED_VALUE, new Integer(5));
        styleMap.put(IStyle.DASHED_VALUE, new Integer(6));
        styleMap.put(IStyle.SOLID_VALUE, new Integer(7));
        styleMap.put(IStyle.DOUBLE_VALUE, new Integer(8));
    }

    protected class BorderStyleInfo {
        private int position;
        private IStyle style;
        static final /* synthetic */ boolean $assertionsDisabled;

        public BorderStyleInfo(IStyle style, int position) {
            this.style = style;
            this.position = position;
        }

        public void setBorderColor(CSSValue value) {
            if (!$assertionsDisabled && this.style == null) {
                throw new AssertionError();
            }
            switch (this.position) {
                case 0: {
                    this.style.setProperty(22, value);
                    break;
                }
                case 2: {
                    this.style.setProperty(23, value);
                    break;
                }
                case 1: {
                    this.style.setProperty(21, value);
                    break;
                }
                case 3: {
                    this.style.setProperty(24, value);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public CSSValue getBorderColor() {
            if (this.style == null) {
                return IStyle.BLACK_RGB_VALUE;
            }
            switch (this.position) {
                case 0: {
                    return this.style.getProperty(22);
                }
                case 2: {
                    return this.style.getProperty(23);
                }
                case 1: {
                    return this.style.getProperty(21);
                }
                case 3: {
                    return this.style.getProperty(24);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return IStyle.BLACK_RGB_VALUE;
        }

        public CSSValue getBorderStyle() {
            if (this.style == null) {
                return IStyle.NONE_VALUE;
            }
            switch (this.position) {
                case 0: {
                    return this.style.getProperty(11);
                }
                case 2: {
                    return this.style.getProperty(12);
                }
                case 1: {
                    return this.style.getProperty(10);
                }
                case 3: {
                    return this.style.getProperty(13);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return IStyle.NONE_VALUE;
        }

        public CSSValue getBorderWidth() {
            if (this.style == null) {
                return null;
            }
            switch (this.position) {
                case 0: {
                    return this.style.getProperty(17);
                }
                case 2: {
                    return this.style.getProperty(18);
                }
                case 1: {
                    return this.style.getProperty(15);
                }
                case 3: {
                    return this.style.getProperty(19);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public void setBorderStyle(CSSValue value) {
            switch (this.position) {
                case 0: {
                    this.style.setProperty(11, value);
                    break;
                }
                case 2: {
                    this.style.setProperty(12, value);
                    break;
                }
                case 1: {
                    this.style.setProperty(10, value);
                    break;
                }
                case 3: {
                    this.style.setProperty(13, value);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void setBorderWidth(CSSValue value) {
            switch (this.position) {
                case 0: {
                    this.style.setProperty(17, value);
                    break;
                }
                case 2: {
                    this.style.setProperty(18, value);
                    break;
                }
                case 1: {
                    this.style.setProperty(15, value);
                    break;
                }
                case 3: {
                    this.style.setProperty(19, value);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void copyBorder(BorderStyleInfo orginal) {
            if (orginal != null) {
                this.setBorderStyle(orginal.getBorderStyle());
                this.setBorderColor(orginal.getBorderColor());
                this.setBorderWidth(orginal.getBorderWidth());
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$layout$pdf$BorderConflictResolver == null ? (class$org$eclipse$birt$report$engine$layout$pdf$BorderConflictResolver = BorderConflictResolver.class$("org.eclipse.birt.report.engine.layout.pdf.BorderConflictResolver")) : class$org$eclipse$birt$report$engine$layout$pdf$BorderConflictResolver).desiredAssertionStatus();
        }
    }
}

