/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFImageLM
extends PDFLeafItemLM {
    protected static final int DEFAULT_WIDHT = 100000;
    protected static final int DEFAULT_HEIGHT = 100000;
    protected IImageContent image;
    protected int maxWidth;
    protected ContainerArea root;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFImageLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, content, emitter, executor);
        this.init();
    }

    protected Dimension getIntrinsicDimension(IImageContent content) throws BadElementException, MalformedURLException, IOException {
        Image image = null;
        switch (content.getImageSource()) {
            case 0: {
                image = Image.getInstance((String)content.getURI());
                break;
            }
            case 1: 
            case 2: {
                image = Image.getInstance((byte[])content.getData());
                break;
            }
            case 3: {
                image = Image.getInstance((URL)new URL(content.getURI()));
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        if (image != null) {
            Object design = content.getGenerateBy();
            int resolution = 96;
            if (design instanceof ExtendedItemDesign) {
                resolution = 192;
            }
            return new Dimension((int)(image.plainWidth() * 1000.0f / (float)resolution * 72.0f), (int)(image.plainHeight() * 1000.0f / (float)resolution * 72.0f));
        }
        return null;
    }

    protected Dimension getSpecifiedDimension(IImageContent content) {
        Dimension dim = new Dimension(100000, 100000);
        Dimension instrinsic = null;
        try {
            instrinsic = this.getIntrinsicDimension(content);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        boolean scale = false;
        int specifiedWidth = this.getDimensionValue(content.getWidth());
        int specifiedHeight = this.getDimensionValue(content.getHeight());
        if (instrinsic == null) {
            dim.setDimension(specifiedWidth == 0 ? 100000 : specifiedWidth, specifiedHeight == 0 ? 100000 : specifiedHeight);
            return dim;
        }
        if (scale) {
            double ratio = instrinsic.getRatio();
            if (specifiedWidth > 0) {
                if (specifiedHeight > 0) {
                    dim.setDimension(specifiedWidth, specifiedHeight);
                } else {
                    dim.setDimension(specifiedWidth, (int)((double)specifiedWidth / ratio));
                }
            } else if (specifiedHeight > 0) {
                dim.setDimension((int)((double)specifiedHeight * ratio), specifiedHeight);
            } else {
                dim.setDimension(instrinsic.getWidth(), instrinsic.getHeight());
            }
        } else if (specifiedWidth > 0) {
            if (specifiedHeight > 0) {
                dim.setDimension(specifiedWidth, specifiedHeight);
            } else {
                dim.setDimension(specifiedWidth, instrinsic.getHeight());
            }
        } else if (specifiedHeight > 0) {
            dim.setDimension(instrinsic.getWidth(), specifiedHeight);
        } else {
            dim.setDimension(instrinsic.getWidth(), instrinsic.getHeight());
        }
        return dim;
    }

    public boolean layoutChildren() {
        if (this.root == null) {
            return false;
        }
        if (!$assertionsDisabled && !(this.parent instanceof ILineStackingLayoutManager)) {
            throw new AssertionError();
        }
        ILineStackingLayoutManager lineParent = (ILineStackingLayoutManager)((Object)this.parent);
        if (this.root.getAllocatedHeight() > lineParent.getMaxAvaHeight()) {
            if (!this.parent.isPageEmpty()) {
                return true;
            }
            this.parent.addArea(this.root);
            return false;
        }
        if (this.parent.getCurrentIP() + this.root.getAllocatedWidth() > this.maxWidth) {
            if (!lineParent.isEmptyLine()) {
                boolean ret = lineParent.endLine();
                if (!$assertionsDisabled && !ret) {
                    throw new AssertionError();
                }
                return this.layoutChildren();
            }
            this.parent.addArea(this.root);
            return false;
        }
        this.parent.addArea(this.root);
        return false;
    }

    protected void init() {
        if (!$assertionsDisabled && !(this.content instanceof IImageContent)) {
            throw new AssertionError();
        }
        this.image = (IImageContent)this.content;
        this.maxWidth = this.parent.getMaxAvaWidth();
        Dimension content = this.getSpecifiedDimension(this.image);
        IStyle style = this.image.getComputedStyle();
        this.root = (ContainerArea)AreaFactory.createInlineContainer(this.image, true, true);
        int marginWidth = this.getDimensionValue(style.getProperty(31)) + this.getDimensionValue(style.getProperty(32));
        int borderWidth = this.getDimensionValue(style.getProperty(17)) + this.getDimensionValue(style.getProperty(18));
        IStyle areaStyle = this.root.getStyle();
        if (marginWidth > this.maxWidth) {
            areaStyle.setMarginLeft("0");
            areaStyle.setMarginRight("0");
            marginWidth = 0;
        }
        int maxContentWidth = this.maxWidth - marginWidth;
        if (content.getWidth() > maxContentWidth) {
            content.setDimension(maxContentWidth, (int)((double)maxContentWidth / content.getRatio()));
        }
        if (borderWidth > content.getWidth()) {
            areaStyle.setProperty(17, IStyle.NUMBER_0);
            areaStyle.setProperty(18, IStyle.NUMBER_0);
            borderWidth = 0;
        }
        ImageArea imageArea = (ImageArea)AreaFactory.createImageArea(this.image, content);
        this.root.addChild(imageArea);
        imageArea.setPosition(this.getDimensionValue(areaStyle.getProperty(17)), this.getDimensionValue(areaStyle.getProperty(15)));
        this.root.setWidth(content.getWidth());
        this.root.setHeight(content.getHeight());
        this.removePadding(areaStyle);
        imageArea.setWidth(this.root.getContentWidth());
        imageArea.setHeight(this.root.getContentHeight());
    }

    static {
        $assertionsDisabled = !PDFImageLM.class.desiredAssertionStatus();
    }
}

