/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.HashSet;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ITextLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLineAreaLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.text.Compositor;

public class PDFTextLM
extends PDFLeafItemLM
implements ITextLayoutManager {
    private PDFLineAreaLM lineLM = (PDFLineAreaLM)this.getParent();
    private boolean pause = false;
    private Compositor comp = null;
    private ITextContent textContent = null;

    public PDFTextLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, content, emitter, executor);
        ITextContent textContent = (ITextContent)content;
        String text = textContent.getText();
        if (text != null && text.length() != 0) {
            this.transform(textContent);
            this.textContent = textContent;
            this.comp = new Compositor(textContent, this.lineLM.getMaxAvaWidth(), this);
        }
    }

    protected boolean layoutChildren() {
        if (null == this.textContent) {
            return false;
        }
        this.pause = false;
        return this.comp.compose();
    }

    public void addSpaceHolder(IArea con) {
        this.lineLM.addArea(con);
    }

    public boolean needPause() {
        return this.pause;
    }

    public void addTextLine(IArea textLine) {
        this.lineLM.addArea(textLine);
    }

    public void newLine() {
        this.pause = !this.lineLM.endLine();
    }

    public int getFreeSpace() {
        int freeSpace = this.lineLM.getMaxAvaWidth() - this.lineLM.getCurrentIP();
        return freeSpace;
    }

    public void setBaseLevel(int baseLevel) {
        this.lineLM.setBaseLevel(baseLevel);
    }

    public void transform(ITextContent textContent) {
        String transformType = textContent.getComputedStyle().getTextTransform();
        if (transformType.equalsIgnoreCase("uppercase")) {
            textContent.setText(textContent.getText().toUpperCase());
        } else if (transformType.equalsIgnoreCase("lowercase")) {
            textContent.setText(textContent.getText().toLowerCase());
        } else if (transformType.equalsIgnoreCase("capitalize")) {
            textContent.setText(this.capitalize(textContent.getText()));
        }
    }

    private String capitalize(String text) {
        HashSet<Character> splitChar = new HashSet<Character>();
        splitChar.add(new Character(' '));
        splitChar.add(new Character('\n'));
        char[] array = text.toCharArray();
        int index = 0;
        while (index < array.length) {
            Character c = new Character(text.charAt(index));
            while (splitChar.contains(c)) {
                if (++index == array.length) {
                    return new String(array);
                }
                c = new Character(text.charAt(index));
            }
            array[index] = Character.toUpperCase(array[index]);
            while (!splitChar.contains(c) && ++index != array.length) {
                c = new Character(text.charAt(index));
            }
        }
        return new String(array);
    }
}

