/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public class PropertyUtil {
    private static Logger logger = Logger.getLogger(PropertyUtil.class.getName());
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;

    public static boolean isBoldFont(CSSValue value) {
        String weight;
        return value != null && ("bold".equals((weight = value.getCssText()).toLowerCase()) || "bolder".equals(weight.toLowerCase()) || "600".equals(weight) || "700".equals(weight) || "800".equals(weight) || "900".equals(weight));
    }

    public static boolean isInlineElement(IContent content) {
        IStyle style = content.getStyle();
        if (style != null) {
            return "inline".equals(style.getDisplay());
        }
        return false;
    }

    public static void getTextDecoration(String textDecoration) {
    }

    public static int getLineHeight(String lineHeight) {
        try {
            if (lineHeight.equalsIgnoreCase("normal")) {
                return 0;
            }
            return Integer.parseInt(lineHeight);
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, "invalid line height: {0}", lineHeight);
            return 0;
        }
    }

    public static Color getColor(CSSValue value) {
        if (value != null && value instanceof RGBColorValue) {
            RGBColorValue color = (RGBColorValue)value;
            try {
                return new Color(color.getRed().getFloatValue((short)1) / 255.0f, color.getGreen().getFloatValue((short)1) / 255.0f, color.getBlue().getFloatValue((short)1) / 255.0f);
            }
            catch (RuntimeException ex) {
                logger.log(Level.WARNING, "invalid color: {0}", value);
            }
        }
        return null;
    }

    public static String getBackgroundImage(CSSValue value) {
        String strValue;
        if (value != null && value instanceof StringValue && (strValue = ((StringValue)value).getStringValue()) != null && !"none".equals(strValue)) {
            return strValue;
        }
        return null;
    }

    public static int getDimensionValue(String d) {
        if (d == null) {
            return 0;
        }
        try {
            if (d.endsWith("in") || d.endsWith("in")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 72000.0f);
            }
            if (d.endsWith("cm") || d.endsWith("CM")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 72000.0f / 2.54f);
            }
            if (d.endsWith("mm") || d.endsWith("MM")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 7200.0f / 2.54f);
            }
            if (d.endsWith("px") || d.endsWith("PX")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() / 96.0f * 72000.0f);
            }
            return (int)Float.valueOf(d).floatValue();
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static int getDimensionValue(DimensionType d) {
        if (d != null) {
            try {
                String units = d.getUnits();
                if (units.equals("pt") || units.equals("cm") || units.equals("mm") || units.equals("pc") || units.equals("in")) {
                    double point = d.convertTo("pt") * 1000.0;
                    return (int)point;
                }
                if (units.equals("px")) {
                    double point = d.getMeasure() / 72.0 * 72000.0;
                    return (int)point;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
        return 0;
    }

    public static int getDimensionValue(CSSValue value) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
            }
        }
        return 0;
    }

    public static float getPercentageValue(CSSValue value) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            if (2 == fv.getPrimitiveType()) {
                return v / 100.0f;
            }
        }
        return 0.0f;
    }

    public static int getTopAllocatedSpace(IContent content) {
        if (content != null) {
            IStyle style = content.getComputedStyle();
            return PropertyUtil.getDimensionValue(style.getProperty(53)) + PropertyUtil.getDimensionValue(style.getProperty(15)) + PropertyUtil.getDimensionValue(style.getProperty(56));
        }
        return 0;
    }

    public static int getLeftAllocatedSpace(IStyle style) {
        if (style != null) {
            return PropertyUtil.getDimensionValue(style.getProperty(31)) + PropertyUtil.getDimensionValue(style.getProperty(17)) + PropertyUtil.getDimensionValue(style.getProperty(36));
        }
        return 0;
    }

    public static int getRightAllocatedSpace(IStyle style) {
        if (style != null) {
            return PropertyUtil.getDimensionValue(style.getProperty(32)) + PropertyUtil.getDimensionValue(style.getProperty(18)) + PropertyUtil.getDimensionValue(style.getProperty(37));
        }
        return 0;
    }
}

