/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.EngineIRVisitor;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SlotHandle;

public class ReportParser {
    protected static Logger logger;
    private IResourceLocator resourceLocator;
    private String resourcePath;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportParser() {
    }

    public ReportParser(IReportEngine engine) {
        if (engine != null && engine.getConfig() != null) {
            this.resourceLocator = engine.getConfig().getResourceLocator();
            this.resourcePath = engine.getConfig().getResourcePath();
        }
    }

    public ReportParser(ExecutionContext context) {
        if (context != null && context.getEngine() != null && context.getEngine().getConfig() != null) {
            this.resourceLocator = context.getEngine().getConfig().getResourceLocator();
            this.resourcePath = context.getEngine().getConfig().getResourcePath();
        }
    }

    public ReportParser(IResourceLocator resourceLocator, String resourcePath) {
        this.resourceLocator = resourceLocator;
        this.resourcePath = resourcePath;
    }

    public Report parse(String name, InputStream in) throws DesignFileException {
        ReportDesignHandle designHandle = this.getDesignHandle(name, in);
        return this.parse(designHandle);
    }

    public Report parse(String name) throws DesignFileException {
        ReportDesignHandle designHandle = this.getDesignHandle(name, null);
        return this.parse(designHandle);
    }

    public ReportDesignHandle getDesignHandle(String name, InputStream in) throws DesignFileException {
        SessionHandle sessionHandle = DesignEngine.newSession((ULocale)ULocale.getDefault());
        if (this.resourceLocator != null) {
            sessionHandle.setResourceLocator(this.resourceLocator);
        }
        if (this.resourcePath != null) {
            SessionHandle.setBirtResourcePath((String)this.resourcePath);
        }
        ReportDesignHandle designHandle = null;
        designHandle = in != null ? sessionHandle.openDesign(name, in) : sessionHandle.openDesign(name);
        return designHandle;
    }

    public Report parse(ReportDesignHandle design) {
        if (!$assertionsDisabled && design == null) {
            throw new AssertionError();
        }
        EngineIRVisitor visitor = new EngineIRVisitor(design);
        return visitor.translate();
    }

    public ArrayList getParameters(ReportDesignHandle design, boolean includeParameterGroups) {
        if (!$assertionsDisabled && design == null) {
            throw new AssertionError();
        }
        EngineIRVisitor visitor = new EngineIRVisitor(design);
        ArrayList<IParameterDefnBase> parameters = new ArrayList<IParameterDefnBase>();
        SlotHandle paramSlot = design.getParameters();
        for (int i = 0; i < paramSlot.getCount(); ++i) {
            visitor.apply(paramSlot.get(i));
            if (!$assertionsDisabled && visitor.currentElement == null) {
                throw new AssertionError();
            }
            IParameterDefnBase param = (IParameterDefnBase)visitor.currentElement;
            if (!$assertionsDisabled && param.getName() == null) {
                throw new AssertionError();
            }
            parameters.add(param);
        }
        if (includeParameterGroups) {
            return parameters;
        }
        return this.flattenParameter(parameters);
    }

    protected ArrayList flattenParameter(ArrayList params) {
        if (!$assertionsDisabled && params == null) {
            throw new AssertionError();
        }
        ArrayList<IParameterDefnBase> allParameters = new ArrayList<IParameterDefnBase>();
        for (int n = 0; n < params.size(); ++n) {
            IParameterDefnBase param = (IParameterDefnBase)params.get(n);
            if (param.getParameterType() == 4 || param.getParameterType() == 5) {
                allParameters.addAll(this.flattenParameter(((IParameterGroupDefn)param).getContents()));
                continue;
            }
            allParameters.add(param);
        }
        return allParameters;
    }

    static {
        $assertionsDisabled = !ReportParser.class.desiredAssertionStatus();
        logger = Logger.getLogger(ReportParser.class.getName());
    }
}

