/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.Table;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;

public class TableItemDesignLayout {
    Table layout = new Table();

    public void layout(GridItemDesign grid) {
        int i;
        this.layout = new Table(0, grid.getColumnCount());
        this.layout.reset();
        for (i = 0; i < grid.getRowCount(); ++i) {
            this.layoutRow(grid.getRow(i));
        }
        this.layout.resolveDropCells();
        for (i = grid.getColumnCount(); i < this.layout.getColCount(); ++i) {
            grid.addColumn(new ColumnDesign());
        }
        this.normalize();
        for (i = grid.getColumnCount(); i < this.layout.getColCount(); ++i) {
            grid.addColumn(new ColumnDesign());
        }
    }

    protected void normalize() {
        for (int i = 0; i < this.layout.getRowCount(); ++i) {
            Row row = this.layout.getRow(i);
            RowDesign design = (RowDesign)row.getContent();
            design.removeCells();
            for (int j = 0; j < this.layout.getColCount(); ++j) {
                CellDesign cellDesign;
                Cell cell = row.getCell(j);
                if (cell.getStatus() == 0) {
                    cellDesign = new CellDesign();
                    cellDesign.setRowSpan(1);
                    cellDesign.setColSpan(1);
                    cellDesign.setColumn(j);
                    design.addCell(cellDesign);
                }
                if (cell.getStatus() != 1) continue;
                cellDesign = ((CellContent)cell.getContent()).cell;
                cellDesign.setColSpan(cell.getColSpan());
                cellDesign.setRowSpan(cell.getRowSpan());
                cellDesign.setColumn(j);
                design.addCell(cellDesign);
            }
        }
    }

    public void layout(TableItemDesign table) {
        GroupDesign group;
        int i;
        this.layout = new Table(0, table.getColumnCount());
        this.layoutBand((TableBandDesign)table.getHeader());
        for (i = 0; i < table.getGroupCount(); ++i) {
            group = table.getGroup(i);
            TableBandDesign header = (TableBandDesign)group.getHeader();
            this.layoutBand(header);
        }
        this.layoutBand((TableBandDesign)table.getDetail());
        for (i = table.getGroupCount() - 1; i >= 0; --i) {
            group = table.getGroup(i);
            TableBandDesign footer = (TableBandDesign)group.getFooter();
            this.layoutBand(footer);
        }
        this.layoutBand((TableBandDesign)table.getFooter());
        this.normalize();
        for (i = table.getColumnCount(); i < this.layout.getColCount(); ++i) {
            table.addColumn(new ColumnDesign());
        }
    }

    void layoutBand(TableBandDesign band) {
        if (band != null) {
            for (int i = 0; i < band.getRowCount(); ++i) {
                this.layoutRow(band.getRow(i));
            }
            this.layout.resolveDropCells();
        }
    }

    void layoutRow(RowDesign row) {
        this.layout.createRow(row);
        for (int i = 0; i < row.getCellCount(); ++i) {
            CellDesign cell = row.getCell(i);
            int columnNo = cell.getColumn();
            int rowSpan = cell.getRowSpan();
            int colSpan = cell.getColSpan();
            this.layout.createCell(columnNo, rowSpan, colSpan, new CellContent(cell));
        }
    }

    private class CellContent
    implements Cell.Content {
        CellDesign cell;

        CellContent(CellDesign cell) {
            this.cell = cell;
        }

        public boolean isEmpty() {
            return this.cell != null;
        }

        public void reset() {
        }
    }
}

