/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.TextAdapter;
import org.eclipse.birt.chart.device.svg.SVGTextLayout;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Label;

public final class SVGTextMetrics
extends TextAdapter {
    private int iLineCount = 0;
    private Object oText = null;
    private Graphics2D g2d = null;
    private FontMetrics fm = null;
    private SVGTextLayout[] tla = null;
    private String[] fsa = null;
    private transient Object bi = null;
    private Label la = null;
    private final IDisplayServer xs;
    private Insets ins = null;

    public SVGTextMetrics(IDisplayServer _xs, Label _la) {
        if (this.bi == null) {
            this.bi = new BufferedImage(1, 1, 1);
            this.g2d = (Graphics2D)((BufferedImage)this.bi).getGraphics();
            this.g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            this.g2d = (Graphics2D)((BufferedImage)this.bi).getGraphics();
        }
        this.xs = _xs;
        this.la = _la;
        this.computeTextAntialiasing();
        this.reuse(this.la);
    }

    private void computeTextAntialiasing() {
        FontDefinition font = this.la.getCaption().getFont();
        if (font.isBold() || font.getRotation() % 90.0 != 0.0 || font.getSize() > 13.0f) {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public final void reuse(Label la, double forceWrappingSize) {
        Font f = (Font)this.xs.createFont(la.getCaption().getFont());
        this.fm = this.g2d.getFontMetrics(f);
        FontRenderContext frc = this.g2d.getFontRenderContext();
        String s = la.getCaption().getValue();
        if (s == null) {
            s = IConstants.NULL_STRING;
        } else if (s.length() == 0) {
            s = " ";
        }
        String[] sa = this.splitOnBreaks(s, forceWrappingSize);
        if (sa == null) {
            this.iLineCount = 1;
            this.oText = s;
            this.tla = new SVGTextLayout[1];
            this.fsa = new String[1];
            this.tla[0] = new SVGTextLayout(s, f.getAttributes(), frc);
            this.fsa[0] = s;
        } else {
            this.iLineCount = sa.length;
            this.oText = sa;
            this.tla = new SVGTextLayout[this.iLineCount];
            this.fsa = new String[this.iLineCount];
            for (int i = 0; i < this.iLineCount; ++i) {
                this.tla[i] = new SVGTextLayout(sa[i], f.getAttributes(), frc);
                this.fsa[i] = sa[i];
            }
        }
        this.ins = la.getInsets().scaledInstance(this.pointsToPixels());
        if (forceWrappingSize > 0.0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.fsa.length; ++i) {
                sb.append(this.fsa[i]).append("\n");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            la.getCaption().setValue(sb.toString());
        }
    }

    public final void finalize() {
        this.dispose();
    }

    public final double getHeight() {
        return this.fm.getHeight();
    }

    public final double getDescent() {
        return this.fm.getDescent();
    }

    private final double stringWidth() {
        if (this.iLineCount > 1) {
            double dMaxWidth = 0.0;
            for (int i = 0; i < this.iLineCount; ++i) {
                Rectangle2D r2d = this.fm.getStringBounds(this.fsa[0], this.g2d);
                double dWidth = r2d.getWidth();
                if (!(dWidth > dMaxWidth)) continue;
                dMaxWidth = dWidth;
            }
            return Math.max(0.0, dMaxWidth);
        }
        if (this.iLineCount == 1) {
            double w = this.fm.getStringBounds(this.fsa[0], this.g2d).getWidth();
            return Math.max(0.0, w);
        }
        return 0.0;
    }

    final double pointsToPixels() {
        return (double)this.xs.getDpiResolution() / 72.0;
    }

    public final double getFullHeight() {
        return this.getHeight() * (double)this.getLineCount() + (this.ins.getTop() + this.ins.getBottom());
    }

    public final double getFullWidth() {
        return this.stringWidth() + (this.ins.getLeft() + this.ins.getRight());
    }

    public final int getLineCount() {
        return this.iLineCount;
    }

    public final String getLine(int iIndex) {
        return this.iLineCount > 1 ? ((String[])this.oText)[iIndex] : (String)this.oText;
    }

    public final SVGTextLayout getLayout(int iIndex) {
        return this.iLineCount > 1 ? this.tla[iIndex] : this.tla[0];
    }

    private String[] splitOnBreaks(String s, double maxSize) {
        int j;
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        do {
            String ss;
            if ((j = s.indexOf(10, i)) == -1) {
                j = s.length();
            }
            if ((ss = s.substring(i, j).trim()) != null && ss.length() > 0) {
                if (maxSize > 0.0) {
                    Rectangle2D size = this.fm.getStringBounds(ss, this.g2d);
                    if (size.getWidth() > maxSize) {
                        int estCount = (int)(maxSize / size.getWidth()) * ss.length();
                        if (estCount < 1) {
                            estCount = ss.length();
                        }
                        int curPos = 0;
                        while (ss.length() > 0) {
                            String fs = ss.substring(0, Math.min(estCount, ss.length()));
                            Rectangle2D fsize = this.fm.getStringBounds(fs, this.g2d);
                            if (fsize.getWidth() <= maxSize) {
                                al.add(fs);
                                curPos = fs.length();
                            } else {
                                boolean matched = false;
                                for (int curCount = Math.min(estCount - 1, ss.length()); curCount > 1; --curCount) {
                                    fs = ss.substring(0, curCount);
                                    fsize = this.fm.getStringBounds(fs, this.g2d);
                                    if (!(fsize.getWidth() <= maxSize)) continue;
                                    al.add(fs);
                                    curPos = fs.length();
                                    matched = true;
                                    break;
                                }
                                if (!matched) {
                                    al.add(fs);
                                    curPos = fs.length();
                                }
                            }
                            ss = ss.substring(curPos);
                            curPos = 0;
                        }
                    } else {
                        al.add(ss);
                    }
                } else {
                    al.add(ss);
                }
            }
            i = j + 1;
        } while (j != -1 && j < s.length());
        int n = al.size();
        if (n == 1 || n == 0) {
            return null;
        }
        String[] sa = new String[n];
        for (i = 0; i < al.size(); ++i) {
            sa[i] = (String)al.get(i);
        }
        return sa;
    }

    public void dispose() {
        if (this.bi != null) {
            ((BufferedImage)this.bi).flush();
            this.bi = null;
            this.g2d.dispose();
            this.g2d = null;
        }
    }
}

