/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import com.ibm.icu.util.ULocale;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.svg.SVGDisplayServer;
import org.eclipse.birt.chart.device.svg.SVGGraphics2D;
import org.eclipse.birt.chart.device.svg.SVGRendererImpl;
import org.eclipse.birt.chart.device.svg.SVGTextLayout;
import org.eclipse.birt.chart.device.svg.SVGTextMetrics;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;

final class SVGTextRenderer
implements IConstants {
    private static SVGTextRenderer _tr = null;
    private SVGDisplayServer _sxs = null;

    private SVGTextRenderer() {
    }

    public static final synchronized SVGTextRenderer instance(SVGDisplayServer sxs) {
        if (_tr == null) {
            _tr = new SVGTextRenderer();
        }
        SVGTextRenderer._tr._sxs = sxs;
        return _tr;
    }

    public final void renderShadowAtLocation(IPrimitiveRenderer idr, int iLabelPosition, Location lo, Label la) throws ChartException {
        ColorDefinition cdShadow = la.getShadowColor();
        if (cdShadow == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "exception.undefined.shadow.color", Messages.getResourceBundle((ULocale)this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)idr).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(la.getCaption().getFont()));
        switch (iLabelPosition) {
            case 3: {
                this.showTopValue(idr, lo, la, true);
                break;
            }
            case 4: {
                this.showBottomValue(idr, lo, la, true);
                break;
            }
            case 1: {
                this.showLeftValue(idr, lo, la, true);
                break;
            }
            case 2: {
                this.showRightValue(idr, lo, la, true);
            }
        }
    }

    public final void renderTextAtLocation(IPrimitiveRenderer ipr, int iLabelPosition, Location lo, Label la) throws ChartException {
        ColorDefinition cdText = la.getCaption().getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "exception.undefined.text.color", Messages.getResourceBundle((ULocale)this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(la.getCaption().getFont()));
        switch (iLabelPosition) {
            case 3: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showTopValue(ipr, lo, la, true);
                }
                this.showTopValue(ipr, lo, la, false);
                break;
            }
            case 4: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showBottomValue(ipr, lo, la, true);
                }
                this.showBottomValue(ipr, lo, la, false);
                break;
            }
            case 1: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showLeftValue(ipr, lo, la, true);
                }
                this.showLeftValue(ipr, lo, la, false);
                break;
            }
            case 2: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showRightValue(ipr, lo, la, true);
                }
                this.showRightValue(ipr, lo, la, false);
            }
        }
    }

    public final void renderTextInBlock(IDeviceRenderer idr, Bounds boBlock, TextAlignment taBlock, Label la) throws ChartException {
        Text t = la.getCaption();
        String sText = t.getValue();
        FontDefinition fd = t.getFont();
        ColorDefinition cdText = t.getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "exception.undefined.text.color", Messages.getResourceBundle((ULocale)this._sxs.getULocale()));
        }
        IDisplayServer xs = idr.getDisplayServer();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        g2d.setFont((Font)xs.createFont(fd));
        la.getCaption().setValue(sText);
        BoundingBox bb = null;
        try {
            bb = Methods.computeBox((IDisplayServer)xs, (int)3, (Label)la, (double)0.0, (double)0.0);
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)uiex);
        }
        if (taBlock == null) {
            taBlock = AttributeFactory.eINSTANCE.createTextAlignment();
            taBlock.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            taBlock.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
        }
        HorizontalAlignment haBlock = taBlock.getHorizontalAlignment();
        VerticalAlignment vaBlock = taBlock.getVerticalAlignment();
        switch (haBlock.getValue()) {
            case 1: {
                bb.setLeft(boBlock.getLeft() + (boBlock.getWidth() - bb.getWidth()) / 2.0);
                break;
            }
            case 0: {
                bb.setLeft(boBlock.getLeft());
                break;
            }
            case 2: {
                bb.setLeft(boBlock.getLeft() + boBlock.getWidth() - bb.getWidth());
            }
        }
        switch (vaBlock.getValue()) {
            case 0: {
                bb.setTop(boBlock.getTop());
                break;
            }
            case 1: {
                bb.setTop(boBlock.getTop() + (boBlock.getHeight() - bb.getHeight()) / 2.0);
                break;
            }
            case 2: {
                bb.setTop(boBlock.getTop() + boBlock.getHeight() - bb.getHeight());
            }
        }
        bb.setLeft(bb.getLeft() + bb.getHotPoint());
        if (ChartUtil.isShadowDefined((Label)la)) {
            this.showTopValue((IPrimitiveRenderer)idr, LocationImpl.create((double)bb.getLeft(), (double)(bb.getTop() + bb.getHeight())), la, true);
        }
        this.showTopValue((IPrimitiveRenderer)idr, LocationImpl.create((double)bb.getLeft(), (double)(bb.getTop() + bb.getHeight())), la, false);
    }

    private final void showLeftValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        SVGGraphics2D g2d = (SVGGraphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        double dX = lo.getX();
        double dY = lo.getY();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        double dSineTheta = Math.sin(dAngleInRadians);
        double dCosTheta = Math.cos(dAngleInRadians);
        SVGTextMetrics itm = new SVGTextMetrics((IDisplayServer)this._sxs, la);
        double dFW = itm.getFullWidth();
        double dH = itm.getHeight();
        double dD = itm.getDescent();
        double dFH = itm.getFullHeight();
        double dXOffset = 0.0;
        double dW = 0.0;
        int iLC = itm.getLineCount();
        Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
        HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
        boolean bRightAligned = ha.getValue() == 2;
        boolean bCenterAligned = ha.getValue() == 1;
        double dRotateX = dX - dFW;
        double dRotateY = dY + dH / 2.0;
        dX -= dFW;
        dY += dH / 2.0;
        if (dAngleInDegrees == 0.0) {
            double dYHalfOffset = (dFH + dH) / 2.0;
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dYHalfOffset + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
        } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
            double dDeltaX = dFW - dFW * dCosTheta;
            double dDeltaY = dFW * dSineTheta + dH / 2.0;
            dX += dDeltaX;
            dY -= dDeltaY;
            g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dFH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dFH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dFH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < itm.getLineCount(); ++i) {
                    SVGTextLayout tl = itm.getLayout(iLC - i - 1);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
        } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
            double dDeltaX = dFW - dFW * dCosTheta - dH * dSineTheta;
            double dDeltaY = dFW * dSineTheta + dH / 2.0 - dH * dCosTheta;
            dX += dDeltaX;
            dY -= dDeltaY;
            g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
        } else if (dAngleInDegrees == 90.0) {
            double dDeltaX = dFW;
            double dDeltaY = (dFW - dH) / 2.0;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dFH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dFH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dFH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        } else if (dAngleInDegrees == -90.0) {
            double dDeltaX = dFW - dH;
            double dDeltaY = (dFW + dH) / 2.0;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dFH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dFH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dFH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        }
        itm.dispose();
    }

    private final void showRightValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        SVGGraphics2D g2d = (SVGGraphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        double dX = lo.getX();
        double dY = lo.getY();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        dY += 1.0;
        SVGTextMetrics itm = new SVGTextMetrics((IDisplayServer)this._sxs, la);
        double dFW = itm.getFullWidth();
        double dH = itm.getHeight();
        double dD = itm.getDescent();
        double dFH = itm.getFullHeight();
        double dXOffset = 0.0;
        double dW = 0.0;
        int iLC = itm.getLineCount();
        Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
        HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
        boolean bRightAligned = ha.getValue() == 2;
        boolean bCenterAligned = ha.getValue() == 1;
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        int iRotateX = (int)dX;
        int iRotateY = (int)(dY + dH / 2.0);
        dY += dH / 2.0;
        if (dAngleInDegrees == 0.0) {
            double dYHalfOffset = (dFH + dH) / 2.0;
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dYHalfOffset + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
        } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
            double dDeltaX = dH * Math.sin(dAngleInRadians);
            double dDeltaY = dH * Math.cos(dAngleInRadians) - dH / 2.0;
            dX -= dDeltaX;
            dY += dDeltaY;
            g2d.rotate(dAngleInRadians, (double)iRotateX - dDeltaX, (double)iRotateY + dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, (double)iRotateX - dDeltaX, (double)iRotateY + dDeltaY);
        } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
            double dDeltaY = -dH / 2.0;
            dY += dDeltaY;
            g2d.rotate(dAngleInRadians, iRotateX, (double)iRotateY + dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dFH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dFH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dFH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) - ins.getBottom()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, iRotateX, (double)iRotateY + dDeltaY);
        } else if (dAngleInDegrees == 90.0) {
            double dDeltaX = dH;
            double dDeltaY = (dFW - dH) / 2.0;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        } else if (dAngleInDegrees == -90.0) {
            double dDeltaX = 0.0;
            double dDeltaY = (dFW + dH) / 2.0;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        }
        itm.dispose();
    }

    private final void showBottomValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        SVGGraphics2D g2d = (SVGGraphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        double dX = lo.getX();
        double dY = lo.getY();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        SVGTextMetrics itm = new SVGTextMetrics((IDisplayServer)this._sxs, la);
        double dFW = itm.getFullWidth();
        double dH = itm.getHeight();
        double dD = itm.getDescent();
        double dFH = itm.getFullHeight();
        double dXOffset = 0.0;
        double dW = 0.0;
        int iLC = itm.getLineCount();
        Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
        HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
        boolean bRightAligned = ha.getValue() == 2;
        boolean bCenterAligned = ha.getValue() == 1;
        dX -= dFW / 2.0;
        dY += dH;
        if (dAngleInDegrees == 0.0) {
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
        } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
            double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
            double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
            double dDeltaX = dFW * dCosTheta - dH * dSineTheta - dFW / 2.0;
            double dDeltaY = dH * dCosTheta + dFW * dSineTheta - dH;
            g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY += dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
            g2d.rotate(dAngleInRadians, dX += dFW / 2.0, dY - dH);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY - dH);
        } else if (dAngleInDegrees == 90.0) {
            double dYHalfOffset = (dFH + dH) / 2.0;
            double dDeltaX = (dFW + dH) / 2.0;
            double dDeltaY = dFW - dH;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dYHalfOffset + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(iLC - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        } else if (dAngleInDegrees == -90.0) {
            dX += dFW / 2.0;
            double dYHalfOffset = (dFH + dH) / 2.0;
            double dDeltaX = dYHalfOffset - dFH / 2.0;
            g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY -= dH);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dYHalfOffset + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < iLC; ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dYHalfOffset + dH * (double)(i + 1) + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        }
        itm.dispose();
    }

    private final void showTopValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        SVGGraphics2D g2d = (SVGGraphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        double dX = lo.getX();
        double dY = lo.getY();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        SVGTextMetrics itm = new SVGTextMetrics((IDisplayServer)this._sxs, la);
        double dFW = itm.getFullWidth();
        double dH = itm.getHeight();
        double dD = itm.getDescent();
        double dFH = itm.getFullHeight();
        double dXOffset = 0.0;
        double dW = 0.0;
        int iLC = itm.getLineCount();
        Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
        HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
        boolean bRightAligned = ha.getValue() == 2;
        boolean bCenterAligned = ha.getValue() == 1;
        dX -= dFW / 2.0;
        if (dAngleInDegrees == 0.0) {
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dFH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dFH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dFH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < itm.getLineCount(); ++i) {
                    SVGTextLayout tl = itm.getLayout(iLC - i - 1);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
        } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
            double dDeltaX = dFW / 2.0;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dFH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dFH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dFH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < itm.getLineCount(); ++i) {
                    SVGTextLayout tl = new SVGTextLayout(itm.getLine(iLC - i - 1), g2d.getFont().getAttributes(), g2d.getFontRenderContext());
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
            double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
            double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
            g2d.rotate(dAngleInRadians, dX -= dFW / 2.0 - (dFW - dFW * dCosTheta), dY -= dFW * dSineTheta);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dFH + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dFH + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dFH + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < itm.getLineCount(); ++i) {
                    SVGTextLayout tl = itm.getLayout(iLC - i - 1);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        } else if (dAngleInDegrees == 90.0) {
            double dYHalfOffset = (dFH + dH) / 2.0;
            double dDeltaX = (dFW + dH) / 2.0;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dYHalfOffset + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < itm.getLineCount(); ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(itm.getLineCount() - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        } else if (dAngleInDegrees == -90.0) {
            double dYHalfOffset = (dFH + dH) / 2.0;
            double dDeltaX = (dFW - dH) / 2.0;
            double dDeltaY = dFW;
            g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
            if (bShadow) {
                g2d.setPaint(new GradientPaint(new Point2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + 3.0 + dFW, dY - dYHalfOffset + 3.0 + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                g2d.fill(new Rectangle2D.Double(dX + 3.0, dY - dYHalfOffset + 3.0, dFW, dFH), false);
            } else {
                Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                if (clrBackground != null) {
                    g2d.setColor(clrBackground);
                    g2d.fill(r2d);
                }
                g2d.setColor(clrText);
                for (int i = 0; i < itm.getLineCount(); ++i) {
                    SVGTextLayout tl = itm.getLayout(i);
                    if (bRightAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                    } else if (bCenterAligned) {
                        dW = tl.getBounds().getWidth();
                        dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                    }
                    tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(itm.getLineCount() - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                }
                this.renderOutline(ipr, la.getOutline(), r2d);
            }
            g2d.rotate(-dAngleInRadians, dX, dY);
        }
        itm.dispose();
    }

    private final void renderOutline(IPrimitiveRenderer ipr, LineAttributes lia, Rectangle2D.Double r2d) {
        if (lia != null && lia.isVisible() && lia.getColor() != null) {
            SVGGraphics2D g2d = (SVGGraphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
            Stroke sPrevious = null;
            ColorDefinition cd = lia.getColor();
            Stroke sCurrent = ((SVGRendererImpl)ipr).getCachedStroke(lia);
            if (sCurrent != null) {
                sPrevious = g2d.getStroke();
                g2d.setStroke(sCurrent);
            }
            g2d.setColor((Color)this._sxs.getColor(cd));
            g2d.draw(r2d);
            g2d.setNoFillColor(g2d.getCurrentElement());
            if (sPrevious != null) {
                g2d.setStroke(sPrevious);
            }
        }
    }
}

